/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
declare module 'jodit/config' {
    interface Config {
        video: {
            /**
             * Custom function for parsing video URL to embed code
             * ```javascript
             * Jodit.make('#editor', {
             * 		video: {
             * 			// Defaul behavior
             * 			parseUrlToVideoEmbed: (url, size) => Jodit.modules.Helpers.convertMediaUrlToVideoEmbed(url, size)
             * 		}
             * });
             * ```
             */
            parseUrlToVideoEmbed?: (url: string, { width, height }?: {
                width?: number;
                height?: number;
            }) => string;
            /**
             * Default width for video iframe. Default: 400
             */
            defaultWidth?: number;
            /**
             * Default height for video iframe. Default: 345
             */
            defaultHeight?: number;
        };
    }
}
export {};
