/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
import type { IDictionary } from "../../../types/index";
/**
 * @example
 * ```js
 * const defaultConfig = {
 *   a: {
 *     b: {
 *       c: 2
 *     },
 *     e: 5
 *   },
 *   d: {
 *     g: 7
 *   }
 * };
 *
 * const options = ConfigProto({a: {
 *   b: {
 *     c: 1
 *   }
 * }}, defaultConfig);
 *
 * console.log(options.a.b.c); // 1
 * console.log(options.a.e); // 5
 * console.log(options.d.g); // 7
 *
 * defaultConfig.d.g  = 8;
 * console.log(options.d.g); // 8
 *
 * ```
 */
export declare function ConfigProto(options: IDictionary, proto: IDictionary, deep?: number): IDictionary;
export declare function ConfigFlatten(obj: IDictionary): IDictionary;
/**
 * Returns a plain object from a prototype-based object.
 * ```typescript
 * const editor = Jodit.make('#editor', {
 *   image: {
 *     dialogWidth: 500
 *   }
 * });
 *
 * console.log(editor.o.image.openOnDblClick) // true
 * // But you can't get all options in plain object
 * console.log(JSON.stringify(editor.o.image)); // {"dialogWidth":500}
 *
 * const plain = Jodit.modules.Helpers.ConfigDeepFlatten(editor.o.image);
 * console.log(JSON.stringify(plain)); // {"dialogWidth":500, "openOnDblClick": true, "editSrc": true, ...}
 * ```
 */
export declare function ConfigDeepFlatten(obj: IDictionary): IDictionary;
