/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/hotkeys
 */
import type { IDictionary } from "../../types/index";
declare module 'jodit/config' {
    interface Config {
        /**
         * You can redefine hotkeys for some command
         *
         * @example
         * ```js
         * const jodit = Jodit.make('#editor', {
         *  commandToHotkeys: {
         *      bold: 'ctrl+shift+b',
         *      italic: ['ctrl+i', 'ctrl+b'],
         *  }
         * })
         * ```
         */
        commandToHotkeys: IDictionary<string | string[]>;
    }
}
