<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>برچسب‌ها</title>
    <style>
        @page {
            margin: 5mm;
        }
        body {
            font-family: 'IranSans', sans-serif;
            font-size: 10px;
            line-height: 1.2;
        }
        .label-container {
            width: 48mm; /* عرض استاندارد برچسب */
            height: 23mm; /* ارتفاع استاندارد برچسب */
            padding: 2mm;
            border: 1px solid #ccc;
            box-sizing: border-box;
            text-align: center;
            float: right; /* استفاده از float برای چیدمان کنار هم */
            margin: 1mm;
            overflow: hidden;
        }
        .item-name {
            font-size: 10px;
            font-weight: bold;
            margin-bottom: 2mm;
            word-wrap: break-word;
            height: 2.4em; /* محدود کردن ارتفاع به دو خط */
            overflow: hidden;
        }
        .barcode {
            margin-bottom: 2mm;
        }
        .sku {
            font-family: monospace;
            font-size: 9px;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
    </style>
</head>
<body>

<div class="clearfix">
    @foreach($items as $item)
        <div class="label-container">
            <div class="item-name">{{ $item->name }}</div>
            <div class="barcode">
                <img src="data:image/png;base64,{{ $barcodes[$item->id] }}">
            </div>
            <div class="sku">{{ $item->sku }}</div>
        </div>
    @endforeach
</div>

</body>
</html>
