<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>گزارش تاریخچه مالی</title>
    <style>
        body { font-family: 'IranSans', sans-serif; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: right; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
<h1>گزارش تاریخچه تراکنش‌ها</h1>
<p><strong>فیلترها:</strong> تامین‌کننده: {{ $filters['supplier'] }} | وضعیت: {{ $filters['status'] }} | از تاریخ: {{ $filters['start_date'] }} | تا تاریخ: {{ $filters['end_date'] }}</p>
<hr>
<table>
    <thead>
    <tr>
        <th>کد درخواست</th>
        <th>تامین‌کننده</th>
        <th>مبلغ (تومان)</th>
        <th>وضعیت</th>
        <th>تاریخ پرداخت</th>
        <th>کد رهگیری</th>
    </tr>
    </thead>
    <tbody>
    @foreach($logs as $log)
        <tr>
            <td>{{ $log->payable?->purchaseRequest?->request_code ?? '-' }}</td>
            <td>{{ $log->payable?->supplier?->company_name ?? 'N/A' }}</td>
            <td>{{ number_format($log->amount) }}</td>
            <td>{{ $log->status }}</td>
            <td>{{ $log->paid_at ? verta($log->paid_at)->format('Y/m/d H:i') : '-' }}</td>
            <td>{{ $log->meta['ref_id'] ?? $log->transaction_id ?? '-' }}</td>
        </tr>
    @endforeach
    </tbody>
</table>
</body>
</html>
<?php
