<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>فاکتور فروش</title>
    <style>
        body {
            /* ما به صورت مستقیم از نام فونتی که در config/pdf.php تعریف کردیم، استفاده می‌کنیم. */
            font-family: 'IranSans', sans-serif;
            font-size: 10px;
        }
        .invoice-box {
            width: 100%;
            margin: auto;
            padding: 15px;
            font-size: 14px;
            line-height: 24px;
            color: #555;
        }
        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: right;
            border-collapse: collapse;
        }
        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }
        .invoice-box .top table td {
            padding-bottom: 20px;
        }
        .invoice-box .information table td {
            padding-bottom: 40px;
        }
        .invoice-box .heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
            text-align: center;
        }
        .invoice-box .item td {
            border-bottom: 1px solid #eee;
            text-align: center;
        }
        .invoice-box .item .description {
            text-align: right;
        }
        .invoice-box .total td {
            border-top: 2px solid #eee;
            font-weight: bold;
            text-align: left;
        }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        h1 {
            font-size: 2em;
            margin-bottom: 0;
        }
    </style>
</head>
<body>

<div class="invoice-box">
    <table cellpadding="0" cellspacing="0">
        <tr class="top">
            <td colspan="5">
                <table>
                    <tr>
                        <td class="title">
                            <h1 style="margin: 0;">فاکتور فروش</h1>
                        </td>

                        <td class="text-left">
                            <strong>شماره فاکتور:</strong> {{ $response->id }}<br>
                            <strong>تاریخ صدور:</strong> {{ now()->format('Y/m/d') }}<br>
                            <strong>کد درخواست خرید:</strong> {{ $response->purchaseRequest->request_code }}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr class="information">
            <td colspan="5">
                <table>
                    <tr>
                        <td class="text-right">
                            <strong>فروشنده:</strong><br>
                            {{ $response->supplier->company_name }}<br>
                            {{ $response->supplier->address }}<br>
                            تلفن: {{ $response->supplier->phone }}
                        </td>

                        <td class="text-left">
                            <strong>خریدار:</strong><br>
                            {{ $response->purchaseRequest->requester->currentTeam->name }}<br>
                            {{-- در اینجا می‌توانید آدرس و تلفن سازمان خریدار را قرار دهید --}}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr class="heading">
            <td class="description">شرح کالا</td>
            <td>مقدار</td>
            <td>قیمت واحد (تومان)</td>
            <td>جمع کل (تومان)</td>
            <td>توضیحات</td>
        </tr>

        @php $grandTotal = 0; @endphp
        @foreach ($response->items as $item)
            @if($item->is_accepted)
                @php
                    $itemTotal = $item->supplied_quantity * $item->price_per_unit;
                    $grandTotal += $itemTotal;
                @endphp
                <tr class="item">
                    <td class="description">{{ $item->originalItem->item_name }}</td>
                    <td>{{ $item->supplied_quantity }} {{ $item->originalItem->unit }}</td>
                    <td>{{ number_format($item->price_per_unit) }}</td>
                    <td>{{ number_format($itemTotal) }}</td>
                    <td class="description">{{ $item->supplier_notes }}</td>
                </tr>
            @endif
        @endforeach

        <tr class="total">
            <td colspan="4">جمع کل:</td>
            <td>{{ number_format($grandTotal) }} تومان</td>
        </tr>
        @if($response->notes)
            <tr>
                <td colspan="5">
                    <hr>
                    <p><strong>یادداشت‌های فروشنده:</strong> {{ $response->notes }}</p>
                </td>
            </tr>
        @endif
    </table>
</div>

</body>
</html>
