<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>برچسب مکان</title>
    <style>
        @page { margin: 5mm; }
        body { font-family: 'vazirmatn', sans-serif; font-size: 10px; line-height: 1.2; }
        .label-container {
            width: 48mm; height: 23mm; padding: 2mm; border: 1px solid #ccc;
            box-sizing: border-box; text-align: center; float: right; margin: 1mm; overflow: hidden;
        }
        .location-name { font-size: 10px; font-weight: bold; margin-bottom: 2mm; word-wrap: break-word; height: 2.4em; overflow: hidden; }
        .barcode { margin-bottom: 2mm; }
        .location-code { font-family: monospace; font-size: 9px; }
        .clearfix::after { content: ""; clear: both; display: table; }
    </style>
</head>
<body>
<div class="clearfix">
    @foreach($locations as $location)
        <div class="label-container">
            <div class="location-name">{{ $location->name }}</div>
            <div class="barcode">
                <img src="data:image/png;base64,{{ $barcodes[$location->id] }}">
            </div>
            <div class="location-code">{{ $location->location_code }}</div>
        </div>
    @endforeach
</div>
</body>
</html>

