<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>گزارش لاگ دما</title>
    <style>
        body { font-family: 'DejaVu Sans', sans-serif; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: right; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
<h1>گزارش لاگ دمای تجهیز: {{ $equipment->name }}</h1>
<p><strong>فیلترها:</strong> بازرس: {{ $filters['auditor'] }} | از تاریخ: {{ $filters['start_date'] }} | تا تاریخ: {{ $filters['end_date'] }}</p>
<hr>
<table>
    <thead>
    <tr>
        <th>تاریخ</th>
        <th>دما (C)</th>
        <th>بازرس</th>
        <th>یادداشت</th>
    </tr>
    </thead>
    <tbody>
    @foreach($logs as $log)
        <tr>
            <td>{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>
            <td>{{ $log->temperature }}</td>
            <td>{{ $log->auditor->name }}</td>
            <td>{{ $log->notes }}</td>
        </tr>
    @endforeach
    </tbody>
</table>
</body>
</html>
