<x-guest-layout>
    <div class="flex flex-col sm:justify-center items-center min-h-screen bg-gray-100 dark:bg-gray-900">
        <div class="w-full max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="flex flex-col lg:flex-row bg-white dark:bg-gray-800 rounded-xl shadow-2xl overflow-hidden">

                {{-- بخش سمت راست: فرم ورود --}}
                <div class="w-full lg:w-1/2 p-8 sm:p-12">
                    <div class="mx-auto w-full max-w-md">
                        <div class="mb-8 text-center">
                            <a href="/">
                                <img src="{{ asset('benchsynclogowhite.png') }}" alt="BenchSync Full Logo" class="h-9 w-auto">
                            </a>
                            <h1 class="mt-6 text-2xl font-bold text-gray-900 dark:text-white">
                                ورود به حساب کاربری
                            </h1>
                            <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                                خوش آمدید! لطفاً اطلاعات خود را وارد کنید.
                            </p>
                        </div>

                        <x-validation-errors class="mb-4" />

                        @session('status')
                        <div class="mb-4 font-medium text-sm text-green-600 dark:text-green-400">
                            {{ $value }}
                        </div>
                        @endsession

                        <form method="POST" action="{{ route('login') }}" class="space-y-6">
                            @csrf

                            {{-- فیلد ایمیل --}}
                            <div>
                                <x-label for="email" value="{{ __('پست الکترونیکی') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-at-sign class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="email" class="block w-full pl-10" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                                </div>
                            </div>

                            {{-- فیلد رمز عبور --}}
                            <div class="mt-4">
                                <x-label for="password" value="{{ __('رمز عبور') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-key-round class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="password" class="block w-full pl-10" type="password" name="password" required autocomplete="current-password" />
                                </div>
                            </div>

                            {{-- بخش "مرا به یاد داشته باش" و "فراموشی رمز عبور" --}}
                            <div class="flex items-center justify-between mt-4">
                                <label for="remember_me" class="flex items-center">
                                    <x-checkbox id="remember_me" name="remember" />
                                    <span class="ms-2 text-sm text-gray-600 dark:text-gray-400">{{ __('مرا به یاد داشته باش') }}</span>
                                </label>

                                @if (Route::has('password.request'))
                                    <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" href="{{ route('password.request') }}">
                                        {{ __('رمز عبور خود را فراموش کرده اید؟') }}
                                    </a>
                                @endif
                            </div>

                            {{-- دکمه ورود --}}
                            <div class="flex items-center justify-end mt-4">
                                <x-button class="w-full justify-center py-3 bg-blue-600 hover:bg-blue-700">
                                    {{ __('ورود') }}
                                </x-button>
                            </div>
                        </form>
                    </div>
                </div>

                {{-- بخش سمت چپ: برندینگ و تصویر --}}
                <div class="hidden lg:flex w-1/2 items-center justify-center bg-gradient-to-br from-blue-700 to-blue-900 p-12 text-white text-center">
                    <div class="w-full">
                        <h2 class="text-3xl font-bold mb-4">مدیریت هوشمند آزمایشگاه</h2>
                        <p class="text-blue-200 max-w-sm mx-auto">
                            دفترچه یادداشت الکترونیک، مدیریت انبار و طرح‌های تحقیقاتی، همه در یک پلتفرم یکپارچه.
                        </p>
                        <div class="mt-10">
                            <x-lucide-microscope class="w-32 h-32 mx-auto text-blue-500/50" stroke-width="1.5" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-guest-layout>
