<x-guest-layout>
    <div class="flex flex-col sm:justify-center items-center min-h-screen bg-gray-100 dark:bg-gray-900">
        <div class="w-full max-w-5xl mx-auto sm:px-6 lg:px-8">
            <div class="flex flex-col lg:flex-row bg-white dark:bg-gray-800 rounded-xl shadow-2xl overflow-hidden">

                {{-- بخش سمت راست: فرم ثبت‌نام --}}
                <div class="w-full lg:w-1/2 p-8 sm:p-12">
                    <div class="mx-auto w-full max-w-md">
                        <div class="mb-8 text-center">
                            <a href="/">
                                <img src="{{ asset('benchsynclogowhite.png') }}" alt="BenchSync Full Logo" class="h-9 w-auto">
                            </a>
                            <h1 class="mt-6 text-2xl font-bold text-gray-900 dark:text-white">
                                ایجاد حساب کاربری جدید
                            </h1>
                            <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                                به خانواده ما بپیوندید و مدیریت آزمایشگاه خود را شروع کنید.
                            </p>
                        </div>

                        <x-validation-errors class="mb-4" />

                        <form method="POST" action="{{ route('register') }}" class="space-y-4">
                            @csrf

                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                {{-- فیلد نام --}}
                                <div>
                                    <x-label for="first_name" value="{{ __('نام') }}" />
                                    <div class="relative mt-1">
                                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                            <x-lucide-user class="w-5 h-5 text-gray-400"/>
                                        </div>
                                        <x-input id="first_name" class="block w-full pl-10" type="text" name="first_name" :value="old('first_name')" required autofocus autocomplete="given-name" />
                                    </div>
                                </div>
                                {{-- فیلد نام خانوادگی --}}
                                <div>
                                    <x-label for="last_name" value="{{ __('نام خانوادگی') }}" />
                                    <div class="relative mt-1">
                                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                            <x-lucide-user class="w-5 h-5 text-gray-400"/>
                                        </div>
                                        <x-input id="last_name" class="block w-full pl-10" type="text" name="last_name" :value="old('last_name')" required autocomplete="family-name" />
                                    </div>
                                </div>
                            </div>

                            {{-- فیلد شناسه کاربری --}}
                            <div>
                                <x-label for="username" value="{{ __('شناسه کاربری') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-hash class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="username" class="block w-full pl-10" type="text" name="username" :value="old('username')" required autocomplete="username" placeholder="مثال: ali.mohammadi" />
                                </div>
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">فقط حروف انگلیسی، اعداد و خط تیره مجاز است.</p>
                            </div>

                            {{-- فیلد ایمیل --}}
                            <div>
                                <x-label for="email" value="{{ __('ایمیل') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-at-sign class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="email" class="block w-full pl-10" type="email" name="email" :value="old('email')" required />
                                </div>
                            </div>

                            {{-- فیلد رمز عبور --}}
                            <div>
                                <x-label for="password" value="{{ __('رمز عبور') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-key-round class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="password" class="block w-full pl-10" type="password" name="password" required autocomplete="new-password" />
                                </div>
                            </div>

                            {{-- فیلد تکرار رمز عبور --}}
                            <div>
                                <x-label for="password_confirmation" value="{{ __('تکرار رمز عبور') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-key-round class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="password_confirmation" class="block w-full pl-10" type="password" name="password_confirmation" required autocomplete="new-password" />
                                </div>
                            </div>

                            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                                <div class="mt-4">
                                    <x-label for="terms">
                                        <div class="flex items-center">
                                            <x-checkbox name="terms" id="terms" required />
                                            <div class="ms-2 text-sm text-gray-600 dark:text-gray-400">
                                                {!! __('I agree to the :terms_of_service and :privacy_policy', [
                                                        'terms_of_service' => '<a target="_blank" href="'.route('terms.show').'" class="underline hover:text-gray-900">'.__('Terms of Service').'</a>',
                                                        'privacy_policy' => '<a target="_blank" href="'.route('policy.show').'" class="underline hover:text-gray-900">'.__('Privacy Policy').'</a>',
                                                ]) !!}
                                            </div>
                                        </div>
                                    </x-label>
                                </div>
                            @endif

                            <div class="pt-4">
                                <x-button class="w-full justify-center py-3 bg-blue-600 hover:bg-blue-700">
                                    {{ __('ثبت نام') }}
                                </x-button>
                            </div>

                            <div class="text-center text-sm">
                                <a class="underline text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md" href="{{ route('login') }}">
                                    {{ __('قبلاً ثبت‌نام کرده‌اید؟ وارد شوید') }}
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                {{-- بخش سمت چپ: برندینگ و تصویر --}}
                <div class="hidden lg:flex w-1/2 items-center justify-center bg-gradient-to-br from-blue-700 to-blue-900 p-12 text-white text-center">
                    <div class="w-full">
                        <h2 class="text-3xl font-bold mb-4">مدیریت هوشمند آزمایشگاه</h2>
                        <p class="text-blue-200 max-w-sm mx-auto">
                            دفترچه یادداشت الکترونیک، مدیریت انبار و طرح‌های تحقیقاتی، همه در یک پلتفرم یکپارچه.
                        </p>
                        <div class="mt-10">
                            <x-lucide-notebook-pen class="w-32 h-32 mx-auto text-blue-500/50" stroke-width="1.5" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-guest-layout>
