
<x-guest-layout>
    <div class="flex flex-col sm:justify-center items-center min-h-screen bg-gray-100 dark:bg-gray-900">
        <div class="w-full max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="flex flex-col lg:flex-row bg-white dark:bg-gray-800 rounded-xl shadow-2xl overflow-hidden">

                {{-- بخش سمت راست: فرم --}}
                <div class="w-full lg:w-1/2 p-8 sm:p-12">
                    <div class="mx-auto w-full max-w-md">
                        <div class="mb-8 text-center">
                            <a href="/">
                                <x-authentication-card-logo class="w-20 h-20 mx-auto" />
                            </a>
                            <h1 class="mt-6 text-2xl font-bold text-gray-900 dark:text-white">
                                بازنشانی رمز عبور
                            </h1>
                            <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                                لطفاً رمز عبور جدید خود را وارد کنید.
                            </p>
                        </div>

                        <x-validation-errors class="mb-4" />

                        <form method="POST" action="{{ route('password.update') }}" class="space-y-4">
                            @csrf

                            <input type="hidden" name="token" value="{{ $request->route('token') }}">

                            {{-- فیلد ایمیل --}}
                            <div class="block">
                                <x-label for="email" value="{{ __('ایمیل') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-at-sign class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="email" class="block w-full pl-10 bg-gray-100 dark:bg-gray-700" type="email" name="email" :value="old('email', $request->email)" required autofocus autocomplete="username" readonly />
                                </div>
                            </div>

                            {{-- فیلد رمز عبور جدید --}}
                            <div class="mt-4">
                                <x-label for="password" value="{{ __('رمز عبور جدید') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-key-round class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="password" class="block w-full pl-10" type="password" name="password" required autocomplete="new-password" />
                                </div>
                            </div>

                            {{-- فیلد تکرار رمز عبور جدید --}}
                            <div class="mt-4">
                                <x-label for="password_confirmation" value="{{ __('تکرار رمز عبور جدید') }}" />
                                <div class="relative mt-1">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                        <x-lucide-key-round class="w-5 h-5 text-gray-400"/>
                                    </div>
                                    <x-input id="password_confirmation" class="block w-full pl-10" type="password" name="password_confirmation" required autocomplete="new-password" />
                                </div>
                            </div>

                            {{-- دکمه ذخیره --}}
                            <div class="flex items-center justify-end pt-4">
                                <x-button class="w-full justify-center py-3 bg-blue-600 hover:bg-blue-700">
                                    {{ __('ذخیره و بازنشانی رمز عبور') }}
                                </x-button>
                            </div>
                        </form>
                    </div>
                </div>

                {{-- بخش سمت چپ: برندینگ --}}
                <div class="hidden lg:flex w-1/2 items-center justify-center bg-gradient-to-br from-blue-700 to-blue-900 p-12 text-white text-center">
                    <div class="w-full">
                        <h2 class="text-3xl font-bold mb-4">مدیریت هوشمند آزمایشگاه</h2>
                        <p class="text-blue-200 max-w-sm mx-auto">
                            امنیت حساب کاربری شما برای ما اهمیت دارد.
                        </p>
                        <div class="mt-10">
                            <x-lucide-shield-check class="w-32 h-32 mx-auto text-blue-500/50" stroke-width="1.5" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-guest-layout>
