@props(['location', 'level' => 0, 'selectedLocations' => []])

<div class="ml-{{ $level * 4 }}">
    <div class="flex items-center justify-between p-2 my-1 rounded-md {{ $level > 0 ? 'bg-gray-50 dark:bg-gray-700/50' : '' }}">
        <div class="flex items-center">
            {{-- چک‌باکس برای هر آیتم --}}
            <input type="checkbox" wire:model.live="selectedLocations" value="{{ $location->id }}" class="ml-2 rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500">
            {{-- آیکون بر اساس نوع مکان --}}
            @if($location->location_type === 'building')
                🏢
            @elseif($location->location_type === 'room')
                🚪
            @elseif(in_array($location->location_type, ['freezer', 'refrigerator', 'tank']))
                ❄️
            @else
                📦
            @endif
            <span class="mr-2 font-semibold text-gray-800 dark:text-gray-200">{{ $location->name }}</span>
            <span class="mr-2 text-xs text-gray-500 dark:text-gray-400 font-mono">({{ $location->location_code }})</span>
            <span class="mr-2 text-xs text-gray-500 dark:text-gray-400">({{ $location->location_type }})</span>
            @if($location->rows && $location->columns)
                <span class="mr-2 text-xs text-gray-400">[{{ $location->rows }}x{{ $location->columns }}]</span>
            @endif
        </div>
        <div class="flex items-center space-x-2 space-x-reverse">
            <a href="{{ route('inventory.locations.barcode', $location) }}" target="_blank" title="چاپ برچسب" class="text-gray-400 hover:text-gray-600">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
            </a>
            {{-- دکمه افزودن فرزند فقط برای مکان‌هایی که می‌توانند فرزند داشته باشند --}}
            @if(count(\App\Livewire\StorageLocationManager::HIERARCHY_RULES[$location->location_type]) > 0)
                <button wire:click="confirmLocationCreation({{ $location->id }})" class="text-sm text-blue-500 hover:underline">افزودن زیرمجموعه</button>
            @endif
            @if(in_array($location->location_type, ['box', 'rack', 'tank']))
                <a href="{{ route('inventory.locations.view', $location) }}" class="text-sm text-green-500 hover:underline">مشاهده</a>
            @endif
            <button wire:click="confirmLocationMove({{ $location->id }})" class="text-sm text-green-500 hover:underline">جابجایی</button>
            <button wire:click="confirmLocationEdit({{ $location->id }})" class="text-sm text-indigo-500 hover:underline">ویرایش</button>
            <button wire:click="confirmLocationDeletion({{ $location->id }})" class="text-sm text-red-500 hover:underline">حذف</button>
        </div>
    </div>

    {{-- بخش بازگشتی: فراخوانی کامپوننت برای فرزندان --}}
    @if($location->children->isNotEmpty())
        <div class="pl-4 border-r-2 dark:border-gray-700">
            @foreach($location->children as $child)
                <x-location-item :location="$child" :level="$level + 1" :selectedLocations="$selectedLocations"/>
            @endforeach
        </div>
    @endif
</div>
