@props(['location', 'level' => 0])

<div class="bg-gray-50 rounded-lg p-3 space-y-2" style="border-right: 3px solid #3b82f6; margin-right: {{ $level * 20 }}px;">
    <div class="flex items-center justify-between">
        <div class="flex items-center">
            @if($location->children->isNotEmpty())
                <button @click="open = !open" class="ml-2 text-gray-500">
                    <x-lucide-chevron-down class="w-4 h-4 transition-transform" ::class="{'rotate-180': !open}"/>
                </button>
            @else
                <div class="w-6"></div> {{-- Placeholder for alignment --}}
            @endif

            {{-- Icon based on type --}}
            @switch($location->locatin_type)
                @case('tank') <x-lucide-cylinder class="w-5 h-5 text-gray-600 mx-2"/> @break
                @case('canister') <x-lucide-circle-dot class="w-5 h-5 text-gray-600 mx-2"/> @break
                @case('rack') <x-lucide-box class="w-5 h-5 text-gray-600 mx-2"/> @break
                @case('cane') <x-lucide-grip-vertical class="w-5 h-5 text-gray-600 mx-2"/> @break
            @endswitch

            <span class="font-semibold text-gray-800">{{ $location->name }}</span>
            <span class="text-xs text-gray-400 font-mono mr-2">({{ $location->location_code }})</span>
        </div>
        <div class="flex items-center gap-1">
            {{-- Action Buttons --}}
            <a href="{{ route('tanks.show', $location) }}" class="p-2 text-gray-400 hover:text-blue-600 rounded-full transition" title="نمایش گرافیکی">
                <x-lucide-layout-grid class="w-4 h-4"/>
            </a>
            <button wire:click.stop="$dispatch('confirmLocationEdit', { locationId: {{ $location->id }} })" class="p-2 text-gray-400 hover:text-indigo-600 rounded-full transition" title="ویرایش">
                <x-lucide-pen class="w-4 h-4"/>
            </button>
            <button wire:click.stop="$dispatch('confirmLocationDeletion', { locationId: {{ $location->id }} })" class="p-2 text-gray-400 hover:text-red-600 rounded-full transition" title="حذف">
                <x-lucide-trash-2 class="w-4 h-4"/>
            </button>
            @if($location->location_type !== 'box' && $location->location_type !== 'cane')
                <button wire:click.stop="$dispatch('confirmLocationCreation', { parentId: {{ $location->id }} })" class="p-2 text-gray-400 hover:text-green-600 rounded-full transition" title="افزودن زیرمجموعه">
                    <x-lucide-plus-circle class="w-4 h-4"/>
                </button>
            @endif
        </div>
    </div>
    @if($location->children->isNotEmpty())
        <div x-show="open" x-collapse class="space-y-2 pt-2">
            @foreach ($location->children as $child)
                <x-tank-item :location="$child" :level="$level + 1" />
            @endforeach
        </div>
    @endif
</div>
