<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('داشبورد') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <!-- بخش کارت‌های آماری -->
            @livewire('dashboard-stats')


            <!-- چیدمان اصلی داشبورد -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                {{-- ستون اصلی (دو سوم) --}}
                <div class="lg:col-span-2 space-y-8">
                    @livewire('calibration-status-widget')
                    {{-- ویجت پیشرفت پروژه --}}
                    @livewire('project-progress-widget')
                    @livewire('my-tasks-widget')

                    {{-- ویجت درخواست‌های فعالیت --}}
                    @livewire('dashboard-activities')

                    @livewire('inventory-forecast-widget')


                    {{-- می‌توانید ویجت‌های دیگری مانند نمودارها را در اینجا اضافه کنید --}}

                </div>

                {{-- ستون کناری (یک سوم) --}}
                <div class="lg:col-span-1 space-y-8">
                    @livewire('team-announcements-widget')
                    @livewire('financial-summary-widget')
                    @livewire('financial-alerts-widget')
                    {{-- ویجت هشدار کمبود موجودی --}}
                    @livewire('low-stock-dashboard-widget')

                    {{-- می‌توانید ویجت‌های دیگری مانند فعالیت‌های اخیر را در اینجا اضافه کنید --}}
                </div>

            </div>
        </div>
    </div>
</x-app-layout>

