<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    {{-- عنوان صفحه به صورت داینامیک از کامپوننت لایووایر دریافت می‌شود --}}
    <title>{{ $title ?? 'پنل مدیریت' }}</title>

{{--    <!-- Tailwind CSS -->--}}
{{--    <script src="https://cdn.tailwindcss.com"></script>--}}

{{--    <!-- Alpine.js for interactivity -->--}}
{{--    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>--}}

{{--    <!-- Google Fonts (Vazirmatn for Persian) -->--}}
{{--    <link rel="preconnect" href="https://fonts.googleapis.com">--}}
{{--    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>--}}
{{--    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">--}}

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Custom Admin CSS -->
    <link rel="stylesheet" href="{{ asset('admin-assets/admin.css') }}">
    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    @livewireStyles
</head>
<body class="bg-gray-100">

<div x-data="{ sidebarOpen: window.innerWidth >= 1024 }" class="flex h-screen bg-gray-200">    <!-- Sidebar -->
    @include('partials._sidebar')

    <!-- Main Content -->
    <div class="flex-1 flex flex-col overflow-hidden">

        <!-- Header -->
        @include('partials._header')

        <!-- Main Content Area (Renders Livewire Component) -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 p-6">
            {{ $slot }}
        </main>
    </div>
</div>

@livewireScripts
</body>
</html>
