<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'پورتال تامین‌کنندگان' }}</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    @vite(['resources/css/app.css', 'resources/js/app.js'])


    <!-- Vazirmatn Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>

{{--    <!-- Alpine.js for interactivity -->--}}
{{--    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>--}}

    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
        }
        .custom-scrollbar::-webkit-scrollbar { width: 6px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #10b981; /* emerald-500 */
            border-radius: 20px;
        }
        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #059669; /* emerald-600 */
        }
        [x-cloak] { display: none !important; }
    </style>
    @livewireStyles
</head>
<body>
<div class="min-h-screen">
    {{-- منوی افقی اختصاصی تامین‌کنندگان --}}
    <header class="bg-gradient-to-r from-emerald-600 to-teal-800 shadow-lg sticky top-0 z-40" x-data="{ mobileMenuOpen: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                {{-- بخش راست منو: لوگو و لینک‌ها --}}
                <div class="flex items-center">
                    <a href="#" class="flex-shrink-0 flex items-center text-white">
                        <x-lucide-truck class="h-8 w-8" />
                        <span class="font-bold text-xl ml-3 mr-2">پورتال تامین‌کنندگان</span>
                    </a>
                    <nav class="hidden md:flex md:ml-10 md:mr-10 md:space-x-8 md:space-x-reverse">
                        <a href="#" class="text-emerald-100 hover:text-white px-3 py-2 rounded-md text-sm font-medium border-b-2 border-white">داشبورد</a>
                        <a href="{{ route('supplier.orders.index') }}" class="text-emerald-200 hover:text-white px-3 py-2 rounded-md text-sm font-medium border-b-2 border-transparent hover:border-white/50">سفارشات من</a>
                        <a href="#" class="text-emerald-200 hover:text-white px-3 py-2 rounded-md text-sm font-medium border-b-2 border-transparent hover:border-white/50">پروفایل شرکت</a>
                    </nav>
                </div>

                {{-- بخش چپ منو: پروفایل کاربر --}}
                <div class="hidden md:flex items-center">
                    <div class="ml-4 relative" x-data="{ profileOpen: false }">
                        <div>
                            <button @click="profileOpen = !profileOpen" type="button" class="max-w-xs bg-emerald-700 rounded-full flex items-center text-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-emerald-800 focus:ring-white" id="user-menu-button" aria-expanded="false" aria-haspopup="true">
                                <span class="sr-only">Open user menu</span>
                                <img class="h-8 w-8 rounded-full" src="https://placehold.co/40x40/10b981/ffffff?text=S" alt="">
                            </button>
                        </div>
                        <div x-show="profileOpen" @click.away="profileOpen = false" x-transition
                             class="origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg py-1 bg-white ring-1 ring-black ring-opacity-5 focus:outline-none" role="menu" aria-orientation="vertical" aria-labelledby="user-menu-button" tabindex="-1">
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100" role="menuitem" tabindex="-1" id="user-menu-item-0">پروفایل شما</a>
                            <form method="POST" action="{{ route('logout') }}" x-data>
                                @csrf
                                <x-responsive-nav-link href="{{ route('supplier.logout') }}"
                                                       @click.prevent="$root.submit();">
                                    {{ __('خروج') }}
                                </x-responsive-nav-link>
                            </form>
                        </div>
                    </div>
                </div>

                {{-- دکمه منوی موبایل --}}
                <div class="-mr-2 flex md:hidden">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" type="button" class="bg-emerald-700 inline-flex items-center justify-center p-2 rounded-md text-emerald-200 hover:text-white hover:bg-emerald-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-emerald-800 focus:ring-white" aria-controls="mobile-menu" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <x-lucide-menu class="block h-6 w-6" ::class="{'hidden': mobileMenuOpen, 'block': !mobileMenuOpen}" />
                        <x-lucide-x class="h-6 w-6" ::class="{'block': mobileMenuOpen, 'hidden': !mobileMenuOpen}" />
                    </button>
                </div>
            </div>
        </div>

        {{-- منوی بازشو موبایل --}}
        <div class="md:hidden" id="mobile-menu" x-show="mobileMenuOpen" x-transition>
            <div class="px-2 pt-2 pb-3 space-y-1 sm:px-3">
                <a href="#" class="bg-emerald-700 text-white block px-3 py-2 rounded-md text-base font-medium" aria-current="page">داشبورد</a>
                <a href="#" class="text-emerald-200 hover:bg-emerald-600 hover:text-white block px-3 py-2 rounded-md text-base font-medium">درخواست‌های بایگانی شده</a>
                <a href="#" class="text-emerald-200 hover:bg-emerald-600 hover:text-white block px-3 py-2 rounded-md text-base font-medium">پروفایل شرکت</a>
            </div>
            <div class="pt-4 pb-3 border-t border-emerald-700">
                <div class="flex items-center px-5">
                    <div class="flex-shrink-0">
                        <img class="h-10 w-10 rounded-full" src="https://placehold.co/40x40/10b981/ffffff?text=S" alt="">
                    </div>
                    <div class="ml-3 mr-3">
                        <div class="text-base font-medium leading-none text-white">نام تامین کننده</div>
                        <div class="text-sm font-medium leading-none text-emerald-300">company@example.com</div>
                    </div>
                </div>
                <div class="mt-3 px-2 space-y-1">
                    <a href="#" class="block px-3 py-2 rounded-md text-base font-medium text-emerald-200 hover:text-white hover:bg-emerald-600">پروفایل شما</a>
                    <form method="post" action="{{ route('logout') }}" x-data>
                        @csrf
                        <x-responsive-nav-link href="{{ route('logout') }}"
                                               @click.prevent="$root.submit();">
                            {{ __('خروج') }}
                        </x-responsive-nav-link>
                    </form>
                </div>
            </div>
        </div>
    </header>

    <main>
        {{-- محتوای اصلی صفحه (داشبورد تامین‌کننده) --}}
        <div class="py-12">
            <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">
                {{-- اینجا محتوای کامپوننت داشبورد تامین‌کننده قرار می‌گیرد --}}
                {{-- که شامل کارت‌های آماری و لیست درخواست‌ها است --}}
                {{ $slot }}
            </div>
        </div>
    </main>
</div>

@livewireScripts
<script>
    lucide.createIcons();
</script>
</body>
</html>
