<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            مدیریت تسویه حساب‌ها
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @if (session()->has('message'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded-lg mb-6" role="alert">
                    <p>{{ session('message') }}</p>
                </div>
            @endif

            {{-- Tabs --}}
            <div class="mb-4 border-b border-gray-200 dark:border-gray-700">
                <ul class="flex flex-wrap -mb-px text-sm font-medium text-center">
                    <li class="me-2">
                        <button wire:click="switchTab('pending_settlement')" class="{{ $activeTab === 'pending_settlement' ? 'inline-block p-4 text-blue-600 border-b-2 border-blue-600' : 'inline-block p-4 border-b-2 border-transparent hover:text-gray-600 hover:border-gray-300' }}">
                            آماده تسویه
                        </button>
                    </li>
                    <li class="me-2">
                        <button wire:click="switchTab('history')" class="{{ $activeTab === 'history' ? 'inline-block p-4 text-blue-600 border-b-2 border-blue-600' : 'inline-block p-4 border-b-2 border-transparent hover:text-gray-600 hover:border-gray-300' }}">
                            تاریخچه تسویه‌ها
                        </button>
                    </li>
                </ul>
            </div>

            {{-- Content --}}
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">کد درخواست</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">تامین‌کننده</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">مبلغ (تومان)</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">تاریخ پرداخت خریدار</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">تاریخ تسویه</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500">عملیات</th>
                        </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @forelse ($payments as $payment)
                            @php
                                $response = $payment->payable;
                                $request = $response?->purchaseRequest;
                            @endphp
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-mono">{{ $request?->request_code }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $response?->supplier?->company_name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">{{ number_format($payment->amount) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">{{ verta($payment->paid_at)->format('Y/m/d H:i') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($payment->settled_at)
                                        {{ verta($payment->settled_at)->format('Y/m/d H:i') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($payment->settlement_status === 'pending')
                                        <x-button wire:click="confirmSettlement({{ $payment->id }})" class="bg-green-600 hover:bg-green-700">
                                            تسویه حساب
                                        </x-button>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                            انجام شده
                                        </span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-gray-500">موردی برای نمایش یافت نشد.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="p-4">
                    {{ $payments->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Settlement Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingSettlement">
        <x-slot name="title">
            تایید تسویه حساب
        </x-slot>
        <x-slot name="content">
            آیا از ثبت تسویه حساب برای این تراکنش اطمینان دارید؟ این عملیات به منزله پرداخت وجه به تامین‌کننده است.
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingSettlement', false)">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="markAsSettled">
                بله، تایید می‌کنم
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
