<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('صفحه تایید درخواست‌های خرید') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">

                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                        درخواست‌های در انتظار تایید شما
                    </h1>
                    @if (session()->has('message'))
                        <div class="mt-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                            {{ session('message') }}
                        </div>
                    @endif

                    <div class="mt-6">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    کد درخواست
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    درخواست دهنده
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    عنوان طرح
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    تعداد اقلام
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    تاریخ ثبت
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">عملیات</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($requests as $request)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">
                                        {{ $request->request_code }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $request->requester->first_name }} {{ $request->requester->last_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $request->project?->title ?? 'عمومی' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $request->items_count }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $request->created_at->format('Y/m/d') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <x-button wire:click="viewRequest({{ $request->id }})">بررسی</x-button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-500 dark:text-gray-400">
                                        هیچ درخواستی برای تایید شما وجود ندارد.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Modal برای مشاهده و تایید/رد درخواست -->
    <x-dialog-modal wire:model.live="confirmingRequestView" maxWidth="2xl">
        <x-slot name="title">
            بررسی و ویرایش درخواست ({{ $viewingRequest?->request_code }})
        </x-slot>

        <x-slot name="content">
            @if ($viewingRequest)
                <div class="space-y-4">
                    <div class="p-4 border rounded-lg dark:border-gray-600 space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <x-label for="priority_modal" value="{{ __('اولویت') }}" />
                                <select id="priority_modal" wire:model.defer="priority" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                    <option value="normal">عادی</option>
                                    <option value="high">بالا</option>
                                    <option value="low">پایین</option>
                                </select>
                            </div>
                            <div>
                                <x-label value="{{ __('پروژه') }}" />
                                <div class="mt-1 p-2 h-10 w-full bg-gray-100 dark:bg-gray-800 rounded-md flex items-center">
                                    <span class="text-gray-700 dark:text-gray-300">{{ $viewingRequest->project?->title ?? 'عمومی' }}</span>
                                </div>
                            </div>
                        </div>

                        {{-- بخش جدید: جستجوی تامین‌کننده --}}
                        <div class="relative">
                            <x-label for="supplierSearch_approval" value="{{ __('ارسال به تامین‌کننده خاص (اختیاری)') }}" />
                            <x-input id="supplierSearch_approval" type="text" class="mt-1 block w-full"
                                     wire:model.live.debounce.300ms="supplierSearch"
                                     placeholder="جستجوی تامین‌کننده..."
                                     autocomplete="off"
                            />
                            @if($assigned_supplier_id)
                                <button type="button" wire:click="clearSelectedSupplier" class="absolute top-8 left-2 text-red-500 hover:text-red-700">&times;</button>
                            @endif

                            @if(count($supplierSearchResults) > 0)
                                <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                                    @foreach($supplierSearchResults as $supplier)
                                        <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                            wire:click="selectSupplier({{ $supplier->id }})">
                                            {{ $supplier->company_name }}
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                            <x-input-error for="assigned_supplier_id" class="mt-2" />
                        </div>

                        <div>
                            <x-label for="notes_modal" value="{{ __('یادداشت‌های اضافی') }}" />
                            <textarea id="notes_modal" wire:model.defer="notes" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                        </div>
                    </div>

                    <hr class="my-4 dark:border-gray-600">

                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">آیتم‌های درخواستی</h3>
                    <div class="space-y-3">
                        @foreach ($items as $index => $item)
                            <div class="p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg space-y-3">
                                <div class="flex justify-between items-center">
                                    <span class="font-semibold text-gray-700 dark:text-gray-300">آیتم #{{ $index + 1 }}</span>
                                    <button type="button" wire:click="removeItemRow({{ $index }})" class="text-red-500 hover:text-red-700">&times; حذف</button>
                                </div>
                                <div>
                                    <x-label for="modal_items.{{ $index }}.item_name" value="{{ __('نام آیتم') }}" />
                                    <x-input id="modal_items.{{ $index }}.item_name" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.item_name" />
                                    <x-input-error for="items.{{ $index }}.item_name" class="mt-2" />
                                </div>
                                <div>
                                    <x-label for="modal_items.{{ $index }}.description" value="{{ __('جزئیات فنی') }}" />
                                    <textarea id="modal_items.{{ $index }}.description" wire:model.defer="items.{{ $index }}.description" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                                    <x-input-error for="items.{{ $index }}.description" class="mt-2" />
                                </div>
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <x-label for="modal_items.{{ $index }}.quantity" value="{{ __('مقدار') }}" />
                                        <x-input id="modal_items.{{ $index }}.quantity" type="number" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.quantity" />
                                        <x-input-error for="items.{{ $index }}.quantity" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-label for="modal_items.{{ $index }}.unit" value="{{ __('واحد') }}" />
                                        <x-input id="modal_items.{{ $index }}.unit" type="text" class="mt-1 block w-full" wire:model.defer="items.{{ $index }}.unit" />
                                        <x-input-error for="items.{{ $index }}.unit" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <x-button type="button" wire:click="addItemRow" class="mt-4">افزودن آیتم دیگر</x-button>
                </div>
            @endif
        </x-slot>

        <x-slot name="footer">
            <x-button wire:click="approveRequest" class="bg-green-600 hover:bg-green-700">
                تایید و ارسال برای بازرگان
            </x-button>
            <x-danger-button wire:click="rejectRequest" class="ms-3">
                رد درخواست
            </x-danger-button>
            <x-secondary-button wire:click="$set('confirmingRequestView', false)" class="ms-3">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
</div>
