<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            مدیریت نمونه‌های بیولوژیکی
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8"
             x-data="{ activeTab: 'samples' }">

            @if (session()->has('message'))
                <div class="mb-6 p-4 text-sm text-green-800 bg-green-100 rounded-lg shadow-md" role="alert">
                    {{ session('message') }}
                </div>
            @endif

            <!-- Tab Headers -->
            <div class="border-b border-gray-200 mb-6">
                <nav class="-mb-px flex space-x-6 space-x-reverse" aria-label="Tabs">
                    <a href="#" @click.prevent="activeTab = 'samples'"
                       :class="{ 'border-blue-500 text-blue-600': activeTab === 'samples', 'border-transparent text-gray-500 hover:text-gray-700': activeTab !== 'samples' }"
                       class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition">
                        <x-lucide-beaker class="inline-block w-5 h-5 ml-2"/>
                        لیست نمونه‌ها
                    </a>
                    <a href="#" @click.prevent="activeTab = 'tanks'"
                       :class="{ 'border-blue-500 text-blue-600': activeTab === 'tanks', 'border-transparent text-gray-500 hover:text-gray-700': activeTab !== 'tanks' }"
                       class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition">
                        <x-lucide-cylinder class="inline-block w-5 h-5 ml-2"/>
                        مدیریت تانک‌های ازت
                    </a>
                    <a href="#" @click.prevent="activeTab = 'requests'" :class="{ 'border-blue-500 text-blue-600': activeTab === 'requests', 'border-transparent text-gray-500 hover:text-gray-700': activeTab !== 'requests' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition">
                        <x-lucide-history class="inline-block w-5 h-5 ml-2"/> تاریخچه
                    </a>
                </nav>
            </div>

            <!-- Tab Content -->
            <div>
                {{-- Tab 1: Biological Samples List --}}
                <div x-show="activeTab === 'samples'" x-cloak>
                    <div class="bg-white rounded-xl shadow-lg p-6 sm:p-8">
                        <div class="flex flex-col sm:flex-row justify-between items-center mb-6">
                            <h1 class="text-2xl font-bold text-gray-900">لیست نمونه‌ها</h1>
                            <x-button wire:click="confirmItemAction">
                                <x-lucide-plus class="w-4 h-4 ml-2"/>
                                افزودن نمونه جدید
                            </x-button>
                        </div>

                        {{-- Search and Filters --}}
                        <div class="mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
                            <x-input type="text" wire:model.live.debounce.300ms="searchQuery" placeholder="جستجو بر اساس نام، شناسه، نوع سلول..." class="md:col-span-2"/>
                            <select wire:model.live="searchTeamId" class="form-select rounded-md shadow-sm">
                                <option value="">همه تیم‌ها</option>
                                @foreach($researchTeams as $team)
                                    <option value="{{ $team->id }}">{{ $team->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Table of Items --}}
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">نام نمونه</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">شناسه (SKU)</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">نوع نمونه</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">شماره پاساژ</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">تاریخ فریز</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">مقدار</th>
                                    <th class="relative px-6 py-3"><span class="sr-only">عملیات</span></th>
                                </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($items as $item)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $item->name }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-mono">{{ $item->sku }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item->cell_type }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item->passage_number }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item->freeze_date ? verta($item->freeze_date)->format('Y/m/d') : '-' }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item->quantity }} {{ $item->unit }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                            <button wire:click="confirmItemAction({{ $item->id }})" class="text-indigo-600 hover:text-indigo-900">ویرایش</button>
                                            <button wire:click="confirmCheckout({{ $item->id }})" class="text-green-600 hover:text-green-900 font-semibold ms-4">خروج نمونه</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">هیچ نمونه بیولوژیکی یافت نشد.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">{{ $items->links() }}</div>
                    </div>
                </div>

                {{-- Tab 2: Nitrogen Tank Management --}}
                <div x-show="activeTab === 'tanks'" x-cloak>
                    <div class="bg-white rounded-xl shadow-lg p-6 sm:p-8">
                        <div class="flex justify-between items-center mb-6">
                            <h1 class="text-2xl font-bold text-gray-900">ساختار تانک‌های ازت</h1>
                            <x-button wire:click="confirmLocationCreation(null)">
                                <x-lucide-plus class="w-4 h-4 ml-2"/>
                                ایجاد تانک جدید
                            </x-button>
                        </div>

                        {{-- [NEW] User Guide --}}
                        <div class="mb-6 p-4 text-sm text-blue-800 bg-blue-100 rounded-lg">
                            <p><span class="font-bold">راهنما:</span> برای جانمایی یک نمونه، روی تانک مورد نظر کلیک کرده، به باکس مقصد بروید و در نمای گرافیکی، روی یک خانه خالی (+) کلیک کنید.</p>
                        </div>
                        <div class="mt-6 space-y-2">
                            @forelse ($locations ?? [] as $location)
                                <div x-data="{ open: true }">
                                    <x-tank-item :location="$location" />
                                </div>
                            @empty
                                <p class="text-center text-gray-500 py-8">هیچ تانکی برای تیم‌های شما ثبت نشده است.</p>
                            @endforelse
                        </div>
                    </div>
                </div>

                {{-- Tab 3: Checkout Requests History --}}
                <div x-show="activeTab === 'requests'" x-cloak>
                    <div class="bg-white rounded-xl shadow-lg p-6 sm:p-8">
                        <h1 class="text-2xl font-bold text-gray-900 mb-4">تاریخچه درخواست‌ها</h1>
                        <!-- Filter Buttons -->
                        <div class="flex flex-wrap items-center gap-2 mb-6 pb-4 border-b">
                            <span class="text-sm font-semibold text-gray-600">فیلتر وضعیت:</span>
                            <button wire:click="$set('statusFilter', 'all')" class="{{ $statusFilter === 'all' ? 'bg-blue-600 text-white' : 'bg-gray-200' }} px-3 py-1 text-xs rounded-full transition">همه</button>
                            <button wire:click="$set('statusFilter', 'checked_out')" class="{{ $statusFilter === 'checked_out' ? 'bg-yellow-500 text-white' : 'bg-gray-200' }} px-3 py-1 text-xs rounded-full transition">در حال استفاده</button>
                            <button wire:click="$set('statusFilter', 'returned')" class="{{ $statusFilter === 'returned' ? 'bg-green-500 text-white' : 'bg-gray-200' }} px-3 py-1 text-xs rounded-full transition">بازگشتی</button>
                            <button wire:click="$set('statusFilter', 'overdue')" class="{{ $statusFilter === 'overdue' ? 'bg-red-600 text-white' : 'bg-gray-200' }} px-3 py-1 text-xs rounded-full transition">دیرکرد</button>
                        </div>
                        <!-- Requests Table -->
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">نام نمونه
                                        (SKU)
                                    </th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">تحویل
                                        گیرنده
                                    </th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">تاریخ خروج
                                    </th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">موعد بازگشت
                                    </th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">وضعیت</th>
                                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">عملیات</th>
                                </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($requests as $request)
                                    <tr>

                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            {{ $request->inventoryItem->name }}
                                            <span class="block font-mono text-xs text-gray-500">{{ $request->inventoryItem->sku }}</span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $request->recipient_name }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ verta($request->checkout_date)->format('Y/m/d H:i') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ verta($request->expected_return_date)->format('Y/m/d H:i') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                                                            @if($request->status === 'returned') bg-green-100 text-green-800
                                                                            @elseif($request->status === 'overdue') bg-red-100 text-red-800
                                                                            @else bg-yellow-100 text-yellow-800 @endif">
                                                                            {{ $request->status }}
                                                                        </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                            <button wire:click="viewRequest({{ $request->id }})" class="text-blue-600 hover:text-blue-900">جزئیات</button>
                                            @if($request->status !== 'returned')
                                                <button wire:click="confirmReturn({{ $request->id }})" class="text-green-600 hover:text-green-900 ms-4">ثبت بازگشت</button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    {{-- Empty state row --}}
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">{{ $requests->links('pagination::tailwind', ['paginatorName' => 'requestsPage']) }}</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Add/Edit Modal -->
    <x-dialog-modal wire:model.live="confirmingItemAction">
        <x-slot name="title">
            {{ $editingItem ? 'ویرایش نمونه بیولوژیکی' : 'افزودن نمونه بیولوژیکی جدید' }}
        </x-slot>
        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                {{-- Team Selection --}}
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="research_team_id" value="تیم تحقیقاتی" />
                    <select id="research_team_id" wire:model.live="state.research_team_id" class="form-select mt-1 block w-full" @if($editingItem) disabled @endif>
                        <option value="">-- انتخاب کنید --</option>
                        @foreach($researchTeams as $team)
                            <option value="{{ $team->id }}">{{ $team->name }}</option>
                        @endforeach
                    </select>
                    <x-input-error for="state.research_team_id" class="mt-2" />
                </div>

                {{-- Generated SKU Display --}}
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="کد شناسایی (SKU)" />
                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 rounded-md">
                        <span class="text-gray-700 font-mono tracking-widest">
                            {{ $editingItem ? $editingItem->sku : $generatedSku }}
                        </span>
                    </div>
                </div>

                <div class="col-span-6"><x-label for="name" value="نام نمونه" /><x-input id="name" type="text" class="mt-1 block w-full" wire:model.defer="state.name" /></div>

                {{-- [UPDATED] Sample Type (Cell Type) --}}
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="cell_type" value="نوع نمونه" />
                    <select id="cell_type" wire:model.live="state.cell_type" class="form-select mt-1 block w-full">
                        <option value="">-- انتخاب کنید --</option>
                        <option value="رده سلولی">رده سلولی</option>
                        <option value="پرایمری">پرایمری</option>
                        <option value="نمونه بافت">نمونه بافت</option>
                        <option value="سایر">سایر</option>
                    </select>
                    <x-input-error for="state.cell_type" class="mt-2" />
                </div>

                {{-- [NEW] Custom Sample Type Input --}}
                @if(isset($state['cell_type']) && $state['cell_type'] === 'سایر')
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="custom_cell_type" value="نام نوع سفارشی" />
                        <x-input id="custom_cell_type" type="text" class="mt-1 block w-full" wire:model.defer="state.custom_cell_type" placeholder="نوع نمونه را وارد کنید..."/>
                        <x-input-error for="state.custom_cell_type" class="mt-2" />
                    </div>
                @endif

                <div class="col-span-6 sm:col-span-3"><x-label for="passage_number" value="شماره پاساژ" /><x-input id="passage_number" type="number" class="mt-1 block w-full" wire:model.defer="state.passage_number" /></div>

                {{-- [UPDATED] Freeze Date with Jalali Date Picker --}}
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="freeze_date" value="تاریخ فریز" />
                    <x-jalali-date-picker id="freeze_date" wire:model="state.freeze_date" />
                    <x-input-error for="state.freeze_date" class="mt-2" />
                </div>

                <div class="col-span-6"><x-label for="media_used" value="محیط کشت فریز" /><x-input id="media_used" type="text" class="mt-1 block w-full" wire:model.defer="state.media_used" /></div>
                <div class="col-span-6 sm:col-span-3"><x-label for="quantity" value="مقدار" /><x-input id="quantity" type="number" step="any" class="mt-1 block w-full" wire:model.defer="state.quantity" /></div>
                <div class="col-span-6 sm:col-span-3"><x-label for="unit" value="واحد" /><x-input id="unit" type="text" class="mt-1 block w-full" wire:model.defer="state.unit" placeholder="مثال: vial, tube" /></div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingItemAction', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveItem">ذخیره</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Add New Tank Modal -->
{{--    <x-dialog-modal wire:model.live="confirmingTankCreation">--}}
{{--        <x-slot name="title">--}}
{{--            ایجاد تانک ازت جدید--}}
{{--        </x-slot>--}}
{{--        <x-slot name="content">--}}
{{--            <div class="grid grid-cols-6 gap-6">--}}
{{--                <div class="col-span-6">--}}
{{--                    <x-label for="tank_name" value="نام تانک" />--}}
{{--                    <x-input id="tank_name" type="text" class="mt-1 block w-full" wire:model.defer="newTankState.name" placeholder="مثال: تانک شماره ۱"/>--}}
{{--                    <x-input-error for="newTankState.name" class="mt-2" />--}}
{{--                </div>--}}
{{--                <div class="col-span-6 sm:col-span-3">--}}
{{--                    <x-label for="tank_team" value="تیم تحقیقاتی" />--}}
{{--                    <select id="tank_team" wire:model.defer="newTankState.research_team_id" class="form-select mt-1 block w-full">--}}
{{--                        <option value="">-- انتخاب کنید --</option>--}}
{{--                        @foreach($researchTeams as $team)--}}
{{--                            <option value="{{ $team->id }}">{{ $team->name }}</option>--}}
{{--                        @endforeach--}}
{{--                    </select>--}}
{{--                    <x-input-error for="newTankState.research_team_id" class="mt-2" />--}}
{{--                </div>--}}
{{--                <div class="col-span-6 sm:col-span-3">--}}
{{--                    <x-label value="کد شناسایی تانک" />--}}
{{--                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 rounded-md">--}}
{{--                        <span class="text-gray-700 font-mono tracking-widest">{{ $newTankState['location_code'] ?? '---' }}</span>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="col-span-6 border-t pt-4">--}}
{{--                    <h4 class="font-semibold">ساختار داخلی</h4>--}}
{{--                </div>--}}
{{--                <div class="col-span-6">--}}
{{--                    <x-label for="structure_type" value="نوع ساختار" />--}}
{{--                    <select id="structure_type" wire:model.live="newTankState.internal_structure_type" class="form-select mt-1 block w-full">--}}
{{--                        <option value="rack_based">مبتنی بر رک (Rack-based)</option>--}}
{{--                        <option value="cane_based">مبتنی بر کرایوکین (Cane-based)</option>--}}
{{--                    </select>--}}
{{--                </div>--}}
{{--                <div class="col-span-6 sm:col-span-3">--}}
{{--                    <x-label for="canister_count" value="تعداد کنیسترها" />--}}
{{--                    <x-input id="canister_count" type="number" class="mt-1 block w-full" wire:model.defer="newTankState.canister_count" />--}}
{{--                    <x-input-error for="newTankState.canister_count" class="mt-2" />--}}
{{--                </div>--}}
{{--                <div class="col-span-6 sm:col-span-3">--}}
{{--                    <x-label for="items_per_canister">--}}
{{--                        @if(isset($newTankState['internal_structure_type']) && $newTankState['internal_structure_type'] === 'rack_based')--}}
{{--                            تعداد رک در هر کنیستر--}}
{{--                        @else--}}
{{--                            تعداد کرایوکین در هر کنیستر--}}
{{--                        @endif--}}
{{--                    </x-label>--}}
{{--                    <x-input id="items_per_canister" type="number" class="mt-1 block w-full" wire:model.defer="newTankState.items_per_canister" />--}}
{{--                    <x-input-error for="newTankState.items_per_canister" class="mt-2" />--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </x-slot>--}}
{{--        <x-slot name="footer">--}}
{{--            <x-secondary-button wire:click="$set('confirmingTankCreation', false)">انصراف</x-secondary-button>--}}
{{--            <x-button class="ms-3" wire:click="saveNewTank">ذخیره تانک</x-button>--}}
{{--        </x-slot>--}}
{{--    </x-dialog-modal>--}}

    <!-- [NEW] Edit Location Modal -->
    <x-dialog-modal wire:model.live="confirmingLocationCreation">
        <x-slot name="title">
            @if($parentLocation)
                افزودن زیرمجموعه به <span class="font-bold text-blue-600">"{{ $parentLocation->name }}"</span>
            @else
                ایجاد تانک ازت جدید
            @endif
        </x-slot>
        <x-slot name="content">
            {{-- Form for creating a new TANK --}}
            @if(!$parentLocation)
                <div class="grid grid-cols-6 gap-6">
                    <div class="col-span-6"><x-label for="tank_name" value="نام تانک" /><x-input id="tank_name" type="text" class="mt-1 block w-full" wire:model.defer="newLocationState.name" placeholder="مثال: تانک شماره ۱"/></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="tank_team" value="تیم تحقیقاتی" /><select id="tank_team" wire:model.defer="newLocationState.research_team_id" class="form-select mt-1 block w-full"><option value="">-- انتخاب کنید --</option>@foreach($researchTeams as $team)<option value="{{ $team->id }}">{{ $team->name }}</option>@endforeach</select></div>
                    <div class="col-span-6 sm:col-span-3"><x-label value="کد شناسایی تانک" /><div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 rounded-md"><span class="text-gray-700 font-mono tracking-widest">{{ $newLocationState['location_code'] ?? '---' }}</span></div></div>
                    <div class="col-span-6 border-t pt-4"><h4 class="font-semibold">ساختار داخلی</h4></div>
                    <div class="col-span-6"><x-label for="structure_type" value="نوع ساختار" /><select id="structure_type" wire:model.live="newLocationState.internal_structure_type" class="form-select mt-1 block w-full"><option value="rack_based">مبتنی بر رک</option><option value="cane_based">مبتنی بر کرایوکین</option></select></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="canister_count" value="تعداد کنیسترها" /><x-input id="canister_count" type="number" class="mt-1 block w-full" wire:model.defer="newLocationState.canister_count" /></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="items_per_canister">@if(isset($newLocationState['internal_structure_type']) && $newLocationState['internal_structure_type'] === 'rack_based') تعداد رک در هر کنیستر @else تعداد کرایوکین در هر کنیستر @endif</x-label><x-input id="items_per_canister" type="number" class="mt-1 block w-full" wire:model.defer="newLocationState.items_per_canister" /></div>
                </div>
                {{-- Form for creating a SUB-LOCATION (Canister, Rack, etc.) --}}
            @else
                <div class="space-y-4">
                    <div>
                        <x-label for="new_location_type" value="نوع زیرمجموعه" />
                        <select id="new_location_type" wire:model.live="newLocationState.location_type" class="form-select mt-1 block w-full">
                            <option value="">-- انتخاب کنید --</option>
                            @foreach($allowedLocationTypes as $type)
                                <option value="{{ $type }}">{{ $type }}</option>
                            @endforeach
                        </select>
                        <x-input-error for="newLocationState.type" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="new_location_name" value="نام/شماره" />
                        <x-input id="new_location_name" type="text" class="mt-1 block w-full" wire:model.defer="newLocationState.name" />
                        <x-input-error for="newLocationState.name" class="mt-2" />
                    </div>
                    {{-- Show dimension fields only for boxes --}}
                    @if(isset($newLocationState['location_type']) && $newLocationState['location_type'] === 'box')
                        <div class="grid grid-cols-2 gap-4 pt-4 border-t">
                            <div>
                                <x-label for="rows" value="تعداد سطرها" />
                                <x-input id="rows" type="number" class="mt-1 block w-full" wire:model.defer="newLocationState.rows" />
                                <x-input-error for="newLocationState.rows" class="mt-2" />
                            </div>
                            <div>
                                <x-label for="columns" value="تعداد ستون‌ها" />
                                <x-input id="columns" type="number" class="mt-1 block w-full" wire:model.defer="newLocationState.columns" />
                                <x-input-error for="newLocationState.columns" class="mt-2" />
                            </div>
                        </div>
                    @endif
                </div>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingLocationCreation', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveLocation">ذخیره</x-button>
        </x-slot>
    </x-dialog-modal>

    <x-dialog-modal wire:model.live="confirmingLocationEdit">
        <x-slot name="title">ویرایش نام مکان</x-slot>
        <x-slot name="content">
            <x-label for="editing_location_name" value="نام جدید برای '{{ $editingLocation?->name }}'" />
            <x-input id="editing_location_name" type="text" class="mt-1 block w-full" wire:model.defer="newTankState.name" />
            <x-input-error for="newTankState.name" class="mt-2" />
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingLocationEdit', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="updateLocation">ذخیره</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Delete Location Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingLocationDeletion">
        <x-slot name="title">حذف مکان</x-slot>
        <x-slot name="content">
            آیا از حذف <span class="font-bold text-red-600">"{{ $deletingLocation?->name }}"</span> مطمئن هستید؟
            <p class="mt-2 text-sm text-gray-600">توجه: با حذف این مکان، تمام زیرمجموعه‌های آن نیز به صورت دائمی حذف خواهند شد.</p>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingLocationDeletion', false)">انصراف</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteLocation">بله، حذف کن</x-danger-button>
        </x-slot>
    </x-confirmation-modal>

    {{-- [NEW] Checkout Request Modal is now here --}}
    <x-dialog-modal wire:model.live="confirmingCheckout">
        <x-slot name="title">
            ثبت درخواست خروج نمونه
        </x-slot>
        <x-slot name="content">
            <div class="mb-4 p-3 bg-gray-100 rounded-lg text-sm">
                <p><strong class="text-gray-600">نام نمونه:</strong> {{ $itemForCheckout?->name }}</p>
                <p><strong class="text-gray-600">شناسه:</strong> <span class="font-mono">{{ $itemForCheckout?->sku }}</span></p>
            </div>
            <div class="space-y-4">
                <div>
                    <x-label for="recipient_name" value="نام تحویل گیرنده" />
                    <x-input id="recipient_name" type="text" class="mt-1 block w-full" wire:model.defer="checkoutState.recipient_name" />
                    <x-input-error for="checkoutState.recipient_name" class="mt-2" />
                </div>
                <div>
                    <x-label for="handler_id" value="تحویل دهنده (از اعضای مجاز تیم)" />
                    <select id="handler_id" wire:model.defer="checkoutState.handler_id" class="form-select mt-1 block w-full">
                        <option value="">-- انتخاب کنید --</option>
                        @if(!empty($authorizedHandlers))
                            @foreach($authorizedHandlers as $handler)
                                <option value="{{ $handler->id }}">{{ $handler->name }}</option>
                            @endforeach
                        @endif
                    </select>
                    <x-input-error for="checkoutState.handler_id" class="mt-2" />
                </div>
                <div>
                    <x-label for="expected_return_date" value="موعد بازگشت نمونه" />
                    <x-jalali-date-picker id="expected_return_date" wire:model="checkoutState.expected_return_date" :time-picker="true" />
                    <x-input-error for="checkoutState.expected_return_date" class="mt-2" />
                </div>
                <div>
                    <x-label for="notes" value="یادداشت" />
                    <textarea id="notes" class="form-input mt-1 block w-full rounded-md" wire:model.defer="checkoutState.notes"></textarea>
                    <x-input-error for="checkoutState.notes" class="mt-2" />
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingCheckout', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="saveCheckoutRequest" wire:loading.attr="disabled">ثبت درخواست</x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Details Modal -->
    <x-dialog-modal wire:model.live="confirmingViewRequest">
        <x-slot name="title">
            جزئیات درخواست خروج نمونه
        </x-slot>
        <x-slot name="content">
            @if($viewingRequest)
                <div class="space-y-3 text-sm">
                    <p><strong>نام نمونه:</strong> {{ $viewingRequest->inventoryItem->name }}</p>
                    <p><strong>شناسه (SKU):</strong> <span class="font-mono">{{ $viewingRequest->inventoryItem->sku }}</span></p>
                    <p><strong>تیم تحقیقاتی:</strong> {{ $viewingRequest->researchTeam->name }}</p>
                    <hr>
                    <p><strong>درخواست دهنده:</strong> {{ $viewingRequest->requester->name }}</p>
                    <p><strong>تحویل دهنده:</strong> {{ $viewingRequest->handler->name }}</p>
                    <p><strong>تحویل گیرنده:</strong> {{ $viewingRequest->recipient_name }}</p>
                    <hr>
                    <p><strong>تاریخ خروج:</strong> {{ verta($viewingRequest->checkout_date)->format('Y/m/d H:i') }}</p>
                    <p><strong>موعد بازگشت:</strong> {{ verta($viewingRequest->expected_return_date)->format('Y/m/d H:i') }}</p>
                    <p><strong>تاریخ بازگشت واقعی:</strong> {{ $viewingRequest->actual_return_date ? verta($viewingRequest->actual_return_date)->format('Y/m/d H:i') : 'هنوز بازنگشته' }}</p>
                    <p><strong>یادداشت:</strong> {{ $viewingRequest->notes ?: '-' }}</p>
                </div>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingViewRequest', false)">بستن</x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Return Confirmation Modal -->
    <x-confirmation-modal wire:model.live="confirmingReturnRequest">
        <x-slot name="title">
            تایید بازگشت نمونه
        </x-slot>
        <x-slot name="content">
            آیا تایید می‌کنید که نمونه با شناسه <span class="font-mono font-bold">{{ $returningRequest?->inventoryItem->sku }}</span> به انبار بازگشته است؟
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingReturnRequest', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="markAsReturned">بله، تایید می‌کنم</x-button>
        </x-slot>
    </x-confirmation-modal>
</div>
