<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            نمایش محفظه: <span class="font-bold text-blue-600 dark:text-blue-400">{{ $location->name }}</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-screen-2xl mx-auto sm:px-6 lg:px-8">
            @if (session()->has('message'))
                <div class="mb-6 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300 shadow-md" role="alert">
                    {{ session('message') }}
                </div>
            @endif

            {{-- Main container with two panes: Details and Grid --}}
            <div class="flex flex-col lg:flex-row gap-8">

                <!-- [NEW] Interactive Details Pane -->
                <div class="lg:w-1/4 xl:w-1/5">
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600 p-6 sticky top-24">
                        @if($selectedItem)
                            {{-- Item Details View --}}
                            <div>
                                <div class="flex justify-between items-center">
                                    <h3 class="text-lg font-bold text-gray-900 dark:text-white">جزئیات آیتم</h3>
                                    <button wire:click="selectItem(null)" class="text-gray-400 hover:text-gray-600" title="بستن">
                                        <x-lucide-x class="w-5 h-5"/>
                                    </button>
                                </div>
                                <div class="mt-4 pt-4 border-t dark:border-gray-700 space-y-3 text-sm">
                                    <p><strong class="text-gray-500">نام:</strong> <span class="dark:text-gray-200">{{ $selectedItem->name }}</span></p>
                                    <p><strong class="text-gray-500">شناسه:</strong> <span class="dark:text-gray-200 font-mono">{{ $selectedItem->sku }}</span></p>
                                    <p><strong class="text-gray-500">مقدار:</strong> <span class="dark:text-gray-200">{{ $selectedItem->quantity }} {{ $selectedItem->unit }}</span></p>
                                    <p><strong class="text-gray-500">تیم:</strong> <span class="dark:text-gray-200">{{ $selectedItem->researchTeam->name }}</span></p>
                                    <p><strong class="text-gray-500">تاریخ انقضا:</strong> <span class="dark:text-gray-200">{{ $selectedItem->expiration_date ? verta($selectedItem->expiration_date)->format('Y/m/d') : '-' }}</span></p>
                                    <div class="pt-4 mt-4 border-t dark:border-gray-600 space-y-2">
                                        <a href="{{ route('inventory.index') }}" class="text-blue-600 hover:underline block">ویرایش آیتم &rarr;</a>
                                        <button wire:click="confirmItemRemoval({{ $selectedItem->id }})" class="text-red-600 hover:underline">حذف از محفظه</button>
                                    </div>
                                </div>
                            </div>
                        @else
                            {{-- Box Details View (Default) --}}
                            <div>
                                <h3 class="text-lg font-bold text-gray-900 dark:text-white">اطلاعات محفظه</h3>
                                <div class="mt-4 pt-4 border-t dark:border-gray-700 space-y-3 text-sm">
                                    <p><strong class="text-gray-500">ظرفیت کل:</strong> <span class="dark:text-gray-200">{{ $location->rows * $location->columns }} خانه</span></p>
                                    <p><strong class="text-gray-500">ظرفیت پر شده:</strong> <span class="dark:text-gray-200">{{ $itemsInGrid->count() }} خانه</span></p>
{{--                                    <p><strong class="text-gray-500">درصد اشغال:</strong> <span class="dark:text-gray-200 font-bold">%{{ number_format(($itemsInGrid->count() / ($location->rows * $location->columns)) * 100, 1) }}</span></p>--}}
                                </div>
                                <div class="mt-4 text-xs text-center text-gray-400 py-4">
                                    برای مشاهده جزئیات، روی یک خانه کلیک کنید.
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- [UPDATED] Grid View -->
                <div class="flex-grow">
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600 p-6">
                        {{-- Header and Search --}}
                        <div class="flex flex-col md:flex-row justify-between md:items-center gap-4 mb-6">
                            {{-- Legend --}}
                            <div class="flex flex-wrap items-center gap-x-4 gap-y-2 text-xs">
                                <span class="text-white flex items-center"><span class="w-3 h-3  rounded-full bg-green-200 ml-1"></span>سالم</span>
                                <span class="text-white flex items-center"><span class="w-3 h-3  rounded-full bg-yellow-200 ml-1"></span>هشدار موجودی</span>
                                <span class="text-white flex items-center"><span class="w-3 h-3  rounded-full bg-orange-200 ml-1"></span>نزدیک به انقضا</span>
                                <span class="text-white flex items-center"><span class="w-3 h-3  rounded-full bg-red-200 ml-1"></span>بحرانی/منقضی</span>
                                <span class="text-white flex items-center"><span class="w-3 h-3  rounded-full bg-gray-200 ml-1"></span>خالی</span>
                            </div>
                            <div class="relative">
                                <x-input id="highlight_search" type="text" class="w-full md:w-80 pl-10" wire:model.live.debounce.300ms="highlightSearch" placeholder="هایلایت کردن آیتم..." />
                                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"><x-lucide-search class="w-5 h-5 text-gray-400" /></div>
                            </div>
                        </div>
                        {{-- Bottom Row: Status Filters --}}
                        <div class="flex flex-wrap items-center gap-2 pt-4 border-t dark:border-gray-700">
                            <span class="text-sm font-semibold text-gray-600 dark:text-gray-300">فیلتر وضعیت:</span>
                            <button wire:click="setStatusFilter('all')" class="{{ $statusFilter === 'all' ? 'bg-blue-600 text-white' : 'bg-gray-200 dark:bg-gray-700' }} px-3 py-1 text-xs rounded-full">همه</button>
                            <button wire:click="setStatusFilter('critical')" class="{{ $statusFilter === 'critical' ? 'bg-red-600 text-white' : 'bg-gray-200 dark:bg-gray-700' }} px-3 py-1 text-xs rounded-full">بحرانی/منقضی</button>
                            <button wire:click="setStatusFilter('near_expiry')" class="{{ $statusFilter === 'near_expiry' ? 'bg-orange-500 text-white' : 'bg-gray-200 dark:bg-gray-700' }} px-3 py-1 text-xs rounded-full">نزدیک به انقضا</button>
                            <button wire:click="setStatusFilter('warning')" class="{{ $statusFilter === 'warning' ? 'bg-yellow-500 text-white' : 'bg-gray-200 dark:bg-gray-700' }} px-3 py-1 text-xs rounded-full">هشدار موجودی</button>
                            <button wire:click="setStatusFilter('empty')" class="{{ $statusFilter === 'empty' ? 'bg-gray-500 text-white' : 'bg-gray-200 dark:bg-gray-700' }} px-3 py-1 text-xs rounded-full">خالی</button>
                        </div>

                        {{-- Grid Container --}}
                        <div class="overflow-x-auto">
                            <div class="grid-container" style="display: grid; grid-template-columns: auto repeat({{ $location->columns }}, minmax(100px, 1fr)); gap: 8px;">
                                {{-- Column Headers --}}
                                <div></div>
                                @for ($col = 1; $col <= $location->columns; $col++)
                                    <div class="text-center font-bold p-2 text-gray-500 dark:text-gray-400">{{ $col }}</div>
                                @endfor

                                {{-- Rows and Cells --}}
                                @for ($row = 0; $row < $location->rows; $row++)
                                    <div class="flex items-center justify-center font-bold p-2 text-gray-500 dark:text-gray-400">{{ chr(65 + $row) }}</div>
                                    @for ($col = 1; $col <= $location->columns; $col++)
                                        @php
                                            $position = chr(65 + $row) . $col;
                                            $item = $itemsInGrid->get($position);
                                            $colorClass = $this->getCellColorClass($item);
                                            $shouldShow = $this->shouldShowCell($item);
                                        @endphp
                                        <div
                                            wire:click="selectItem({{ $item ? $item->id : 'null' }})"
                                            class="relative w-full h-24 rounded-lg p-2 border-2 transition-all duration-300 group cursor-pointer {{ $colorClass }} {{ !$shouldShow ? 'opacity-20' : '' }}"
                                        >
                                            @if($item)
                                                <div class="flex flex-col h-full text-center text-xs">
                                                    <div class="font-semibold truncate">{{ $item->name }}</div>
                                                    <div class="font-mono text-xxs mt-1 opacity-70">{{ $item->sku }}</div>
                                                    <div class="mt-auto opacity-80">{{ $item->quantity }} {{ $item->unit }}</div>
                                                </div>
                                            @else
                                                @if($shouldShow) {{-- Only show plus button if empty cells are being shown --}}
                                                <button wire:click.prevent="confirmItemPlacement('{{ $position }}')" class="w-full h-full flex items-center justify-center text-gray-300 dark:text-gray-600 hover:bg-gray-200 dark:hover:bg-gray-700/50 hover:text-blue-500 dark:hover:text-blue-400 rounded-md transition duration-200">
                                                    <x-lucide-plus class="w-8 h-8 opacity-50 group-hover:opacity-100" />
                                                </button>
                                                @endif
                                            @endif
                                        </div>
                                    @endfor
                                @endfor
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    {{-- تمام مودال‌ها در اینجا قرار می‌گیرند --}}
    {{--    <!-- Modal برای جانمایی آیتم -->--}}
        <x-dialog-modal wire:model.live="confirmingItemPlacement">
            <x-slot name="title">
                جانمایی آیتم در موقعیت {{ $positionToPlace }}
            </x-slot>

            <x-slot name="content">
                <div class="relative">
                    <x-label for="itemSearch" value="{{ __('جستجوی آیتم انبار (فقط آیتم‌های جانمایی نشده)') }}" />
                    <x-input id="itemSearch" type="text" class="mt-1 block w-full"
                             wire:model.live.debounce.300ms="itemSearch"
                             placeholder="جستجو بر اساس نام یا کد شناسایی..."
                             autocomplete="off"
                    />

                    @if(count($itemSearchResults) > 0)
                        <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                            @foreach($itemSearchResults as $result)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="selectItemToPlace({{ $result->id }})">
                                    <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->name }}</div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">{{ $result->sku }}</div>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                    <x-input-error for="itemToPlaceId" class="mt-2" />
                </div>
            </x-slot>

            <x-slot name="footer">
                <x-secondary-button wire:click="$set('confirmingItemPlacement', false)" wire:loading.attr="disabled">
                    {{ __('انصراف') }}
                </x-secondary-button>

                <x-button class="ms-3" wire:click="placeItem" wire:loading.attr="disabled">
                    {{ __('جانمایی آیتم') }}
                </x-button>
            </x-slot>
        </x-dialog-modal>

        <!-- Modal برای حذف آیتم از محفظه -->
        <x-confirmation-modal wire:model.live="confirmingItemRemoval">
            <x-slot name="title">
                {{ __('حذف آیتم از محفظه') }}
            </x-slot>
            <x-slot name="content">
                {{ __('آیا از حذف این آیتم از موقعیت فعلی مطمئن هستید؟ آیتم به لیست جانمایی نشده باز خواهد گشت.') }}
            </x-slot>
            <x-slot name="footer">
                <x-secondary-button wire:click="$toggle('confirmingItemRemoval')" wire:loading.attr="disabled">
                    {{ __('انصراف') }}
                </x-secondary-button>
                <x-danger-button class="ms-3" wire:click="removeItem" wire:loading.attr="disabled">
                    {{ __('حذف') }}
                </x-danger-button>
            </x-slot>
        </x-confirmation-modal>

        <!-- Modal برای جابجایی آیتم -->
        <x-dialog-modal wire:model.live="confirmingItemMove">
            <x-slot name="title">
                جابجایی آیتم: {{ $itemToMove?->name }}
            </x-slot>
            <x-slot name="content">
                <p>لطفاً موقعیت خالی جدید را برای این آیتم انتخاب کنید.</p>
                <div class="mt-4">
                    <select wire:model.defer="newPosition" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">انتخاب کنید...</option>
                        @foreach($availablePositions as $pos)
                            <option value="{{ $pos }}">{{ $pos }}</option>
                        @endforeach
                    </select>
                    <x-input-error for="newPosition" class="mt-2" />
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-secondary-button wire:click="$toggle('confirmingItemMove')" wire:loading.attr="disabled">
                    {{ __('انصراف') }}
                </x-secondary-button>
                <x-button class="ms-3" wire:click="moveItem" wire:loading.attr="disabled">
                    {{ __('انتقال') }}
                </x-button>
            </x-slot>
        </x-dialog-modal>
</div>
