<div>
    <x-dialog-modal wire:model.live="showingModal" maxWidth="2xl">
        <x-slot name="title">
            تاریخچه کالیبراسیون: <span class="font-bold">{{ $equipment?->name }}</span>
        </x-slot>

        <x-slot name="content">
            <div class="mt-4 space-y-6">
                @if($equipment)
                    @forelse($equipment->calibrationLogs as $log)
                        <div class="relative flex items-start">
                            <!-- Timeline Line -->
                            <div class="absolute left-4 top-5 h-full w-0.5 bg-gray-200 dark:bg-gray-700"></div>
                            <!-- Timeline Icon -->
                            <div class="flex-shrink-0 w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center text-white z-10">
                                <x-lucide-check class="w-5 h-5"/>
                            </div>
                            <!-- Timeline Content -->
                            <div class="ms-4">
                                <h4 class="font-semibold text-gray-900 dark:text-black">
                                    کالیبراسیون در تاریخ {{ verta($log->calibration_date)->format('Y/m/d') }}
                                </h4>
                                <p class="text-xs text-gray-500">ثبت توسط: {{ $log->user->name }}</p>
                                @if($log->notes)
                                    <p class="mt-2 text-sm text-gray-700 dark:text-gray-300">{{ $log->notes }}</p>
                                @endif

                                @if($log->attachments->isNotEmpty())
                                    <div class="mt-3">
                                        <p class="text-xs font-semibold text-gray-500 mb-2">فایل‌های پیوست:</p>
                                        <div class="flex flex-wrap gap-2">
                                            @foreach($log->attachments as $attachment)
                                                <button wire:click="downloadAttachment({{ $attachment->id }})" class="flex items-center gap-2 p-2 text-xs bg-gray-100 dark:bg-gray-700 rounded-md hover:bg-gray-200 dark:hover:bg-gray-600">
                                                    <x-lucide-paperclip class="w-3 h-3"/>
                                                    <span>{{ $attachment->file_name }}</span>
                                                </button>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-center text-gray-500">هیچ سابقه‌ی کالیبراسیونی برای این تجهیز ثبت نشده است.</p>
                    @endforelse
                @endif
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showingModal', false)">
                بستن
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
</div>
