<div>
    {{-- این کامپوننت فقط برای مدیران تیم نمایش داده می‌شود --}}
    @if($isTeamManager)
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">معرفی مسئول کالیبراسیون</h3>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                یک نفر از اعضای تیم‌های خود را به عنوان مسئول کالیبراسیون تجهیزات انتخاب کنید. این فرد به تمام تجهیزات شما دسترسی خواهد داشت.
            </p>

            @if (session()->has('message'))
                <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
                    {{ session('message') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="mt-4 p-4 text-sm text-red-800 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300" role="alert">
                    {{ session('error') }}
                </div>
            @endif

            @if(Auth::user()->calibrationManager)
                <div class="mt-4 p-3 bg-blue-50 dark:bg-blue-900/50 rounded-lg">
                    <p class="text-sm text-gray-800 dark:text-gray-200">
                        مسئول فعلی: <span class="font-bold">{{ Auth::user()->calibrationManager->name }}</span>
                    </p>
                </div>
            @endif

            <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div class="md:col-span-2">
                    <x-label for="selectedManagerId" value="انتخاب مسئول جدید" />
                    <select id="selectedManagerId" wire:model.defer="selectedManagerId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">-- هیچکس (حذف مسئول) --</option>
                        @foreach($teamMembers as $member)
                            <option value="{{ $member->id }}">{{ $member->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <x-button wire:click="assignManager" class="w-full justify-center">
                        ذخیره تغییرات
                    </x-button>
                </div>
            </div>
        </div>
    @endif
</div>
