<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            نمایش کرایوکین: <span class="font-bold text-blue-600">{{ $location->name }}</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if (session()->has('message'))
                <div class="mb-6 p-4 text-sm text-green-800 bg-green-100 rounded-lg shadow-md" role="alert">
                    {{ session('message') }}
                </div>
            @endif

            <div class="flex flex-col lg:flex-row gap-8">
                <!-- Side Panel (Details) -->
                <div class="lg:w-1/3 xl:w-1/4">
                    <div class="bg-white rounded-xl shadow-lg p-6 sticky top-24">
                        @if($selectedItem)
                            {{-- Item Details --}}
                            <h3 class="text-lg font-bold">جزئیات: {{ $selectedItem->name }}</h3>
                            <div class="mt-4 pt-4 border-t space-y-2 text-sm">
                                <p><strong>شناسه:</strong> <span class="font-mono">{{ $selectedItem->sku }}</span></p>
                                <p><strong>مقدار:</strong> {{ $selectedItem->quantity }} {{ $selectedItem->unit }}</p>
                                <div class="pt-2 mt-2 border-t">
                                    <button wire:click="confirmItemRemoval({{ $selectedItem->id }})" class="text-red-600 hover:underline">حذف از کرایوکین</button>
                                </div>
                            </div>
                        @else
                            {{-- Cane Details --}}
                            <h3 class="text-lg font-bold">اطلاعات کرایوکین</h3>
                            @php $capacity = $location->size ?? 0; @endphp
                            <div class="mt-4 pt-4 border-t space-y-2 text-sm">
                                <p><strong>ظرفیت کل:</strong> {{ $capacity }} ویال</p>
                                <p><strong>ظرفیت پر شده:</strong> {{ $itemsInGrid->count() }} ویال</p>
                                <p><strong>درصد اشغال:</strong>
                                    %{{ $capacity > 0 ? number_format(($itemsInGrid->count() / $capacity) * 100, 1) : 0 }}
                                </p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Vertical Cane View -->
                <div class="flex-grow">
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <div class="w-48 mx-auto flex flex-col items-center space-y-2">
                            <!-- Cane Top -->
                            <div class="w-24 h-4 bg-gray-400 rounded-t-md"></div>
                            <div class="w-20 h-2 bg-gray-300 rounded-sm"></div>

                            <!-- Cane Body with Slots -->
                            <div class="w-full bg-gray-200 p-2 rounded-lg space-y-2">
                                @for ($i = 1; $i <= ($location->size ?? 0); $i++)
                                    @php
                                        $item = $itemsInGrid->get($i);
                                        $colorClass = $this->getCellColorClass($item);
                                    @endphp
                                    <div wire:click="selectItem({{ $item ? $item->id : 'null' }})"
                                         class="relative w-full h-16 rounded-md p-2 border-2 transition-all duration-200 group cursor-pointer {{ $colorClass }}">
                                        @if($item)
                                            <div class="flex items-center h-full text-center text-xs">
                                                <span class="w-1/4 font-bold text-lg">{{ $i }}</span>
                                                <div class="w-3/4 border-r pr-2">
                                                    <div class="font-semibold truncate">{{ $item->name }}</div>
                                                    <div class="font-mono text-xxs mt-1 opacity-70">{{ $item->sku }}</div>
                                                </div>
                                            </div>
                                        @else
                                            <button wire:click.prevent="confirmItemPlacement('{{ $i }}')" class="w-full h-full flex items-center justify-center text-gray-400 hover:bg-gray-100 hover:text-blue-500 rounded-md transition">
                                                <x-lucide-plus class="w-8 h-8 opacity-50 group-hover:opacity-100" />
                                            </button>
                                        @endif
                                    </div>
                                @endfor
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('livewire.partials.box-viewer-modals')
</div>
