<div class="flex h-screen">
    {{-- ستون سمت راست (لیست گفتگوها) از طریق یک partial فراخوانی می‌شود --}}
    @include('livewire.chat._sidebar')

    {{-- ستون سمت چپ (پنجره چت فعال) --}}
    <main class="flex-1 flex flex-col">
        @if($activeChatRoom)
            @livewire('chat-message-manager', ['chatRoom' => $activeChatRoom], key($activeChatRoom->id))
        @else
            <div class="h-full flex items-center justify-center">
                <div class="text-center text-gray-500">
                    <x-lucide-messages-square class="w-16 h-16 mx-auto mb-4"/>
                    <p>برای شروع، یک گفتگو را از لیست انتخاب کنید.</p>
                </div>
            </div>
        @endif
    </main>

    {{-- مودال ایجاد گفتگوی جدید --}}
    <x-dialog-modal wire:model.live="confirmingNewChat">
        <x-slot name="title">
            شروع گفتگوی جدید
        </x-slot>
        <x-slot name="content">
            <div class="relative">
                <x-label for="userSearch" value="جستجوی کاربر" />
                <x-input id="userSearch" type="text" class="w-full mt-1"
                         wire:model.live.debounce.300ms="userSearch"
                         placeholder="نام یا نام کاربری را وارد کنید..."
                         autocomplete="off" />
                @if(count($userSearchResults) > 0)
                    <ul class="absolute z-50 w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-700 rounded-md mt-1 max-h-56 overflow-y-auto shadow-lg">
                        @foreach($userSearchResults as $result)
                            <li class="px-4 py-3 cursor-pointer hover:bg-blue-50 dark:hover:bg-blue-900/50"
                                wire:click="startDirectChat({{ $result->id }})">
                                <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->name }}</div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">@ {{ $result->username }}</div>
                            </li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingNewChat', false)">
                انصراف
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
</div>
