<div class="h-full flex flex-col">
    <!-- Chat Header -->
    <div class="p-4 border-b dark:border-gray-700 flex items-center gap-4">
        <div class="w-10 h-10 bg-gray-200 dark:bg-gray-700 rounded-full flex items-center justify-center">
            <x-lucide-users class="w-5 h-5 text-gray-500"/>
        </div>
        <div>
            <h3 class="font-semibold text-gray-800 dark:text-white">{{ $chatRoom->name }}</h3>
            <p class="text-xs text-gray-500">{{ $chatRoom->users->count() }} عضو</p>
        </div>
    </div>

    <!-- Chat Messages Area -->
    <div
            wire:poll.5s="loadMessages"
            class="flex-1 p-6 space-y-6 overflow-y-auto flex flex-col-reverse custom-scrollbar"
    >
        <div class="space-y-6">
            @forelse($messages as $message)
                {{-- [KEY CHANGE] افزودن wire:key برای ردیابی صحیح هر پیام --}}
                <div wire:key="{{ $message->id }}" class="flex items-start gap-3 {{ $message->user_id === Auth::id() ? 'flex-row-reverse' : '' }}">
                    <img class="h-8 w-8 rounded-full object-cover" src="{{ $message->user->profile_photo_url }}" alt="{{ $message->user->name }}">
                    <div class="max-w-xs md:max-w-md p-3 rounded-lg {{ $message->user_id === Auth::id() ? 'bg-blue-600 text-white' : 'bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200' }}">
                        <p class="text-sm">{{ $message->body }}</p>
                        <p class="text-xs mt-1 opacity-75 text-right">{{ verta($message->created_at)->format('H:i') }}</p>
                    </div>
                </div>
            @empty
                <div class="text-center text-sm text-gray-500 py-8">
                    هنوز پیامی در این اتاق گفتگو ثبت نشده است.
                </div>
            @endforelse
        </div>
    </div>

    <!-- Message Input Form -->
    <div class="p-4 bg-white dark:bg-gray-800 border-t dark:border-gray-700">
        <form wire:submit.prevent="sendMessage" class="flex items-center gap-2">
            <x-input type="text" wire:model="newMessage" class="flex-grow" placeholder="پیام خود را بنویسید..." autocomplete="off" />
            <x-button type="submit">
                <x-lucide-send class="w-5 h-5"/>
            </x-button>
        </form>
        <x-input-error for="newMessage" class="mt-2" />
    </div>
</div>
