<aside wire:poll.5s="loadChatRooms" class="w-1/3 lg:w-1/4 bg-white dark:bg-gray-800 border-l border-gray-200 dark:border-gray-700 flex flex-col">
    <div class="p-4 border-b dark:border-gray-700 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">گفتگوها</h2>
        <button wire:click="confirmNewChat" class="text-gray-400 hover:text-blue-500">
            <x-lucide-message-square-plus class="w-6 h-6"/>
        </button>
    </div>
    <nav class="flex-1 overflow-y-auto p-2">
        <ul>
            @forelse($chatRooms as $room)
                <li>
                    <a href="#" wire:click.prevent="selectChatRoom({{ $room->id }})"
                       class="flex items-center gap-3 p-3 rounded-lg transition-colors
                              {{ $activeChatRoom && $activeChatRoom->id === $room->id ? 'bg-blue-100 dark:bg-blue-900/50' : 'hover:bg-gray-100 dark:hover:bg-gray-700' }}"
                    >
                        <div class="w-10 h-10 bg-gray-200 dark:bg-gray-700 rounded-full flex items-center justify-center">
                            <x-lucide-users class="w-5 h-5 text-gray-500"/>
                        </div>
                        <div class="flex-1 overflow-hidden">
                            <p class="font-semibold text-sm truncate text-gray-800 dark:text-gray-200">{{ $room->name }}</p>
                            <p class="text-xs truncate text-gray-500 dark:text-gray-400">{{ $room->project->title ?? 'گفتگوی شخصی' }}</p>
                        </div>
                        {{-- [NEW] نشان تعداد پیام‌های خوانده نشده --}}
                        @if($room->unread_messages_count > 0)
                            <span class="bg-red-500 text-white text-xs font-bold rounded-full w-5 h-5 flex items-center justify-center">
                                    {{ $room->unread_messages_count }}
                                </span>
                        @endif
                    </a>
                </li>
            @empty
                <li class="p-4 text-center text-sm text-gray-500">
                    شما هنوز در هیچ گفتگویی عضو نیستید.
                </li>
            @endforelse
        </ul>
    </nav>
</aside>
