<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8">
    <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">گزارش عملکرد همکاران در این طرح</h3>
        <div class="w-full sm:w-64">
            <select wire:model.live="selectedCollaboratorId" class="block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                @if($collaborators->isEmpty())
                    <option>هیچ همکاری یافت نشد</option>
                @else
                    @foreach($collaborators as $collaborator)
                        <option value="{{ $collaborator->id }}">{{ $collaborator->name }}</option>
                    @endforeach
                @endif
            </select>
        </div>
    </div>

    <div wire:loading wire:target="selectedCollaboratorId" class="text-center py-8">
        <p class="text-gray-500">در حال بارگذاری اطلاعات...</p>
    </div>

    <div wire:loading.remove wire:target="selectedCollaboratorId">
        @if($selectedCollaborator)
            <div class="mt-6 grid grid-cols-1 lg:grid-cols-5 gap-8">
                <!-- Bar Chart -->
                <div class="lg:col-span-3" wire:ignore>
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">نمودار وضعیت وظایف (ماهانه)</h4>
                    <div class="h-80">
                        <canvas id="collaborator-chart-{{ $this->id() }}"></canvas>
                    </div>
                </div>
                <!-- Task List & Progress -->
                <div class="lg:col-span-2">
                    {{-- [NEW] بخش درصد پیشرفت --}}
                    <div class="mb-6">
                        <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">درصد پیشرفت کلی</h4>
                        <div class="w-full bg-gray-200 rounded-full h-4 dark:bg-gray-700">
                            <div class="bg-green-600 h-4 rounded-full text-center text-white text-xs" style="width: {{ $completionPercentage }}%">
                                {{ $completionPercentage }}%
                            </div>
                        </div>
                    </div>
                <div class="lg:col-span-2">
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">لیست وظایف محول شده</h4>
                    <div class="space-y-2 max-h-80 overflow-y-auto pr-2">
                        @forelse($tasks as $task)
                            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <p class="font-medium text-gray-900 dark:text-white">{{ $task->title }}</p>
                                <div class="flex items-center justify-between mt-1 text-xs">
                                    <span class="badge badge-primary">{{ $task->status }}</span>
                                    <span class="text-gray-500">{{ $task->due_date ? 'مهلت: ' . verta($task->due_date)->format('Y/m/d') : '' }}</span>
                                </div>
                            </div>
                        @empty
                            <p class="text-center text-sm text-gray-500 py-4">هیچ وظیفه‌ای به این کاربر محول نشده است.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        @else
            <div class="text-center py-8">
                <p class="text-gray-500">برای مشاهده آمار، یک همکار را انتخاب کنید.</p>
            </div>
        @endif
    </div>
</div>

{{--@push('scripts')--}}
{{--    <script>--}}
{{--        // تابع برای راه‌اندازی یا آپدیت نمودار--}}
{{--        function setupChart(chartData) {--}}
{{--            const chartId = 'collaborator-chart-{{ $this->id() }}';--}}
{{--            const ctx = document.getElementById(chartId);--}}

{{--            // اگه نمودار قبلی وجود داره، نابودش کن--}}
{{--            if (window.collaboratorReportChart && window.collaboratorReportChart[chartId]) {--}}
{{--                window.collaboratorReportChart[chartId].destroy();--}}
{{--            }--}}

{{--            // اگه داده‌ها معتبر باشن، نمودار جدید بساز--}}
{{--            if (ctx && chartData && chartData.labels) {--}}
{{--                if (!window.collaboratorReportChart) {--}}
{{--                    window.collaboratorReportChart = {};--}}
{{--                }--}}
{{--                window.collaboratorReportChart[chartId] = new Chart(ctx, {--}}
{{--                    type: 'bar',--}}
{{--                    data: {--}}
{{--                        labels: chartData.labels,--}}
{{--                        datasets: chartData.datasets--}}
{{--                    },--}}
{{--                    options: {--}}
{{--                        responsive: true,--}}
{{--                        maintainAspectRatio: false,--}}
{{--                        plugins: {--}}
{{--                            tooltip: { mode: 'index', intersect: false },--}}
{{--                            legend: { position: 'bottom' }--}}
{{--                        },--}}
{{--                        scales: {--}}
{{--                            x: { stacked: true },--}}
{{--                            y: { stacked: true, beginAtZero: true, ticks: { stepSize: 1 } }--}}
{{--                        }--}}
{{--                    }--}}
{{--                });--}}
{{--            }--}}
{{--            console.log('Chart Data Structure:', chartData);--}}
{{--        }--}}

{{--        // راه‌اندازی اولیه موقع لود--}}
{{--        document.addEventListener('livewire:navigated', () => {--}}
{{--            const initialChartData = @json($chartData);--}}
{{--            setupChart(initialChartData);--}}
{{--        });--}}

{{--        // آپدیت نمودار وقتی همکار تغییر می‌کنه--}}
{{--        window.addEventListener('update-collaborator-chart', (event) => {--}}
{{--            const chartData = event.detail.data;--}}
{{--            setupChart(chartData);--}}
{{--        });--}}
{{--    </script>--}}
{{--@endpush--}}
    @push('scripts')
        <script>
            document.addEventListener('livewire:navigated', () => {
                const chartId = 'collaborator-chart-{{ $this->id() }}';
                const ctx = document.getElementById(chartId);
                const initialChartData = @json($chartData);

                // اطمینان از اینکه نمونه‌های قبلی پاک شدن
                if (window.collaboratorReportChart?.[chartId]) {
                    window.collaboratorReportChart[chartId].destroy();
                }

                if (ctx && initialChartData?.labels) {
                    window.collaboratorReportChart = window.collaboratorReportChart || {};
                    window.collaboratorReportChart[chartId] = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: initialChartData.labels,
                            datasets: initialChartData.datasets
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                tooltip: { mode: 'index', intersect: false },
                                legend: { position: 'bottom' }
                            },
                            scales: {
                                x: { stacked: true },
                                y: { stacked: true, beginAtZero: true, ticks: { stepSize: 1 } }
                            }
                        }
                    });
                }
            });

            window.addEventListener('update-collaborator-chart', (event) => {
                const chartId = 'collaborator-chart-{{ $this->id() }}';
                const ctx = document.getElementById(chartId);
                const chartData = event.detail.data;

                if (window.collaboratorReportChart?.[chartId]) {
                    window.collaboratorReportChart[chartId].destroy();
                }

                if (ctx && chartData?.labels) {
                    window.collaboratorReportChart = window.collaboratorReportChart || {};
                    window.collaboratorReportChart[chartId] = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: chartData.labels,
                            datasets: chartData.datasets
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                tooltip: { mode: 'index', intersect: false },
                                legend: { position: 'bottom' }
                            },
                            scales: {
                                x: { stacked: true },
                                y: { stacked: true, beginAtZero: true, ticks: { stepSize: 1 } }
                            }
                        }
                    });
                }
            });
        </script>
@endpush
