<div
    x-data="collaboratorReportComponent(chartDataForReport)"
    x-init="init()"
    class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sm:p-8"
>
    <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">گزارش عملکرد همکاران</h3>
        <div class="w-full sm:w-64">
            <select wire:model.live="selectedCollaboratorId" class="block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                @foreach($collaborators as $collaborator)
                    <option value="{{ $collaborator->id }}">{{ $collaborator->name }}</option>
                @endforeach
            </select>
        </div>
    </div>

    <div wire:loading wire:target="selectedCollaboratorId" class="text-center py-8">
        <p class="text-gray-500">در حال بارگذاری اطلاعات...</p>
    </div>

    <div wire:loading.remove wire:target="selectedCollaboratorId">
        @if($selectedCollaborator)
            <div class="mt-6 grid grid-cols-1 lg:grid-cols-5 gap-8">
                <!-- Line Chart -->
                <div class="lg:col-span-3">
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">نمودار پیشرفت وظایف (ماهانه)</h4>
                    <div class="h-80">
                        <canvas x-ref="chart"></canvas>
                    </div>
                </div>
                <!-- Task List -->
                <div class="lg:col-span-2">
                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">لیست وظایف محول شده</h4>
                    <div class="space-y-2 max-h-80 overflow-y-auto pr-2">
                        @forelse($tasks as $task)
                            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <p class="font-medium text-gray-900 dark:text-white">{{ $task->title }}</p>
                                <div class="flex items-center justify-between mt-1 text-xs">
                                    <span class="badge badge-primary">{{ $task->status }}</span>
                                    <span class="text-gray-500">{{ $task->due_date ? 'مهلت: ' . verta($task->due_date)->format('Y/m/d') : '' }}</span>
                                </div>
                            </div>
                        @empty
                            <p class="text-center text-sm text-gray-500 py-4">هیچ وظیفه‌ای به این کاربر محول نشده است.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        @else
            <div class="text-center py-8">
                <p class="text-gray-500">برای مشاهده آمار، یک همکار را انتخاب کنید.</p>
            </div>
        @endif
    </div>
</div>

@push('scripts')
    <script>
        const chartDataForReport = @json($chartData);

        function collaboratorReportComponent(initialData) {
            return {
                chartData: initialData,
                chart: null,
                init() {
                    this.$wire.on('chartDataUpdated', (event) => {
                        this.renderChart(event.data);
                    });
                    this.renderChart(this.chartData);
                },
                renderChart(data) {
                    if (this.chart) {
                        this.chart.destroy();
                    }
                    if (!this.$refs.chart || !data || !data.labels || data.labels.length === 0) {
                        return;
                    }
                    const ctx = this.$refs.chart.getContext('2d');
                    this.chart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: data.labels,
                            datasets: [{
                                label: 'تعداد وظایف انجام شده',
                                data: data.data,
                                borderColor: '#4f46e5', // indigo-600
                                backgroundColor: 'rgba(79, 70, 229, 0.1)',
                                fill: true,
                                tension: 0.3
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            scales: {
                                y: { beginAtZero: true, ticks: { stepSize: 1 } }
                            }
                        }
                    });
                }
            }
        }
    </script>
@endpush
