<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ $note->exists ? 'ویرایش یادداشت شخصی' : 'ایجاد یادداشت شخصی جدید' }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <form wire:submit.prevent="save">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                    {{-- Main column for form and editor --}}
                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg p-6">
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <x-label for="title" value="عنوان یادداشت" />
                                        <x-input id="title" type="text" class="mt-1 block w-full" wire:model="title" />
                                        <x-input-error for="title" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-label for="note_date" value="تاریخ یادداشت" />
                                        <x-jalali-date-picker id="note_date" wire:model="note_date" />
                                        <x-input-error for="note_date" class="mt-2" />
                                    </div>
                                </div>
                                <div wire:ignore x-data="{
                                    editor: null,
                                    initEditor(content) {
                                        if (typeof Jodit === 'undefined') return;
                                        if (this.editor) this.editor.destruct();
                                        this.editor = Jodit.make($refs.editor, {
                                            direction: 'rtl',
                                            language: 'fa',
                                            height: 400,
                                        });
                                        this.editor.value = content;
                                        this.editor.events.on('change', (newValue) => {
                                            @this.set('body', newValue);
                                        });
                                    }
                                }" x-init="initEditor(@js($body))">
                                    <x-label for="body" value="محتوای یادداشت" />
                                    <textarea x-ref="editor" id="body" class="mt-1 block w-full"></textarea>
                                </div>
                                <x-input-error for="body" class="mt-2" />
                            </div>
                        </div>

                        <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg p-6">
                            <x-label value="پیوست فایل‌ها" />
                            <div class="mt-4">
                                <input type="file" wire:model="newAttachments" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100"/>
                                <div wire:loading wire:target="newAttachments" class="mt-2 text-sm text-gray-500">در حال آپلود...</div>
                                <x-input-error for="newAttachments.*" class="mt-2" />
                            </div>

                            @if ($existingAttachments->isNotEmpty())
                                <div class="mt-6 border-t dark:border-gray-700 pt-4">
                                    <p class="text-sm font-medium">فایل‌های پیوست شده:</p>
                                    <ul class="mt-2 space-y-2">
                                        @foreach ($existingAttachments as $att)
                                            <li class="flex items-center justify-between p-2 bg-gray-100 dark:bg-gray-700 rounded-md">
                                                <a href="{{ Storage::url($att->file_path) }}" target="_blank" class="text-sm font-medium text-blue-600 hover:underline">
                                                    {{ $att->file_name }}
                                                </a>
                                                <button type="button" wire:click="removeAttachment({{ $att->id }})" class="text-xs text-red-500 hover:underline">حذف</button>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        </div>
                    </div>

                    {{-- Sidebar for actions and info --}}
                    <div class="lg:col-span-1 space-y-8">
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">شناسه یادداشت</h3>
                            <div class="flex items-center justify-center h-12 w-full bg-gray-100 dark:bg-gray-900/50 rounded-lg">
                                <span class="text-gray-700 dark:text-gray-300 font-mono text-lg tracking-widest">{{ $note_code }}</span>
                            </div>
                        </div>
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sticky top-24">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">عملیات</h3>
                            <div class="mt-4 space-y-4">
                                <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-3 bg-blue-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-widest hover:bg-blue-700">
                                    <x-lucide-save class="w-5 h-5 me-2" />
                                    ذخیره یادداشت
                                </button>
                                <a href="{{ route('personal-notebook.index') }}" class="w-full inline-flex items-center justify-center px-4 py-3 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-50 dark:hover:bg-gray-600">
                                    انصراف
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </form>
        </div>
    </div>
    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/jodit@latest/es2021/jodit.fat.min.js"></script>
    @endpush
</div>
