<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
    {{-- کارت پروژه‌های فعال --}}
    <div class="bg-white dark:bg-white p-6 rounded-xl shadow-lg flex items-center justify-between border-t-4 border-blue-500">
        <div>
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">پروژه‌های فعال</p>
            <p class="text-3xl font-bold text-gray-800 dark:text-gray-200">{{ $activeProjectsCount }}</p>
        </div>
        <div class="bg-blue-100 dark:bg-blue-900/50 p-3 rounded-full">
            <x-lucide-briefcase class="w-6 h-6 text-blue-600 dark:text-blue-300" />
        </div>
    </div>
    {{-- کارت وظایf باقی‌مانده --}}
    <div class="bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg flex items-center justify-between border-t-4 border-green-500">
        <div>
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">وظایف باقی‌مانده</p>
            <p class="text-3xl font-bold text-gray-800 dark:text-gray-200">{{ $remainingTasksCount }}</p>
        </div>
        <div class="bg-green-100 dark:bg-green-900/50 p-3 rounded-full">
            <x-lucide-check-circle-2 class="w-6 h-6 text-green-600 dark:text-green-300" />
        </div>
    </div>
    {{-- کارت تجهیزات --}}
    @if($canViewEquipmentStats)
        <div class="bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg flex items-center justify-between border-t-4 border-yellow-500">
            <div>
                <p class="text-sm font-medium text-gray-500 dark:text-gray-400">تجهیزات</p>
                <p class="text-3xl font-bold text-gray-800 dark:text-gray-200">{{ $equipmentCount }}</p>
            </div>
            <div class="bg-yellow-100 dark:bg-yellow-900/50 p-3 rounded-full">
                <x-lucide-wrench class="w-6 h-6 text-yellow-600 dark:text-yellow-300" />
            </div>
        </div>
    @endif
    {{-- کارت اعضای تیم --}}
    @if($canViewTeamStats)
        <div class="bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg flex items-center justify-between border-t-4 border-purple-500">
            <div>
                <p class="text-sm font-medium text-gray-500 dark:text-gray-400">اعضای تیم</p>
                <p class="text-3xl font-bold text-gray-800 dark:text-gray-200">{{ $teamMembersCount }}</p>
            </div>
            <div class="bg-purple-100 dark:bg-purple-900/50 p-3 rounded-full">
                <x-lucide-users class="w-6 h-6 text-purple-600 dark:text-purple-300" />
            </div>
        </div>
    @endif
</div>
