<div>
    {{-- هدر صفحه --}}
    <link href="https://cdn.jsdelivr.net/npm/jodit@latest/es2021/jodit.fat.min.css" rel="stylesheet">
    <style>
        .comment-highlight {
            background-color: #a0e8ff; /* A light blue highlight */
            border-bottom: 2px dotted #007bff;
            cursor: pointer;
        }
    </style>

    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            ویرایش یادداشت: <span class="font-bold text-blue-600 dark:text-blue-400">{{ $entry->title }}</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            {{-- نمایش پیام‌های سیستم --}}
            @if (session()->has('message'))
                <div class="mb-6 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300 shadow-md" role="alert">
                    <span class="font-medium">موفقیت!</span> {{ session('message') }}
                </div>
            @endif

            {{-- نوار هشدار برای یادداشت قفل شده --}}
            @if($entry->is_locked)
                <div class="mb-6 p-4 text-sm text-yellow-800 bg-yellow-100 rounded-lg dark:bg-yellow-900 dark:text-yellow-300 shadow-md flex items-center">
                    <x-lucide-lock class="w-5 h-5 ml-2 flex-shrink-0"/>
                    <span class="font-medium">این یادداشت قفل شده است و قابل ویرایش نیست.</span>
                </div>
            @endif

            <form wire:submit.prevent="update">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                    {{-- ستون اصلی (دو سوم) برای فرم و ویرایشگر --}}
                    <div class="md:col-span-2">
                        <div
                            class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6"
                            x-data="{
                                editor: null,
                                initEditor() {
                                    Alpine.nextTick(() => {
                                        if (typeof Jodit === 'undefined') { return; }
                                        if (this.editor) this.editor.destruct();

                                        const wire = this.$wire;
                                        const addCommentButton = {
                                            tooltip: 'افزودن نظر روی متن انتخابی',
                                            icon: `<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='24' height='24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'><path d='M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z'></path><line x1='12' y1='11' x2='12' y2='11'></line><line x1='16' y1='11' x2='16' y2='11'></line><line x1='8' y1='11' x2='8' y2='11'></line></svg>`,
                                            update(editor) {
                                                const btn = editor.toolbar.buttons.find(b => b.name === 'addComment');
                                                if (btn) {
                                                    btn.state.disabled = editor.selection.isCollapsed();
                                                }
                                            },
                                            exec(editor) {
                                                if (editor.selection.isCollapsed()) return;

                                                const anchorId = `comment-anchor-${Date.now()}`;

                                                const span = editor.create.element('span');
                                                span.id = anchorId;
                                                span.className = 'comment-highlight';

                                                // [FIXED] Use the correct Jodit API method 'wrapInTag'
                                                editor.selection.wrapInTag(span);

                                                wire.startCommentOnSelection(anchorId);
                                            }
                                        };

                                        this.editor = Jodit.make(this.$refs.editor, {
                                            direction: 'rtl',
                                            language: 'fa',
                                            height: 400,
                                            controls: { addComment: addCommentButton },
                                            buttons: ['bold', 'italic', 'underline', '|', 'ul', 'ol', '|', 'image', 'table', 'link', '|', 'addComment', '|', 'undo', 'redo'],
                                        });

                                        this.editor.value = wire.get('body');
                                        this.editor.events.on('change.debounce', (newValue) => {
                                            wire.set('body', newValue, false);
                                        }, 500);
                                    });
                                }
                            }"
                            x-init="initEditor()"
                            @update-editor-content.window="if(editor) editor.value = $event.detail.content"
                            {{-- [FIXED] Event listener with the correct Jodit API --}}
                            @insert-chart-in-editor.window="
                                if (editor) {
                                    const imgHTML = `<img src='${$event.detail.imageData}' style='max-width: 100%; height: auto;'>`;
                                    editor.s.insertHTML(imgHTML);
                                }
                            "
                            @insert-html-in-editor.window="
                                if (editor) {
                                    editor.focus(); // Force focus back to the editor
                                    // Use a small timeout to ensure the focus event has completed
                                    setTimeout(() => {
                                        editor.selection.insertHTML($event.detail.html);
                                    }, 50);
                                }
                            "
                            @insert-text-in-editor.window="if(editor) { editor.s.insertHTML($event.detail.text); }"
                        >
                            <div class="p-6 sm:p-8 space-y-6">
                                {{-- Title --}}
                                <div>
                                    <x-label class="text-white" for="title" value="عنوان یادداشت" />
                                    <x-input id="title" type="text" class="mt-1 block w-full" wire:model.defer="title" :disabled="$entry->is_locked" />
                                    <x-input-error for="title" class="mt-2" />
                                </div>

                                {{-- Entry Date --}}
                                {{-- [UPDATED] Entry Date with Jalali Date Picker --}}
                                <div>
                                    <x-label class="text-white" for="entry_date" value="تاریخ انجام آزمایش" />
                                    <x-jalali-date-picker id="entry_date" wire:model="entry_date"  />
                                    <x-input-error for="entry_date" class="mt-2" />
                                </div>
                                {{-- [NEW] Custom Editor Toolbar --}}
                                @if(!$entry->is_locked)
                                    <div class="flex justify-between items-center border-b dark:border-gray-700 pb-2">
                                        <x-label class="text-white" for="body" value="{{ __('محتوای یادداشت') }}" />
                                        <div class="flex items-center gap-2">
                                            {{-- [NEW] Preview Content Button --}}
                                            <button type="button" wire:click="generatePreview" class="p-2 text-white/50 hover:text-cyan-600 rounded-full hover:bg-cyan-100 dark:hover:bg-cyan-900/50 transition" title="پیش‌نمایش محتوا">
                                                <x-lucide-eye class="w-5 h-5"/>
                                            </button>
                                            <button type="button" wire:click="openEntrySelector" class="p-2 text-white/50 hover:text-purple-600 rounded-full hover:bg-purple-100 dark:hover:bg-purple-900/50 transition" title="درج ارجاع به یادداشت">
                                                <x-lucide-link-2 class="w-5 h-5"/>
                                            </button>
                                            <button type="button" wire:click="$dispatch('openChartModal')" class="p-2 text-white/50 hover:text-blue-600 rounded-full hover:bg-blue-100 dark:hover:bg-blue-900/50 transition" title="افزودن نمودار">
                                                <x-lucide-pie-chart class="w-5 h-5"/>
                                            </button>
                                            <button type="button" wire:click="$dispatch('openDataImporterModal')" class="p-2 text-white/50 hover:text-green-600 rounded-full hover:bg-green-100 dark:hover:bg-green-900/50 transition" title="درج داده از فایل">
                                                <x-lucide-file-spreadsheet class="w-5 h-5"/>
                                            </button>
                                        </div>
                                    </div>
                                @endif
                                {{-- Jodit Editor Container --}}
                                <div wire:ignore>
                                    <textarea x-ref="editor" id="body_note_edit" @if($entry->is_locked) disabled @endif>{{ $body }}</textarea>
                                </div>
                                <x-input-error for="body" class="mt-2" />
                                {{-- [NEW] بخش مدیریت پیوست‌ها --}}
                                <div class="border-t dark:border-gray-700 pt-4">
                                    <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-2">پیوست‌ها</h4>

                                    {{-- نمایش پیوست‌های موجود --}}
                                    <div class="space-y-2">
                                        @forelse($existingAttachments as $attachment)
                                            <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                                <a href="{{ Storage::url($attachment['file_path']) }}" target="_blank" class="flex items-center gap-3">
                                                    <x-lucide-file class="w-5 h-5 text-gray-400"/>
                                                    <span class="text-sm font-medium">{{ $attachment['file_name'] }}</span>
                                                </a>
                                                {{-- [NEW] Analyze Image Button (only for images) --}}
                                                @if(Str::startsWith($attachment['mime_type'], 'image'))
                                                    <button type="button" wire:click="analyzeAttachment({{ $attachment['id'] }})" class="text-blue-500 hover:text-blue-700" title="تحلیل تصویر">
                                                        <x-lucide-scan-line class="w-4 h-4"/>
                                                    </button>
                                                @endif
                                                <button type="button" wire:click="deleteAttachment({{ $attachment['id'] }})" class="text-red-500 hover:text-red-700">
                                                    <x-lucide-trash-2 class="w-4 h-4"/>
                                                </button>
                                            </div>
                                        @empty
                                            <p class="text-xs text-gray-500 italic">هیچ فایلی پیوست نشده است.</p>
                                        @endforelse
                                    </div>

                                    {{-- بخش آپلود فایل جدید --}}
                                    <div
                                        x-data="{ isDragging: false }"
                                        class="mt-4"
                                    >
                                        <div
                                            @dragover.prevent="isDragging = true"
                                            @dragleave.prevent="isDragging = false"
                                            @drop.prevent="isDragging = false; @this.uploadMultiple('newAttachments', $event.dataTransfer.files)"
                                            :class="{'border-blue-500 bg-blue-50 dark:bg-blue-900/20': isDragging}"
                                            class="flex justify-center rounded-lg border-2 border-dashed border-gray-300 dark:border-gray-600 px-6 py-10 transition-colors"
                                        >
                                            <div class="text-center">
                                                <x-lucide-upload-cloud class="mx-auto h-12 w-12 text-gray-400" />
                                                <div class="mt-4 flex text-sm text-gray-600 dark:text-gray-400">
                                                    <label for="attachments-input" class="relative cursor-pointer rounded-md font-semibold text-indigo-600 dark:text-indigo-400">
                                                        <span>فایل‌های جدید را انتخاب کنید</span>
                                                        <input id="attachments-input" wire:model="newAttachments" type="file" class="sr-only" multiple>
                                                    </label>
                                                    <p class="pl-1">یا آن‌ها را بکشید و در اینجا رها کنید</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- کارت مواد مصرفی --}}
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600">
                            {{-- [NEW] کارت وضعیت درخواست‌های انبار --}}
                            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-purple-600">
                                <div class="p-6 sm:p-8">
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">وضعیت درخواست‌های انبار</h3>
                                    <div class="flow-root">
                                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="py-3.5 pl-4 pr-3 text-right text-sm font-semibold text-gray-900 dark:text-white">زمان درخواست</th>
                                                <th class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">ماده</th>
                                                <th class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">نوع</th>
                                                <th class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">مقدار</th>
                                                <th class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">وضعیت</th>
                                                <th class="px-3 py-3.5 text-right text-sm font-semibold text-gray-900 dark:text-white">یادداشت</th>
                                            </tr>
                                            </thead>
                                            <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
                                            @forelse($entry->consumptionRequests as $request)
                                                <tr>
                                                    <td class="py-4 pl-4 pr-3 text-sm font-medium text-gray-900 dark:text-white">{{ $request->created_at ? verta($request->created_at)->format('Y/m/d') : '-' }}</td>
                                                    <td class="py-4 pl-4 pr-3 text-sm font-medium text-gray-900 dark:text-white">{{ $request->inventoryItem->name }}</td>
                                                    <td class="px-3 py-4 text-sm">
                                                        @if($request->type === 'consumption')
                                                            <span class="badge badge-danger">مصرف</span>
                                                        @else
                                                            <span class="badge badge-success">بازگشت</span>
                                                        @endif
                                                    </td>
                                                    <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $request->quantity }} {{ $request->inventoryItem->unit }}</td>
                                                    <td class="px-3 py-4 text-sm">
                                                        @if($request->status === 'pending')
                                                            <span class="badge badge-warning">در انتظار تایید</span>
                                                            <p class="text-gray-500 dark:text-gray-400">در تاریخ: {{ $request->processed_at ? verta($request->processed_at)->format('Y/m/d') : '-' }}</p>
                                                        @elseif($request->status === 'approved')
                                                            <span class="badge badge-success">تایید شده</span>
                                                            <p class="text-gray-500 dark:text-gray-400 font-extralight">در تاریخ: {{ $request->processed_at ? verta($request->processed_at)->format('Y/m/d') : '-' }}</p>
                                                        @else
                                                            <span class="badge badge-danger">رد شده</span>
                                                            <p class="text-gray-500 dark:text-gray-400">در تاریخ: {{ $request->processed_at ? verta($request->processed_at)->format('Y/m/d') : '-' }}</p>
                                                        @endif
                                                    </td>
                                                    <td class="px-3 py-4 text-sm text-gray-500 dark:text-gray-400" title="{{ $request->notes }}">{{ \Illuminate\Support\Str::limit($request->notes, 30) }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center py-6 text-sm text-gray-500">هیچ درخواستی برای این یادداشت ثبت نشده است.</td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="p-6 sm:p-8">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-1">مواد و معرف‌های مصرفی</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-6">مواد مصرف شده در این آزمایش را مدیریت کنید.</p>

                                <div class="space-y-6">
                                    @if(!$entry->is_locked)
                                        <!-- Search Box -->
                                        <div class="relative">
                                            <x-label for="materialSearch" value="جستجوی آیتم انبار" />
                                            <div class="relative mt-1">
                                                <x-input id="materialSearch" type="text" class="w-full pl-10"
                                                         wire:model.live.debounce.300ms="materialSearch"
                                                         placeholder="جستجو بر اساس نام یا کد شناسایی..."
                                                         autocomplete="off" />
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                                    <x-lucide-search class="w-5 h-5 text-gray-400" />
                                                </div>
                                            </div>
                                            @if(count($materialSearchResults) > 0)
                                                <ul class="absolute z-20 w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-700 rounded-md mt-1 max-h-56 overflow-auto shadow-lg">
                                                    @foreach($materialSearchResults as $result)
                                                        <li class="px-4 py-3 cursor-pointer hover:bg-blue-50 dark:hover:bg-blue-900/50"
                                                            wire:click="addMaterial({{ $result->id }})">
                                                            <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->name }}</div>
                                                            <div class="text-sm text-gray-500 dark:text-gray-400">شناسه: {{ $result->sku }} | موجودی: {{ $result->quantity }} {{ $result->unit }}</div>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @endif
                                        </div>
                                    @endif

                                    <!-- Used Materials List -->
                                    <div class="space-y-3">
                                        @forelse ($usedMaterials as $index => $material)
                                            <div class="flex items-center gap-4 p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg border border-gray-200 dark:border-gray-700">
                                                <div class="flex-grow">
                                                    <p class="font-medium text-gray-900 dark:text-gray-200">{{ $material['name'] }}</p>
                                                    <p class="text-xs text-gray-500 dark:text-gray-400">شناسه: {{ $material['sku'] }}</p>
                                                </div>
                                                <div class="w-32">
                                                    <x-input type="number" step="any" class="block w-full text-center"
                                                             placeholder="مقدار"
                                                             wire:model.defer="usedMaterials.{{ $index }}.quantity_used"
                                                             :disabled="!auth()->user()->can('manageMaterials', $entry) || $entry->is_locked || $material['is_locked_by_request']"
                                                    />
                                                </div>
                                                <span class="text-sm text-gray-600 dark:text-gray-300 w-12 text-right">{{ $material['unit'] }}</span>
                                                {{-- [UPDATED] دکمه‌ها فقط در صورتی نمایش داده می‌شوند که آیتم قفل نباشد --}}
                                                <div class="flex items-center space-x-2 space-x-reverse">
                                                    @if(!$material['is_locked_by_request'] && !$entry->is_locked)
                                                        @can('manageMaterials', $entry)
                                                            {{-- این دکمه‌ها اکنون دیگر کاربردی ندارند چون همه چیز از طریق متد update انجام می‌شود، اما برای حفظ ظاهر، آن‌ها را غیرفعال می‌کنیم --}}
                                                            <button type="button" title="حذف از لیست" wire:click="removeMaterial({{ $material['id'] }})" class="text-gray-400 hover:text-red-600 transition duration-150">
                                                                <x-lucide-trash-2 class="w-5 h-5" />
                                                            </button>
                                                        @endcan
                                                    @else
                                                        <span title="برای این آیتم درخواست گردش انبار ثبت شده و قابل تغییر نیست." class="cursor-help">
                                         <x-lucide-lock class="w-5 h-5 text-gray-400" />
                                    </span>
                                                    @endif
                                                </div>
                                            </div>
                                            <x-input-error for="usedMaterials.{{$index}}.quantity_used" class="mt-1" />
                                        @empty
                                            <div class="text-center py-8 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg">
                                                <x-lucide-beaker class="mx-auto h-12 w-12 text-gray-400" />
                                                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">هیچ ماده‌ای ثبت نشده</h3>
                                                <p class="mt-1 text-sm text-gray-500">در صورت نیاز، یک آیتم را از انبار جستجو و اضافه کنید.</p>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    {{-- ستون کناری (یک سوم) --}}
                    <div class="lg:col-span-1 space-y-8">
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-blue-600 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">عملیات</h3>
                            <div class="space-y-4">
                                @if(!$entry->is_locked)
                                    <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-3 bg-blue-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                                        <x-lucide-save class="w-5 h-5 ml-2" />
                                        ذخیره تغییرات
                                    </button>
                                    {{-- [NEW] AI Analysis Button --}}
                                    <button type="button" wire:click="analyzeWithAI" wire:loading.attr="disabled" class="w-full btn btn-secondary flex items-center justify-center">
                                        <span wire:loading.remove wire:target="analyzeWithAI" class="flex items-center">
                                             <x-lucide-wand-2 class="w-5 h-5 ml-2" />
                                             تحلیل با هوش مصنوعی
                                        </span>
                                        <span wire:loading wire:target="analyzeWithAI">
                                             <div class="spinner-border spinner-border-sm" role="status"></div>
                                             <span class="ml-2">در حال تحلیل...</span>
                                        </span>
                                    </button>
                                    <button type="button" wire:click="confirmActivityRequest" class="w-full inline-flex items-center justify-center px-4 py-3 bg-indigo-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                        <x-lucide-send class="w-5 h-5 ml-2" />
                                        درخواست فعالیت
                                    </button>
                                @endif
                                <a href="{{ route('projects.show', $entry->project) }}" class="w-full inline-flex items-center justify-center px-4 py-3 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                    بازگشت
                                </a>
                            </div>

                            <hr class="my-6 dark:border-gray-700">

                            <div class="space-y-4">
                                @can('sign', $entry)
                                    <button type="button" wire:click="confirmSignature" class="w-full inline-flex items-center justify-center px-4 py-3 bg-teal-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-widest hover:bg-teal-700 active:bg-teal-800 focus:outline-none focus:ring-2 focus:ring-teal-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                        <x-lucide-pen-square class="w-5 h-5 ml-2" />
                                        امضا یادداشت
                                    </button>
                                @endcan
                                @can('toggleLock', $entry)
                                    <button type="button" wire:click="toggleLock" class="w-full inline-flex items-center justify-center px-4 py-3 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-widest transition ease-in-out duration-150 {{ $entry->is_locked ? 'bg-green-600 hover:bg-green-700' : 'bg-red-600 hover:bg-red-700' }}">
                                        @if($entry->is_locked)
                                            <x-lucide-unlock class="w-5 h-5 ml-2" />
                                            <span>باز کردن قفل</span>
                                        @else
                                            <x-lucide-lock class="w-5 h-5 ml-2" />
                                            <span>قفل کردن یادداشت</span>
                                        @endif
                                    </button>
                                @endcan
                            </div>
                        </div>
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-amber-500 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">برچسب‌ها (Tags)</h3>
                            <div
                                x-data="{
            newTag: '',
            tags: @entangle('tags'),
            allTags: {{ $allTags }},
            filteredTags: [],
            filterTags() {
                if (this.newTag === '') {
                    this.filteredTags = [];
                    return;
                }
                this.filteredTags = this.allTags.filter(tag => tag.toLowerCase().includes(this.newTag.toLowerCase()) && !this.tags.includes(tag));
            },
            addTag(tag) {
                let tagToAdd = tag.trim();
                if (tagToAdd !== '' && !this.tags.includes(tagToAdd)) {
                    this.tags.push(tagToAdd);
                }
                this.newTag = '';
                this.filteredTags = [];
            },
            removeTag(tag) {
                this.tags = this.tags.filter(t => t !== tag);
            }
        }"
                            >
                                {{-- Display existing tags --}}
                                <div class="flex flex-wrap gap-2 mb-4">
                                    <template x-for="tag in tags" :key="tag">
                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-300">
                    <span x-text="tag"></span>
                    <button @click="removeTag(tag)" class="ms-1.5 -me-0.5 text-amber-500 hover:text-amber-700">
                        &times;
                    </button>
                </span>
                                    </template>
                                </div>

                                {{-- Input for new tags --}}
                                <div class="relative">
                                    <x-input
                                        type="text"
                                        class="w-full"
                                        placeholder="افزودن برچسب..."
                                        x-model="newTag"
                                        @input.debounce.300ms="filterTags()"
                                        @keydown.enter.prevent="addTag(newTag)"
                                        @keydown.escape="newTag = ''; filteredTags = []"
                                    />
                                    {{-- Autocomplete suggestions --}}
                                    <div x-show="filteredTags.length > 0" class="absolute z-10 w-full bg-white dark:bg-gray-700 border rounded-md mt-1 max-h-40 overflow-auto shadow-lg">
                                        <template x-for="tag in filteredTags" :key="tag">
                                            <div @click="addTag(tag)" class="px-3 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600" x-text="tag"></div>
                                        </template>
                                    </div>
                                </div>
                                <p class="text-xs text-gray-500 mt-1">برای افزودن، نام برچسب را تایپ کرده و Enter را بزنید.</p>
                            </div>
                        </div>

                        <!-- [NEW] Comments Card -->
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-cyan-500 p-6">
                            <div class="flex items-center mb-4">
                                <x-lucide-messages-square class="w-6 h-6 ml-2 text-cyan-500"/>
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">نظرات و گفتگو</h3>
                            </div>

                            {{-- Form to add a new comment --}}
                            <div class="mb-6" x-data @focus-comment-input.window="$refs.commentInput.focus()">
                                <textarea x-ref="commentInput" wire:model.defer="newComment" rows="3" class="form-input w-full rounded-md dark:bg-gray-900 dark:border-gray-700" placeholder="نظر خود را بنویسید... (@username)"></textarea>
                                <x-input-error for="newComment" class="mt-1" />
                                <x-button type="button" wire:click="addComment" class="mt-2">ثبت نظر</x-button>
                            </div>

                            {{-- List of comments --}}
                            <div class="space-y-5 max-h-96 overflow-y-auto custom-scrollbar pr-2">
                                @forelse ($comments as $comment)
                                    <div class="flex items-start space-x-3 space-x-reverse">
                                        <img class="h-8 w-8 rounded-full" src="{{ $comment->user->profile_photo_url }}" alt="{{ $comment->user->name }}">
                                        <div class="flex-1">
                                            <div class="bg-gray-100 dark:bg-gray-700 rounded-lg p-3">
                                                <div class="flex items-center justify-between">
                                                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-200">{{ $comment->user->name }}</p>
                                                    @if($comment->comment_anchor_id)
                                                        <button type="button" onclick="document.getElementById('{{ $comment->comment_anchor_id }}').scrollIntoView({behavior: 'smooth', block: 'center'});"
                                                                class="text-gray-400 hover:text-cyan-500" title="نمایش در متن">
                                                            <x-lucide-crosshair class="w-4 h-4"/>
                                                        </button>
                                                    @endif
                                                    @if(Auth::id() == $comment->user_id)
                                                        <button type="button" wire:click="deleteComment({{ $comment->id }})" class="text-gray-400 hover:text-red-500">
                                                            <x-lucide-trash-2 class="w-4 h-4"/>
                                                        </button>
                                                    @endif
                                                </div>
                                                <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">{!! nl2br(e($comment->body)) !!}</p>
                                            </div>
                                            <div class="flex items-center gap-4 mt-1">
                                                <p class="text-xs text-gray-500">{{ verta($comment->created_at)->formatDifference() }}</p>
                                                {{-- [NEW] Reply Button --}}
                                                <button type="button" wire:click="startReply({{ $comment->id }})" class="text-xs font-semibold text-blue-600 hover:underline">پاسخ</button>
                                            </div>

                                            {{-- [NEW] Reply Form --}}
                                            @if($replyingToCommentId === $comment->id)
                                                <div class="mt-3">
                                                    <textarea wire:model.defer="replyBody" rows="2" class="form-input w-full rounded-md text-sm dark:bg-gray-900 dark:border-gray-600" placeholder="پاسخ خود را بنویسید..."></textarea>
                                                    <x-input-error for="replyBody" class="mt-1" />
                                                    <div class="flex items-center gap-2 mt-2">
                                                        @if($comment->comment_anchor_id)
                                                            <button type="button" onclick="document.getElementById('{{ $comment->comment_anchor_id }}').scrollIntoView({behavior: 'smooth', block: 'center'});"
                                                                    class="text-gray-400 hover:text-cyan-500" title="نمایش در متن">
                                                                <x-lucide-crosshair class="w-4 h-4"/>
                                                            </button>
                                                        @endif
                                                        <x-button type="button" wire:click="addReply" size="sm">ثبت پاسخ</x-button>
                                                        <x-secondary-button wire:click="cancelReply" size="sm">انصراف</x-secondary-button>
                                                    </div>
                                                </div>
                                            @endif


                                            {{-- Replies to the comment --}}
                                            @if($comment->replies->isNotEmpty())
                                                <div class="mt-3 space-y-3 pl-4 border-r-2 dark:border-gray-600">
                                                    @foreach($comment->replies as $reply)
                                                        <div class="flex items-start space-x-3 space-x-reverse">
                                                            <img class="h-8 w-8 rounded-full" src="{{ $reply->user->profile_photo_url }}" alt="{{ $reply->user->name }}">
                                                            <div class="flex-1">
                                                                <div class="bg-gray-100 dark:bg-gray-700 rounded-lg p-3">
                                                                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-200">{{ $reply->user->name }}</p>
                                                                    <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">{!! nl2br(e($reply->body)) !!}</p>
                                                                </div>
                                                                <p class="text-xs text-gray-500 mt-1">{{ verta($reply->created_at)->formatDifference() }}</p>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @empty
                                    <div class="text-center py-8 text-sm text-gray-500">
                                        هنوز هیچ نظری ثبت نشده است.
                                    </div>
                                @endforelse
                            </div>
                        </div>

                        {{-- کارت تاریخچه نسخه‌ها --}}

                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-purple-600">
                            <div class="p-6">
                                <div class="flex justify-between items-center mb-4">
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">تاریخچه نسخه‌ها</h3>
                                    {{-- [NEW] Compare Button --}}
                                    <button
                                        type="button"
                                        wire:click="$dispatch('showVersionComparer', { versionIds: $wire.versionsToCompare })"
                                        @disabled(count($versionsToCompare) !== 2)
                                        class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 disabled:opacity-50 disabled:cursor-not-allowed"
                                    >
                                        <x-lucide-git-compare class="w-5 h-5 ml-2"/>
                                        مقایسه
                                    </button>
                                </div>
                                <div class="mt-4 space-y-3 max-h-96 overflow-y-auto custom-scrollbar pr-2">
                                    @forelse ($entry->versions()->latest('version')->get() as $version)
                                        <div class="p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg border border-gray-200 dark:border-gray-700">
                                            <div class="flex justify-between items-start">
                                                {{-- [NEW] Checkbox for selection --}}
                                                <div class="flex items-start gap-3">
                                                    <input type="checkbox"
                                                           value="{{ $version->id }}"
                                                           wire:model.live="versionsToCompare"
                                                           class="mt-1 form-checkbox h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                    >
                                                    <div>
                                                        <p class="text-sm font-semibold text-gray-800 dark:text-gray-200">
                                                            نسخه {{ $version->version }}
                                                        </p>
                                                        <p class="text-xs mt-1 text-gray-600 dark:text-gray-300">
                                                            توسط: {{ $version->user->first_name ?? 'کاربر حذف شده' }}
                                                            <span class="mx-1">|</span>
                                                            {{ verta($version->created_at)->format('Y/m/d H:i') }}
                                                        </p>
                                                    </div>
                                                </div>
                                                <button
                                                    type="button"
                                                    wire:click="$dispatch('showVersionViewer', { versionId: {{ $version->id }} })"
                                                    class="inline-flex items-center px-3 py-1.5 border border-gray-300 dark:border-gray-600 text-xs font-medium rounded-md shadow-sm text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700"
                                                >
                                                    <x-lucide-eye class="w-4 h-4"/>
                                                </button>
                                            </div>
                                        </div>
                                    @empty
                                        <div class="text-center py-8 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg">
                                            <x-lucide-history class="mx-auto h-12 w-12 text-gray-400" />
                                            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">بدون تاریخچه</h3>
                                            <p class="mt-1 text-sm text-gray-500">هنوز نسخه‌ای برای این یادداشت ثبت نشده است.</p>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{-- مودال مدیریت کپشن‌ها برای فایل‌های جدید --}}
    <x-dialog-modal wire:model.live="confirmingAttachments" maxWidth="2xl">
        <x-slot name="title">
            مدیریت پیوست‌های جدید
        </x-slot>
        <x-slot name="content">
            <div class="space-y-4 max-h-96 overflow-y-auto">
                @foreach($newAttachments as $index => $attachment)
                    <div class="p-4 border rounded-lg flex items-start gap-4">
                        @if(Str::startsWith($attachment->getMimeType(), 'image'))
                            <img src="{{ $attachment->temporaryUrl() }}" class="w-24 h-24 object-cover rounded-md">
                        @else
                            <div class="w-24 h-24 bg-gray-100 rounded-md flex items-center justify-center">
                                <x-lucide-file-text class="w-10 h-10 text-gray-400"/>
                            </div>
                        @endif
                        <div class="flex-1">
                            <p class="text-sm font-semibold">{{ $attachment->getClientOriginalName() }}</p>
                            <x-input type="text" class="w-full mt-2" wire:model="attachmentCaptions.{{ $index }}" placeholder="کپشن (اختیاری)..." />
                        </div>
                    </div>
                @endforeach
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-button wire:click="saveNewAttachments">
                افزودن پیوست‌ها
            </x-button>
        </x-slot>
    </x-dialog-modal>
    {{-- تمام مودال‌ها در اینجا قرار می‌گیرند --}}
    <!-- Modal برای درخواست فعالیت -->
    <x-dialog-modal wire:model.live="confirmingActivityRequest">
        <x-slot name="title">
            {{ __('درخواست فعالیت جدید') }}
        </x-slot>
        <x-slot name="content">
            <div class="space-y-4">
                <div>
                    <x-label for="activityType" value="{{ __('نوع فعالیت') }}" />
                    <select id="activityType" wire:model.defer="activityType" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                        <option value="">انتخاب کنید...</option>
                        <option value="بررسی">بررسی</option>
                        <option value="آرشیوسازی">آرشیوسازی</option>
                        <option value="امضا">امضا</option>
                        <option value="قفل یادداشت">قفل یادداشت</option>
                    </select>
                    <x-input-error for="activityType" class="mt-2" />
                </div>

                <div class="relative">
                    <x-label for="activitySearch" value="{{ __('انتخاب مسئول') }}" />
                    <x-input id="activitySearch" type="text" class="mt-1 block w-full"
                             wire:model.live.debounce.300ms="activitySearch"
                             placeholder="جستجوی همکار..." autocomplete="off"/>

                    @if(count($activitySearchResults) > 0)
                        <ul class="absolute z-50 w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md mt-1 max-h-56 overflow-auto">
                            @foreach($activitySearchResults as $result)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="selectActivityAssignee({{ $result->id }})">
                                    <div class="font-bold text-gray-800 dark:text-gray-200">{{ $result->first_name }} {{ $result->last_name }}</div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">@ {{ $result->username }}</div>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                    <x-input-error for="activityAssigneeId" class="mt-2" />
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingActivityRequest')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-button class="ms-3" wire:click="sendActivityRequest" wire:loading.attr="disabled">
                {{ __('ارسال درخواست') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای بازگشت به انبار -->
    <!-- [UPDATED] Modal برای خطای موجودی / بودجه -->
    <x-dialog-modal wire:model.live="confirmingStockError">
        <x-slot name="title">
            <span class="flex items-center {{ $hasHardErrors ? 'text-red-600' : 'text-yellow-500' }}">
                @if($hasHardErrors)
                    <x-lucide-ban class="w-6 h-6 ml-2"/>
                    خطای اعتبارسنجی
                @else
                    <x-lucide-alert-triangle class="w-6 h-6 ml-2"/>
                    هشدار موجودی انبار
                @endif
            </span>
        </x-slot>
        <x-slot name="content">
            <div class="space-y-2">
                {!! $stockErrorMessage !!}
            </div>
        </x-slot>
        <x-slot name="footer">
            {{-- اگر خطای سخت وجود دارد، فقط دکمه "متوجه شدم" نمایش داده می‌شود --}}
            @if($hasHardErrors)
                <x-secondary-button wire:click="$set('confirmingStockError', false)" class="ms-3">
                    {{ __('متوجه شدم') }}
                </x-secondary-button>
                {{-- در غیر این صورت (فقط هشدار نرم)، دکمه "ادامه" نیز نمایش داده می‌شود --}}
            @else
                <x-secondary-button wire:click="$set('confirmingStockError', false)" wire:loading.attr="disabled">
                    {{ __('انصراف') }}
                </x-secondary-button>
                <x-button class="ms-3" wire:click="proceedWithUpdate" wire:loading.attr="disabled">
                    {{ __('ادامه و ارسال درخواست') }}
                </x-button>
            @endif
        </x-slot>
    </x-dialog-modal>

    <x-dialog-modal wire:model.live="confirmingReturnToStock">
        <x-slot name="title">
            {{ __('بازگشت به انبار') }}
        </x-slot>
        <x-slot name="content">
            <p>چه مقداری از <span class="font-bold">{{ $itemToReturnName ?? '' }}</span> به انبار بازگردانده شود؟</p>
            <div class="mt-4">
                <x-input type="number" step="any" class="mt-1 block w-full"
                         placeholder="مقدار بازگشتی"
                         wire:model.defer="quantityToReturn" />
                <x-input-error for="quantityToReturn" class="mt-2" />
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingReturnToStock')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-button class="ms-3" wire:click="returnToStock" wire:loading.attr="disabled">
                {{ __('بازگرداندن') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای تایید حذف کامل -->
    <x-confirmation-modal wire:model.live="confirmingMaterialRemoval">
        <x-slot name="title">
            {{ __('حذف آیتم مصرفی') }}
        </x-slot>
        <x-slot name="content">
            {{ __('آیا مطمئن هستید؟ با این کار، آیتم از لیست حذف و تمام مقدار مصرفی آن به انبار بازگردانده می‌شود.') }}
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingMaterialRemoval')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="removeMaterialAndReturnStock" wire:loading.attr="disabled">
                {{ __('حذف و بازگرداندن') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
    <!-- Modal برای تایید امضا -->
    <x-dialog-modal wire:model.live="confirmingSignature">
        <x-slot name="title">
            {{ __('تایید امضا و قفل کردن یادداشت') }}
        </x-slot>
        <x-slot name="content">
            {{ __('برای تایید هویت و امضای این یادداشت، لطفاً رمز عبور خود را وارد کنید.') }}
            <div class="mt-4" x-data="{}" x-on:confirming-signature.window="setTimeout(() => $refs.password.focus(), 250)">
                <x-input type="password" class="mt-1 block w-3/4"
                         placeholder="{{ __('رمز عبور') }}"
                         x-ref="password"
                         wire:model.defer="password"
                         wire:keydown.enter="signEntry" />
                <x-input-error for="password" class="mt-2" />
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingSignature')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-button class="ms-3" wire:click="signEntry" wire:loading.attr="disabled">
                {{ __('امضا و قفل کردن') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    {{-- [NEW] AI Analysis Results Modal --}}
    <x-dialog-modal wire:model.live="showAnalysisModal">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-brain-circuit class="w-6 h-6 ml-2 text-blue-500"/>
                نتایج تحلیل هوش مصنوعی
            </div>
        </x-slot>
        <x-slot name="content">
            @if($analysisResult)
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold border-b pb-2 mb-2">خلاصه گزارش</h3>
                        <p class="text-gray-700 dark:text-gray-300 leading-relaxed">{{ $analysisResult['summary'] }}</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold border-b pb-2 mb-2">اطلاعات کلیدی استخراج شده</h3>
                        <ul class="list-disc list-inside space-y-2">
                            @forelse($analysisResult['entities'] as $entity)
                                <li>
                                    <span class="font-bold">{{ $entity['type'] }}:</span>
                                    <span class="text-gray-700 dark:text-gray-300">{{ $entity['value'] }}</span>
                                </li>
                            @empty
                                <p class="text-gray-500 italic">هیچ اطلاعات کلیدی یافت نشد.</p>
                            @endforelse
                        </ul>
                    </div>
                </div>
            @else
                <p class="text-center text-red-500">تحلیل با خطا مواجه شد. لطفاً مودال را بسته و دوباره تلاش کنید.</p>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showAnalysisModal', false)">بستن</x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    {{-- [NEW] Image Analysis Results Modal --}}
    <x-dialog-modal wire:model.live="showImageAnalysisModal">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-scan-line class="w-6 h-6 ml-2 text-blue-500"/>
                نتایج تحلیل تصویر
            </div>
        </x-slot>
        <x-slot name="content">
            @if($isAnalyzingImage)
                <div class="text-center py-8">
                    <div class="spinner-border" role="status"></div>
                    <p class="mt-2">در حال تحلیل تصویر، لطفاً منتظر بمانید...</p>
                </div>
            @elseif($imageAnalysisResult)
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 items-center">
                    <div>
                        <img src="{{ $analyzingAttachment ? Storage::url($analyzingAttachment->file_path) : '' }}" alt="Analyzed Image" class="rounded-lg shadow-md">
                    </div>
                    <div class="space-y-4">
                        <div>
                            <h3 class="font-semibold text-gray-500">تعداد سلول تخمینی</h3>
                            <p class="text-3xl font-bold text-blue-600">{{ $imageAnalysisResult['cell_count'] }}</p>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-500">مشاهدات</h3>
                            <p class="text-gray-700">{{ $imageAnalysisResult['observation'] }}</p>
                        </div>
                    </div>
                </div>
            @else
                <p class="text-center text-red-500">تحلیل با خطا مواجه شد.</p>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showImageAnalysisModal', false)">بستن</x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Modal to select an entry for cross-linking -->
    <x-dialog-modal wire:model.live="showEntrySelectorModal" maxWidth="2xl">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-link-2 class="w-6 h-6 ml-2 text-purple-500"/>
                <span class="text-lg font-bold">انتخاب یادداشت برای ارجاع</span>
            </div>
        </x-slot>
        <x-slot name="content">
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                روی یادداشت مورد نظر کلیک کنید تا شناسه‌ی آن (`[[identityId]]`) در ویرایشگر درج شود.
            </p>
            <div class="space-y-2 max-h-[60vh] overflow-y-auto border-t border-b dark:border-gray-700 py-2">
                @forelse($projectEntries as $projectEntry)
                    <div wire:click="insertEntrySku('{{ $projectEntry->sku }}')"
                         class="p-3 rounded-lg hover:bg-purple-50 dark:hover:bg-purple-900/50 cursor-pointer transition">
                        <p class="font-semibold text-gray-800 dark:text-gray-700">{{ $projectEntry->title }}</p>
                        <p class="text-xs text-gray-500 dark:text-blue-500 font-mono">{{ $projectEntry->sku }}</p>
                    </div>
                @empty
                    <div class="text-center py-8 text-gray-500">
                        <p>یادداشت دیگری برای ارجاع در این طرح یافت نشد.</p>
                    </div>
                @endforelse
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showEntrySelectorModal', false)">
                {{ __('انصراف') }}
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Modal for Content Preview -->
    <x-dialog-modal wire:model.live="showContentPreviewModal" maxWidth="2xl">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-eye class="w-6 h-6 ml-2 text-cyan-500"/>
                <span class="text-lg font-bold">پیش‌نمایش محتوا</span>
            </div>
        </x-slot>
        <x-slot name="content">
            <div class="prose dark:prose-invert max-w-none mt-4 max-h-[70vh] overflow-y-auto pr-2 jodit-container">
                {!! $previewHtml !!}
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showContentPreviewModal', false)">
                {{ __('بستن') }}
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- [NEW] Modal for Linked Entry Preview (copied from lab-notebook.blade.php) -->
    <x-dialog-modal wire:model.live="showPreviewModal" maxWidth="2xl">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-file-search class="w-6 h-6 ml-2 text-blue-500"/>
                <span class="text-lg font-bold">پیش‌نمایش یادداشت ارجاع داده شده</span>
            </div>
        </x-slot>
        <x-slot name="content">
            @if ($previewingEntry)
                <div class="space-y-4">
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white">{{ $previewingEntry->title }}</h2>
                    <div class="text-sm text-gray-500 dark:text-gray-400 border-b dark:border-gray-700 pb-3">
                        <span>ثبت توسط: {{ $previewingEntry->user->full_name }}</span>
                        <span class="mx-2">|</span>
                        <span>شناسه: {{ $previewingEntry->sku }}</span>
                    </div>
                    <div class="prose dark:prose-invert max-w-none mt-4 max-h-[60vh] overflow-y-auto pr-2 jodit-container">
                        {!! $previewingEntry->processed_body !!}
                    </div>
                </div>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showPreviewModal', false)">
                {{ __('بستن') }}
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>


    {{-- Jodit Editor via CDN --}}

    <script src="https://cdn.jsdelivr.net/npm/jodit@latest/es2021/jodit.fat.min.js"></script>
    <livewire:version-viewer-modal />
    {{-- [NEW] Add the Version Comparison Modal component to the page --}}
    <livewire:version-comparison-modal />
    @livewire('lab-notebook-chart-modal')
    @livewire('instrument-data-importer')

</div>
