{{-- modal-auditor-form.blade.php --}}
<x-dialog-modal wire:model.live="confirmingAuditorCreation">
    <x-slot name="title">
        <h3 class="text-xl font-bold text-gray-800 dark:text-gray-200">
            {{ $editingAuditor ? 'ویرایش بازرس' : 'ایجاد بازرس جدید' }}
        </h3>
    </x-slot>

    <x-slot name="content">
        <div class="space-y-5">
            <div>
                <x-label for="auditor_team" value="تیم تحقیقاتی" />
                <select id="auditor_team" wire:model.defer="auditorState.research_team_id" class="mt-1 block w-full form-select">
                    <option value="">انتخاب کنید...</option>
                    @foreach($managedTeams as $team)
                        <option value="{{ $team->id }}">{{ $team->name }}</option>
                    @endforeach
                </select>
                <x-input-error for="auditorState.research_team_id" class="mt-2" />
            </div>
            <div>
                <x-label for="auditor_name" value="نام بازرس" />
                <x-input id="auditor_name" type="text" class="mt-1 block w-full" wire:model.defer="auditorState.name" />
                <x-input-error for="auditorState.name" class="mt-2" />
            </div>
            <div>
                <x-label for="auditor_pin" value="پین کد ۴ رقمی" />
                <x-input id="auditor_pin" type="password" class="mt-1 block w-full" wire:model.defer="auditorState.pin"
                         placeholder="{{ $editingAuditor ? 'برای تغییر، پین جدید را وارد کنید' : 'یک پین ۴ رقمی وارد کنید' }}" />
                <x-input-error for="auditorState.pin" class="mt-2" />
            </div>
            <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg mt-2">
                <x-checkbox id="is_active" wire:model.defer="auditorState.is_active" />
                <label for="is_active" class="ms-2 text-sm font-medium text-gray-800 dark:text-gray-200">فعال باشد</label>
            </div>
        </div>
    </x-slot>

    <x-slot name="footer">
        <div class="flex justify-start gap-4">
            <x-button class="ms-3" wire:click="saveAuditor">ذخیره</x-button>
            <x-secondary-button wire:click="$set('confirmingAuditorCreation', false)">انصراف</x-secondary-button>
        </div>
    </x-slot>
</x-dialog-modal>
