<x-dialog-modal wire:model.live="confirmingEquipmentAction">
    <x-slot name="title">
        <h3 class="text-xl font-bold text-gray-800 dark:text-gray-200">
            {{ $editingEquipment ? 'ویرایش تجهیز' : 'ایجاد تجهیز جدید' }}
        </h3>
    </x-slot>

    <x-slot name="content">
        <div class="space-y-6">
            {{-- Calibration Fields --}}
            <fieldset class="space-y-4">
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-5">
                    <div>
                        <x-label for="name" value="نام تجهیز" />
                        <x-input id="name" type="text" class="mt-1 block w-full" wire:model.defer="state.name" />
                        <x-input-error for="state.name" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="model" value="مدل" />
                        <x-input id="model" type="text" class="mt-1 block w-full" wire:model.defer="state.model" />
                    </div>
                    <div>
                        <x-label for="serial_number" value="شماره سریال" />
                        <x-input id="serial_number" type="text" class="mt-1 block w-full" wire:model.defer="state.serial_number" />
                    </div>
                    <div>
                        <x-label for="user_defined_id" value="کد شناسایی (دلخواه)" />
                        <x-input id="user_defined_id" type="text" class="mt-1 block w-full" wire:model.defer="state.user_defined_id" />
                    </div>
                    <div class="sm:col-span-2">
                        <x-label for="research_team_id" value="تیم تحقیقاتی" />
                        <select id="research_team_id" wire:model.live="state.research_team_id" class="form-select mt-1 block w-full">
                            <option value="">انتخاب کنید...</option>
                            @foreach($managedTeams as $team)
                                <option value="{{ $team->id }}">{{ $team->name }}</option>
                            @endforeach
                        </select>
                        <x-input-error for="state.research_team_id" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="calibration_interval_days" value="بازه کالیبراسیون (روز)" />
                        <x-input id="calibration_interval_days" type="number" class="mt-1 block w-full" wire:model.live="state.calibration_interval_days" />
                    </div>
                    <div>
                        <x-label for="last_calibration_date" value="تاریخ آخرین کالیبراسیون" />
                        <x-jalali-date-picker id="last_calibration_date" wire:model.live="state.last_calibration_date" />
                    </div>
                </div>
            </fieldset>

            <hr class="border-gray-200 dark:border-gray-600">

            {{-- Temp Log Fields --}}
            <fieldset class="space-y-4">
                <legend class="text-lg font-semibold text-gray-700 dark:text-gray-300">تنظیمات لاگ دما</legend>
                <div>
                    <x-label for="room" value="مکان (اتاق)" />
                    <select id="room" wire:model.defer="state.storage_location_id" class="form-select mt-1 block w-full">
                        <option value="">انتخاب کنید...</option>
                        @foreach($rooms as $room)
                            <option value="{{ $room->id }}">{{ $room->parent?->name ?? 'ساختمان نامشخص' }} - {{ $room->name }}</option>
                        @endforeach
                    </select>
                    <x-input-error for="state.storage_location_id" class="mt-2" />
                </div>
                <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                    <x-checkbox id="requires_temp_log" wire:model.live="state.requires_temp_log" />
                    <label for="requires_temp_log" class="ms-2 text-sm font-medium text-gray-800 dark:text-gray-200">این تجهیز نیاز به ثبت لاگ دما دارد.</label>
                </div>
                @if($state['requires_temp_log'] ?? false)
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 p-4 border border-blue-200 dark:border-blue-800 bg-blue-50 dark:bg-blue-900/30 rounded-lg animate-fade-in">
                        <div>
                            <x-label for="min_temp" value="حداقل دما (°C)" />
                            <x-input id="min_temp" type="number" step="0.01" class="mt-1 block w-full" wire:model.defer="state.min_temp" />
                            <x-input-error for="state.min_temp" class="mt-2" />
                        </div>
                        <div>
                            <x-label for="max_temp" value="حداکثر دما (°C)" />
                            <x-input id="max_temp" type="number" step="0.01" class="mt-1 block w-full" wire:model.defer="state.max_temp" />
                            <x-input-error for="state.max_temp" class="mt-2" />
                        </div>
                    </div>
                @endif
            </fieldset>
        </div>
    </x-slot>

    <x-slot name="footer">
        <div class="flex justify-start gap-4">
            <x-button wire:click="saveEquipment" wire:loading.attr="disabled">
                <span wire:loading.remove wire:target="saveEquipment">ذخیره</span>
                <span wire:loading wire:target="saveEquipment">در حال ذخیره...</span>
            </x-button>
            <x-secondary-button wire:click="$set('confirmingEquipmentAction', false)">انصراف</x-secondary-button>
        </div>
    </x-slot>
</x-dialog-modal>

{{-- Add this to your CSS for the fade-in animation --}}
<style>
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in {
        animation: fade-in 0.3s ease-out forwards;
    }
</style>
