{{--<x-dialog-modal wire:model.live="showingHistoryModal" maxWidth="2xl">--}}
{{--    <x-slot name="title">--}}
{{--        تاریخچه لاگ دمای: {{ $equipmentForHistory?->name }}--}}
{{--    </x-slot>--}}
{{--    <x-slot name="content">--}}
{{--        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">--}}
{{--            --}}{{-- Filters --}}
{{--            <div>--}}
{{--                <x-label value="فیلترها" />--}}
{{--                <div class="space-y-4 p-4 border rounded-lg">--}}
{{--                    <div>--}}
{{--                        <x-label for="historyFilterAuditorId" value="بازرس" />--}}
{{--                        <select wire:model.live="historyFilterAuditorId" id="historyFilterAuditorId" class="form-select mt-1 w-full">--}}
{{--                            <option value="">همه</option>--}}
{{--                            @foreach($auditors as $auditor)--}}
{{--                                <option value="{{ $auditor->id }}">{{ $auditor->name }}</option>--}}
{{--                            @endforeach--}}
{{--                        </select>--}}
{{--                    </div>--}}
{{--                    <div>--}}
{{--                        <x-label for="historyFilterStartDate" value="از تاریخ" />--}}
{{--                        <x-jalali-date-picker id="historyFilterStartDate" wire:model.live="historyFilterStartDate" />--}}
{{--                    </div>--}}
{{--                    <div>--}}
{{--                        <x-label for="historyFilterEndDate" value="تا تاریخ" />--}}
{{--                        <x-jalali-date-picker id="historyFilterEndDate" wire:model.live="historyFilterEndDate" />--}}
{{--                    </div>--}}
{{--                    <x-button wire:click="applyHistoryFilters" class="w-full">اعمال فیلتر</x-button>--}}
{{--                </div>--}}
{{--                <div class="mt-4 space-y-2">--}}
{{--                    <x-secondary-button wire:click="exportHistoryCsv" class="w-full">خروجی CSV</x-secondary-button>--}}
{{--                    <x-secondary-button wire:click="exportHistoryPdf" class="w-full">خروجی PDF</x-secondary-button>--}}
{{--                </div>--}}
{{--            </div>--}}

{{--            --}}{{-- Chart & Table --}}
{{--            <div class="md:col-span-3">--}}
{{--                <div class="mb-4">--}}
{{--                    <canvas id="tempChart"></canvas>--}}
{{--                </div>--}}
{{--                <div class="table-responsive max-h-96">--}}
{{--                    <table class="min-w-full divide-y">--}}
{{--                        <thead>--}}
{{--                        <tr>--}}
{{--                            <th>تاریخ</th>--}}
{{--                            <th>دما</th>--}}
{{--                            <th>بازرس</th>--}}
{{--                            <th>یادداشت</th>--}}
{{--                        </tr>--}}
{{--                        </thead>--}}
{{--                        <tbody>--}}
{{--                        @forelse($historyLogs as $log)--}}
{{--                            <tr>--}}
{{--                                <td>{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>--}}
{{--                                <td>{{ $log->temperature }}°C</td>--}}
{{--                                <td>{{ $log->auditor->name }}</td>--}}
{{--                                <td>{{ $log->notes }}</td>--}}
{{--                            </tr>--}}
{{--                        @empty--}}
{{--                            <tr><td colspan="4" class="text-center">هیچ لاگی یافت نشد.</td></tr>--}}
{{--                        @endforelse--}}
{{--                        </tbody>--}}
{{--                    </table>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </x-slot>--}}
{{--    <x-slot name="footer">--}}
{{--        <x-secondary-button wire:click="$set('showingHistoryModal', false)">بستن</x-secondary-button>--}}
{{--    </x-slot>--}}
{{--</x-dialog-modal>--}}
{{-- modal-history.blade.php --}}
<x-dialog-modal wire:model.live="showingHistoryModal" maxWidth="4xl">
    <x-slot name="title">
        <h3 class="text-xl font-bold text-gray-800 dark:text-gray-200">
            تاریخچه لاگ دمای: <span class="text-blue-600 dark:text-blue-400">{{ $equipmentForHistory?->name }}</span>
        </h3>
    </x-slot>

    <x-slot name="content">
        <div class="flex flex-col lg:flex-row gap-6">

            {{-- Filters & Actions --}}
            <aside class="w-full lg:w-1/4">
                <div class="p-4 bg-gray-50 dark:bg-gray-800/50 rounded-xl border border-gray-200 dark:border-gray-700 space-y-4">
                    <h4 class="text-lg font-semibold text-gray-700 dark:text-gray-300">فیلترها</h4>
                    <div>
                        <x-label for="historyFilterAuditorId" value="بازرس" />
                        <select wire:model.live="historyFilterAuditorId" id="historyFilterAuditorId" class="form-select mt-1 w-full">
                            <option value="">همه بازرسان</option>
                            @foreach($auditors as $auditor)
                                <option value="{{ $auditor->id }}">{{ $auditor->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <x-label for="historyFilterStartDate" value="از تاریخ" />
                        <x-jalali-date-picker id="historyFilterStartDate" wire:model.live="historyFilterStartDate" />
                    </div>
                    <div>
                        <x-label for="historyFilterEndDate" value="تا تاریخ" />
                        <x-jalali-date-picker id="historyFilterEndDate" wire:model.live="historyFilterEndDate" />
                    </div>
                    <x-button wire:click="applyHistoryFilters" class="w-full justify-center">اعمال فیلتر</x-button>
                </div>
                <div class="mt-4 space-y-2">
                    <x-secondary-button wire:click="exportHistoryCsv" class="w-full justify-center">
                        <i class="fa-solid fa-file-csv me-2"></i> خروجی CSV
                    </x-secondary-button>
                    <x-secondary-button wire:click="exportHistoryPdf" class="w-full justify-center">
                        <i class="fa-solid fa-file-pdf me-2"></i> خروجی PDF
                    </x-secondary-button>
                </div>
            </aside>

            {{-- Chart & Table --}}
            <main class="w-full lg:w-3/4">
                {{-- Chart --}}
                <div class="p-4 bg-gray-50 dark:bg-gray-800/50 rounded-xl mb-6">
                    <div wire:ignore>
                        <canvas id="tempChart"></canvas>
                    </div>
                </div>

                {{-- History Table --}}
                <div class="overflow-x-auto max-h-96 border border-gray-200 dark:border-gray-700 rounded-lg">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700/50 sticky top-0">
                        <tr>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase">تاریخ</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase">دما</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase">بازرس</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase">یادداشت</th>
                        </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @forelse($historyLogs as $log)
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/40">
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700 dark:text-gray-300">{{ verta($log->created_at)->format('Y/m/d H:i') }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700 dark:text-gray-300">{{ $log->temperature }}°C</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700 dark:text-gray-300">{{ $log->auditor->name }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $log->notes ?: '-' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-10 text-gray-500 dark:text-gray-400">
                                    <i class="fa-solid fa-table-list fa-2x mb-2"></i>
                                    <p>هیچ لاگی برای نمایش یافت نشد.</p>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </x-slot>

    <x-slot name="footer">
        <x-secondary-button wire:click="$set('showingHistoryModal', false)">بستن</x-secondary-button>
    </x-slot>
</x-dialog-modal>
