<div>
    {{-- Header --}}
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
        <h4 class="text-xl font-bold text-gray-800 dark:text-white mb-3 sm:mb-0">
            لیست بازرسان
        </h4>
        <button wire:click="confirmAuditorCreation"
                class="flex items-center justify-center gap-2 px-5 py-2.5 text-sm font-semibold text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-900 transition-all duration-300">
            <i class="fa-solid fa-plus"></i>
            <span>افزودن بازرس جدید</span>
        </button>
    </div>
    <!-- [NEW] Team Filter -->
    <div class="mb-6">
        <x-label for="team_filter_auditors" value="فیلتر بر اساس تیم" />
        <select id="team_filter_auditors" wire:model.live="teamFilter" class="form-select rounded-md shadow-sm mt-1 block w-full sm:w-1/3">
            <option value="">همه تیم‌های مجاز</option>
            @foreach($managedTeams as $team)
                <option value="{{ $team->id }}">{{ $team->name }}</option>
            @endforeach
        </select>
    </div>
      {{-- Responsive Table/Cards Container --}}
    <div class="overflow-x-auto">
        {{-- Table for larger screens --}}
        <table class="min-w-full hidden sm:table divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th scope="col" class="px-6 py-3 text-right text-xs font-bold text-gray-500 dark:text-gray-300 uppercase tracking-wider">نام</th>
                <th scope="col" class="px-6 py-3 text-right text-xs font-bold text-gray-500 dark:text-gray-300 uppercase tracking-wider">وضعیت</th>
                <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-500 dark:text-gray-300 uppercase tracking-wider">عملیات</th>
            </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
            @forelse ($auditors as $auditor)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors duration-200">
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                        {{ $auditor->name }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($auditor->is_active)
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                <i class="fa-solid fa-check-circle me-1"></i> فعال
                            </span>
                        @else
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                <i class="fa-solid fa-times-circle me-1"></i> غیرفعال
                            </span>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                        <button wire:click="confirmAuditorCreation({{ $auditor->id }})"
                                class="inline-flex items-center gap-2 px-4 py-2 text-xs font-semibold text-white bg-indigo-500 rounded-md hover:bg-indigo-600 focus:outline-none focus:ring-2 focus:ring-indigo-400 transition-all duration-300">
                            <i class="fa-solid fa-pen-to-square"></i> ویرایش
                        </button>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center py-10">
                        <i class="fa-solid fa-users-slash fa-2x text-gray-400 dark:text-gray-500 mb-2"></i>
                        <p class="text-gray-500 dark:text-gray-400 font-semibold">هیچ بازرسی یافت نشد.</p>
                    </td>
                </tr>
            @endforelse
            </tbody>
        </table>

        {{-- Cards for smaller screens --}}
        <div class="grid grid-cols-1 gap-4 sm:hidden">
            @forelse ($auditors as $auditor)
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 space-y-3">
                    <div class="flex justify-between items-center">
                        <p class="text-sm font-semibold text-gray-500 dark:text-gray-400">نام:</p>
                        <p class="text-sm font-bold text-gray-900 dark:text-white">{{ $auditor->name }}</p>
                    </div>
                    <div class="flex justify-between items-center">
                        <p class="text-sm font-semibold text-gray-500 dark:text-gray-400">وضعیت:</p>
                        @if($auditor->is_active)
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                فعال
                            </span>
                        @else
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                غیرفعال
                            </span>
                        @endif
                    </div>
                    <div class="pt-2 border-t border-gray-200 dark:border-gray-700">
                        <button wire:click="confirmAuditorCreation({{ $auditor->id }})"
                                class="w-full mt-2 inline-flex items-center justify-center gap-2 px-4 py-2 text-sm font-semibold text-white bg-indigo-500 rounded-md hover:bg-indigo-600 focus:outline-none focus:ring-2 focus:ring-indigo-400 transition-all duration-300">
                            <i class="fa-solid fa-pen-to-square"></i> ویرایش
                        </button>
                    </div>
                </div>
            @empty
                <div class="text-center py-10 bg-white dark:bg-gray-800 rounded-lg shadow-md">
                    <i class="fa-solid fa-users-slash fa-2x text-gray-400 dark:text-gray-500 mb-2"></i>
                    <p class="text-gray-500 dark:text-gray-400 font-semibold">هیچ بازرسی یافت نشد.</p>
                </div>
            @endforelse
        </div>
    </div>

    {{-- Pagination --}}
    @if ($auditors->hasPages())
        <div class="mt-6">
            {{ $auditors->links() }}
        </div>
    @endif
</div>
