<div>
    {{-- Header & Actions --}}
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
        <div>
            <h4 class="text-xl font-bold text-gray-800 dark:text-white">لیست تجهیزات</h4>
            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">وضعیت کالیبراسیون و سوابق تجهیزات را مدیریت کنید.</p>
        </div>
        <div class="flex items-center gap-2 mt-4 md:mt-0 flex-wrap">
            <x-button wire:click="printSelectedQrCodes" :disabled="empty(array_filter($selectedForPrinting))">
                <i class="fa-solid fa-print me-2"></i> چاپ QR
            </x-button>
            <x-secondary-button wire:click="importFromStorageLocations">
                وارد کردن از انبار</x-secondary-button>
            <x-button wire:click="confirmEquipmentAction">
                <i class="fa-solid fa-plus me-2"></i> افزودن تجهیز
            </x-button>
        </div>
    </div>

    {{-- Filters --}}
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        <div class="relative">
            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                <i class="fa-solid fa-search text-gray-400"></i>
            </span>
            <x-input type="text" wire:model.live.debounce.300ms="search" placeholder="جستجو بر اساس نام، مدل یا سریال..." class="pl-10"/>
        </div>
        <select wire:model.live="teamFilter" class="form-select">
            <option value="">فیلتر بر اساس تیم (همه)</option>
            @foreach($managedTeams as $team)
                <option value="{{ $team->id }}">{{ $team->name }}</option>
            @endforeach
        </select>
    </div>

    {{-- Responsive Container --}}
    <div class="bg-white dark:bg-gray-800/50 rounded-xl overflow-hidden">
        {{-- Table for Desktops --}}
        <div class="overflow-x-auto hidden sm:block">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-800/60">
                <tr>
                    <th class="p-4 text-center"><x-checkbox wire:model.live="selectAll" /></th>
                    <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 dark:text-gray-300 uppercase">تجهیز</th>
                    <th class="px-6 py-3 text-center text-xs font-bold text-gray-500 dark:text-gray-300 uppercase">کالیبراسیون بعدی</th>
                    <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 dark:text-gray-300 uppercase">آخرین تغییر</th>
                    <th class="px-6 py-3 text-center text-xs font-bold text-gray-500 dark:text-gray-300 uppercase">سوابق</th>
                    <th class="px-6 py-3 text-center text-xs font-bold text-gray-500 dark:text-gray-300 uppercase">عملیات</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                @forelse ($equipmentList as $equipment)
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors duration-200">
                        <td class="p-4 text-center"><x-checkbox wire:model.live="selectedForPrinting.{{ $equipment->id }}" /></td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="font-medium text-gray-900 dark:text-white">{{ $equipment->name }}</div>
                            <div class="text-xs text-gray-500">{{ $equipment->model }} | سریال: {{ $equipment->serial_number }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="px-3 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200">
                                {{ $equipment->next_calibration_date ? verta($equipment->next_calibration_date)->format('Y/m/d') : '-' }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $equipment->lastModifiedBy?->name ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center space-x-1 space-x-reverse">
                            <button wire:click="confirmLogCreation({{ $equipment->id }})" class="btn-icon text-green-500 hover:text-green-600" title="ثبت لاگ کالیبراسیون"><i class="fa-solid fa-file-circle-plus"></i></button>
                            <button wire:click="$dispatch('showCalibrationHistory', { equipmentId: {{ $equipment->id }} })" class="btn-icon text-blue-500 hover:text-blue-600" title="مشاهده تاریخچه"><i class="fa-solid fa-clock-rotate-left"></i></button>
                            <a href="{{ route('reports.equipment.temp-log', $equipment) }}" target="_blank" class="btn-icon {{ $equipment->requires_temp_log ? 'text-teal-500 hover:text-teal-600' : 'text-gray-300 dark:text-gray-600 cursor-not-allowed' }}" title="گزارش دما"><i class="fa-solid fa-chart-line"></i></a>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium space-x-1 space-x-reverse">
                            <button wire:click="showQrCode({{ $equipment->id }})" class="btn-icon text-gray-500 hover:text-blue-600" title="نمایش QR Code"><i class="fa-solid fa-qrcode"></i></button>
                            @can('update', $equipment)
                                <button wire:click="confirmEquipmentAction({{ $equipment->id }})" class="btn-icon text-indigo-500 hover:text-indigo-600" title="ویرایش"><i class="fa-solid fa-pen-to-square"></i></button>
                            @endcan
                            @can('delete', $equipment)
                                <button wire:click="confirmEquipmentDeletion({{ $equipment->id }})" class="btn-icon text-red-500 hover:text-red-600" title="حذف"><i class="fa-solid fa-trash-can"></i></button>
                            @endcan
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="7" class="text-center py-12 text-gray-500 dark:text-gray-400"><i class="fa-solid fa-box-open fa-3x mb-3 text-gray-400"></i><p>هیچ تجهیزی یافت نشد.</p></td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        {{-- Cards for Mobile --}}
        <div class="grid grid-cols-1 gap-4 sm:hidden p-4">
            @forelse ($equipmentList as $equipment)
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 space-y-4">
                    <div class="flex justify-between items-start">
                        <div class="flex items-center">
                            <x-checkbox wire:model.live="selectedForPrinting.{{ $equipment->id }}" id="print_mobile_{{ $equipment->id }}" />
                            <label for="print_mobile_{{ $equipment->id }}" class="ms-2">
                                <span class="font-bold text-gray-900 dark:text-white">{{ $equipment->name }}</span>
                                <span class="block text-xs text-gray-500">{{ $equipment->model }}</span>
                            </label>
                        </div>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200">
                            {{ $equipment->next_calibration_date ? verta($equipment->next_calibration_date)->format('Y/m/d') : '-' }}
                        </span>
                    </div>

                    <div class="border-t border-gray-200 dark:border-gray-700 pt-3 flex justify-between items-center">
                        <p class="text-xs text-gray-500 dark:text-gray-400">آخرین تغییر: {{ $equipment->lastModifiedBy?->name ?? '-' }}</p>
                        <div class="flex items-center gap-1">
                            <button wire:click="confirmLogCreation({{ $equipment->id }})" class="btn-icon-mobile text-green-500"><i class="fa-solid fa-file-circle-plus"></i></button>
                            <button wire:click="$dispatch('showCalibrationHistory', { equipmentId: {{ $equipment->id }} })" class="btn-icon-mobile text-blue-500"><i class="fa-solid fa-clock-rotate-left"></i></button>
                            <button wire:click="showQrCode({{ $equipment->id }})" class="btn-icon-mobile text-gray-500"><i class="fa-solid fa-qrcode"></i></button>
                            @can('update', $equipment)
                                <button wire:click="confirmEquipmentAction({{ $equipment->id }})" class="btn-icon-mobile text-indigo-500"><i class="fa-solid fa-pen-to-square"></i></button>
                            @endcan
                            @can('delete', $equipment)
                                <button wire:click="confirmEquipmentDeletion({{ $equipment->id }})" class="btn-icon-mobile text-red-500"><i class="fa-solid fa-trash-can"></i></button>
                            @endcan
                        </div>
                    </div>
                </div>
            @empty
                <div class="text-center py-10 bg-white dark:bg-gray-800 rounded-lg shadow-md">
                    <i class="fa-solid fa-box-open fa-2x text-gray-400 dark:text-gray-500 mb-2"></i>
                    <p class="text-gray-500 dark:text-gray-400 font-semibold">هیچ تجهیزی یافت نشد.</p>
                </div>
            @endforelse
        </div>
    </div>

    {{-- Pagination --}}
    @if ($equipmentList->hasPages())
        <div class="mt-6">
            {{ $equipmentList->links() }}
        </div>
    @endif
</div>

{{-- Add this to your main CSS file for reusable icon buttons if you haven't already --}}
<style>
    .btn-icon { @apply inline-flex items-center justify-center p-2 rounded-full text-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200; }
    .btn-icon-mobile { @apply inline-flex items-center justify-center p-2 rounded-md text-base transition-colors duration-200; }
</style>
