<div>
    {{-- Header --}}
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
        <div>
            <h4 class="text-xl font-bold text-gray-800 dark:text-white">ساختار مکان‌ها</h4>
            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">ساختمان‌ها و اتاق‌های مرتبط را مدیریت کنید.</p>
        </div>
        <x-button wire:click="confirmLocationCreation(null)">
            <i class="fa-solid fa-building-circle-plus me-2"></i> ایجاد ساختمان جدید
        </x-button>
    </div>

    <!-- [NEW] Team Filter -->
    <div class="mb-6">
        <x-label for="team_filter_locations" value="فیلتر بر اساس تیم" />
        <select id="team_filter_locations" wire:model.live="teamFilter" class="form-select rounded-md shadow-sm mt-1 block w-full sm:w-1/3">
            <option value="">همه تیم‌های مجاز</option>
            @foreach($managedTeams as $team)
                <option value="{{ $team->id }}">{{ $team->name }}</option>
            @endforeach
        </select>
    </div>

    {{-- Location Structure --}}
    <div class="space-y-6">
        @forelse ($locations as $building)
            <div class="bg-white dark:bg-gray-800/50 rounded-xl shadow-md overflow-hidden transition-shadow hover:shadow-lg">
                {{-- Building Header --}}
                <div class="p-4 bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-700">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <i class="fa-solid fa-building text-gray-400 me-3"></i>
                            <span class="font-bold text-lg text-gray-800 dark:text-white">{{ $building->name }}</span>
                        </div>
                        <x-secondary-button wire:click="confirmLocationCreation({{ $building->id }})">
                            <i class="fa-solid fa-plus me-2"></i> افزودن اتاق
                        </x-secondary-button>
                    </div>
                </div>

                {{-- Rooms List --}}
                <div class="p-4 space-y-2">
                    @forelse($building->children as $room)
                        <div class="flex justify-between items-center p-3 bg-gray-100 dark:bg-gray-700/60 rounded-lg">
                            <div class="flex items-center">
                                <i class="fa-solid fa-door-open text-gray-500 me-3"></i>
                                <span class="text-gray-700 dark:text-gray-200">{{ $room->name }}</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <button wire:click="showLocationQrCode({{ $room->id }})" class="btn-icon text-gray-500 hover:text-blue-600" title="نمایش QR Code">
                                    <i class="fa-solid fa-qrcode"></i>
                                </button>
                                <a href="{{ route('public.temp-log', $room->uuid) }}" target="_blank" class="btn-icon text-gray-500 hover:text-teal-600" title="لینک عمومی ثبت دما">
                                    <i class="fa-solid fa-arrow-up-right-from-square"></i>
                                </a>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-4 text-sm text-gray-500 dark:text-gray-400">
                            <i class="fa-solid fa-door-closed me-2"></i> هنوز اتاقی به این ساختمان اضافه نشده است.
                        </div>
                    @endforelse
                </div>
            </div>
        @empty
            <div class="text-center py-12 text-gray-500 dark:text-gray-400">
                <i class="fa-solid fa-building-shield fa-3x mb-3 text-gray-400"></i>
                <p>هیچ ساختمانی ثبت نشده است.</p>
                <p class="text-sm mt-2">برای شروع، یک ساختمان جدید ایجاد کنید.</p>
            </div>
        @endforelse
    </div>
</div>
