<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>خروجی یادداشت‌های آزمایشگاه</title>
    <style>
        body {
            font-family: 'Tahoma', sans-serif;
            line-height: 1.6;
            background-color: #f9fafb;
            color: #111827;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #ffffff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #107c54;
            color: white;
            padding: 20px;
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .entry {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
        }
        .entry:last-child {
            border-bottom: none;
        }
        .entry-header {
            margin-bottom: 15px;
        }
        .entry-title {
            font-size: 20px;
            font-weight: bold;
            color: #1f2937;
            margin: 0 0 5px 0;
        }
        .entry-meta {
            font-size: 12px;
            color: #6b7280;
        }
        .entry-body {
            font-size: 14px;
            color: #374151;
        }
        /* Basic styles for content from Jodit Editor */
        .jodit-container {
            line-height: 1.7;
        }
        .jodit-container p {
            margin-bottom: 1rem;
        }
        .jodit-container h1, .jodit-container h2, .jodit-container h3 {
            margin-top: 1.5rem;
            margin-bottom: 1rem;
            font-weight: 600;
        }
        .jodit-container ul, .jodit-container ol {
            padding-right: 20px;
            margin-bottom: 1rem;
        }
        .jodit-container blockquote {
            padding: 10px 20px;
            margin: 0 0 20px;
            font-size: 1rem;
            border-right: 5px solid #e5e7eb;
            background-color: #f9fafb;
        }
        .footer {
            text-align: center;
            padding: 15px;
            font-size: 12px;
            color: #9ca3af;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1>خروجی یادداشت‌های آزمایشگاه</h1>
        <p>پروژه: {{ $project->title }}</p>
    </div>

    @foreach($entries as $entry)
        <div class="entry">
            <div class="entry-header">
                <h2 class="entry-title">{{ $entry->title }}</h2>
                <p class="entry-meta">
                    ثبت توسط: {{ $entry->user->full_name }} |
                    تاریخ ثبت: {{ verta($entry->entry_date)->format('Y/m/d') }}
                </p>
            </div>
            <div class="entry-body jodit-container">
                {!! $entry->body !!}
            </div>
        </div>
    @endforeach

    <div class="footer">
        گزارش تولید شده توسط Benchsync در تاریخ {{ verta()->format('Y/m/d H:i') }}
    </div>
</div>
</body>
</html>
