<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>{{ $entry->title }}</title>
    <style>
        /* This style is optimized for mPDF */
        body {
            font-family: 'tahoma', sans-serif; /* Use a font name mPDF recognizes */
            font-size: 11pt;
            line-height: 1.6;
        }
        .entry-title {
            font-size: 16pt;
            font-weight: bold;
            color: #1E90FF;
            text-align: right;
        }
        .meta-info {
            font-size: 9pt;
            color: #708090;
            text-align: right;
            border-bottom: 1px solid #1E90FF;
            padding-bottom: 5px;
            margin-bottom: 15px;
        }
        .entry-body {
            text-align: right;
        }
        /* Ensure Jodit content is rendered correctly */
        .jodit-container {
            direction: rtl;
        }
    </style>
</head>
<body>
<h1 class="entry-title">{{ $entry->title }}</h1>
<div class="meta-info">
    ثبت توسط: {{ $entry->user->full_name }} | تاریخ ثبت: {{ verta($entry->entry_date)->format('Y/m/d') }}
</div>
<div class="entry-body jodit-container">
    {!! $entry->body !!}
</div>
</body>
</html>
