<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-red-500">
    <div class="p-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
            <i class="fa fa-triangle-exclamation text-red-500 ml-2"></i>
            هشدارهای هوشمند مالی
        </h3>

        <div class="mt-4 space-y-3">
            @forelse ($alerts as $alert)
                <div class="p-3 bg-red-50 dark:bg-red-900/50 rounded-lg">
                    <div class="flex justify-between items-start">
                        <p class="font-semibold text-sm text-red-800 dark:text-red-200">{{ $alert->title }}</p>
                        <button wire:click="acknowledgeAlert({{ $alert->id }})" class="text-xs text-gray-400 hover:text-gray-600" title="خوانده شد">
                            <x-lucide-check class="w-4 h-4"/>
                        </button>
                    </div>
                    <p class="mt-1 text-sm text-red-700 dark:text-red-300">
                        {{ $alert->message }}
                    </p>
                </div>
            @empty
                <div class="text-center py-8">
                    <p class="text-sm text-gray-500">در حال حاضر هیچ هشدار مالی جدیدی وجود ندارد.</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
