<div class="relative flex-1" x-data="{ open: @entangle('showResults') }" @click.away="open = false">
    <div class="relative">
        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
            <x-lucide-search class="w-5 h-5 text-gray-400" />
        </div>
        <input type="text"
               wire:model.live.debounce.300ms="searchQuery"
               @focus="open = true"
               class="block w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md leading-5 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-300 placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
               placeholder="جستجو در طرح‌ها، وظایف، تجهیزات و...">
    </div>

    <div x-show="open"
         x-transition:enter="transition ease-out duration-100"
         x-transition:enter-start="transform opacity-0 scale-95"
         x-transition:enter-end="transform opacity-100 scale-100"
         x-transition:leave="transition ease-in duration-75"
         x-transition:leave-start="transform opacity-100 scale-100"
         x-transition:leave-end="transform opacity-0 scale-95"
         class="absolute z-50 mt-2 w-full md:w-96 rounded-md shadow-lg bg-white dark:bg-gray-800 ring-1 ring-black ring-opacity-5"
         style="display: none;">
        <div class="max-h-96 overflow-y-auto custom-scrollbar">
            <div wire:loading wire:target="searchQuery" class="p-4 text-center text-sm text-gray-500">
                در حال جستجو...
            </div>

            @if(!empty($searchResults))
                @foreach($searchResults as $type => $results)
                    <div class="p-2">
                        <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider px-3 py-2">{{ $type }}</h3>
                        <ul class="mt-1">
                            @foreach($results as $result)
                                <li>
                                    <a href="{{ $result['url'] }}" wire:click="resetSearch" class="flex items-center px-4 py-3 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-md">
                                        <div>
                                            <p class="font-medium">{{ $result['title'] }}</p>
                                            @if($result['subtitle'])
                                                <p class="text-xs text-gray-500 mt-1">{{ $result['subtitle'] }}</p>
                                            @endif
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endforeach
            @elseif(strlen($searchQuery) >= 3)
                <div wire:loading.remove class="p-4 text-center text-sm text-gray-500">
                    هیچ نتیجه‌ای برای "{{ $searchQuery }}" یافت نشد.
                </div>
            @endif
        </div>
    </div>
</div>
