<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('مدیریت نهادها') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">

                {{-- جدول نمایش نهادها --}}
                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <div class="flex justify-between items-center">
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            لیست نهادها
                        </h1>
                        <x-button wire:click="confirmInstitutionAddition">
                            ایجاد نهاد جدید
                        </x-button>
                    </div>

                    <div class="mt-6">
                        @if (session()->has('message'))
                            <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                                {{ session('message') }}
                            </div>
                        @endif
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    نام نهاد
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    کد
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    نوع
                                </th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                    وضعیت
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">عملیات</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($institutions as $institution)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $institution->name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $institution->code }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $institution->type ?? '-' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                        {{ $institution->status }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3 space-x-reverse">
                                        <button wire:click="confirmInstitutionEdit({{ $institution->id }})" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200">
                                            ویرایش
                                        </button>
                                        <button wire:click="confirmInstitutionDeletion({{ $institution->id }})" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-200">
                                            حذف
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-500 dark:text-gray-400">
                                        هیچ نهادی برای نمایش وجود ندارد.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <x-dialog-modal wire:model.live="confirmingInstitutionAddition">
        <x-slot name="title">
            {{ __('ایجاد نهاد جدید') }}
        </x-slot>

        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="name" value="{{ __('نام نهاد') }}" />
                    <x-input id="name" type="text" class="mt-1 block w-full" wire:model.defer="name" />
                    <x-input-error for="name" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="type" value="{{ __('نوع نهاد (مثلا: دانشگاه، پژوهشگاه)') }}" />
                    <x-input id="type" type="text" class="mt-1 block w-full" wire:model.defer="type" />
                    <x-input-error for="type" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="phone" value="{{ __('شماره تماس') }}" />
                    <x-input id="phone" type="text" class="mt-1 block w-full" wire:model.defer="phone" />
                    <x-input-error for="phone" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="website" value="{{ __('وب‌سایت') }}" />
                    <x-input id="website" type="url" class="mt-1 block w-full" wire:model.defer="website" placeholder="http://example.com" />
                    <x-input-error for="website" class="mt-2" />
                </div>
                <div class="col-span-6">
                    <x-label for="address" value="{{ __('آدرس') }}" />
                    <textarea id="address" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="address"></textarea>
                    <x-input-error for="address" class="mt-2" />
                </div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingInstitutionAddition')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-button class="ms-3" wire:click="saveInstitution" wire:loading.attr="disabled">
                {{ __('ذخیره') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <x-dialog-modal wire:model.live="confirmingInstitutionEdit">
        <x-slot name="title">
            {{ __('ویرایش نهاد') }}
        </x-slot>

        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="editing-name" value="{{ __('نام نهاد') }}" />
                    <x-input id="editing-name" type="text" class="mt-1 block w-full" wire:model.defer="editingState.name" />
                    <x-input-error for="editingState.name" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="editing-type" value="{{ __('نوع نهاد') }}" />
                    <x-input id="editing-type" type="text" class="mt-1 block w-full" wire:model.defer="editingState.type" />
                    <x-input-error for="editingState.type" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="editing-phone" value="{{ __('شماره تماس') }}" />
                    <x-input id="editing-phone" type="text" class="mt-1 block w-full" wire:model.defer="editingState.phone" />
                    <x-input-error for="editingState.phone" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-4">
                    <x-label for="editing-website" value="{{ __('وب‌سایت') }}" />
                    <x-input id="editing-website" type="url" class="mt-1 block w-full" wire:model.defer="editingState.website" />
                    <x-input-error for="editingState.website" class="mt-2" />
                </div>
                <div class="col-span-6">
                    <x-label for="editing-address" value="{{ __('آدرس') }}" />
                    <textarea id="editing-address" class="border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm mt-1 block w-full" wire:model.defer="editingState.address"></textarea>
                    <x-input-error for="editingState.address" class="mt-2" />
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingInstitutionEdit', false)" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-button class="ms-3" wire:click="updateInstitution" wire:loading.attr="disabled">
                {{ __('ذخیره تغییرات') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <x-confirmation-modal wire:model.live="confirmingInstitutionDeletion">
        <x-slot name="title">
            {{ __('حذف نهاد') }}
        </x-slot>
        <x-slot name="content">
            {{ __('آیا از حذف این نهاد مطمئن هستید؟ تمام داده‌های مرتبط با این نهاد نیز حذف خواهند شد. این عملیات غیرقابل بازگشت است.') }}
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingInstitutionDeletion')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteInstitution" wire:loading.attr="disabled">
                {{ __('حذف نهاد') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
