<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('شروع به کار با BenchSync') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    @if ($hasPendingRequest)
                        <div class="p-4 text-sm text-blue-700 bg-blue-100 rounded-lg dark:bg-blue-200 dark:text-blue-800">
                            <h3 class="font-bold">درخواست شما در حال بررسی است</h3>
                            <p class="mt-2">شما قبلاً یک درخواست برای ایجاد سازمان ثبت کرده‌اید. لطفاً تا زمان بررسی منتظر بمانید.</p>
                            <p class="mt-2">کد پیگیری شما: <span class="font-mono bg-blue-200 dark:bg-blue-900/50 px-2 py-1 rounded">{{ $pendingRequestTrackingCode }}</span></p>
                        </div>
                    @else
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            به BenchSync خوش آمدید!
                        </h1>
                        <p class="mt-2 text-gray-600 dark:text-gray-400">
                            برای شروع، لطفاً یک سازمان جدید ایجاد کنید یا به یک سازمان موجود بپیوندید.
                        </p>

                        <div class="mt-6" x-data="{ mode: @entangle('mode') }">
                            <!-- Tabs -->
                            <div class="border-b border-gray-200 dark:border-gray-700">
                                <nav class="-mb-px flex space-x-8 space-x-reverse" aria-label="Tabs">
                                    <button @click="mode = 'solo'" :class="{ 'border-indigo-500 text-indigo-600': mode === 'solo', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': mode !== 'solo' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                        عضویت انفرادی
                                    </button>
                                    <button @click="mode = 'create'" :class="{ 'border-indigo-500 text-indigo-600': mode === 'create', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': mode !== 'create' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                        ایجاد سازمان جدید
                                    </button>
                                    <button @click="mode = 'join'" :class="{ 'border-indigo-500 text-indigo-600': mode === 'join', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': mode !== 'join' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                        پیوستن به سازمان موجود
                                    </button>
                                </nav>
                            </div>
                            {{-- [NEW] بخش عضویت انفرادی --}}
                            <div x-show="mode === 'solo'" class="mt-6">
                                <h3 class="text-lg font-medium text-gray-900 dark:text-white">شروع به کار به صورت انفرادی</h3>
                                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                                    با انتخاب این گزینه، یک سازمان و تیم تحقیقاتی شخصی برای شما ایجاد می‌شود. شما می‌توانید بلافاصله از امکانات پایه BenchSync استفاده کرده و در آینده در صورت نیاز، اعضای جدیدی را به تیم خود دعوت کنید.
                                </p>
                                <div class="mt-4">
                                    <x-button wire:click="createPersonalTeam" wire:loading.attr="disabled">
                                        ایجاد تیم شخصی و شروع به کار
                                    </x-button>
                                </div>
                            </div>
                            <!-- Create Institution Form -->
                            <div x-show="mode === 'create'" class="mt-6">
                                <form wire:submit.prevent="confirmInstitutionCreation">
                                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">یک فضای کاری جدید برای سازمان یا تیم تحقیقاتی خود ایجاد کنید.</p>
                                    <div class="flex items-start space-x-3 space-x-reverse">
                                        <div class="flex-grow">
                                            <x-label for="create_name" value="{{ __('نام سازمان / تیم تحقیقاتی') }}" />
                                            <x-input id="create_name" type="text" class="mt-1 block w-full" wire:model.defer="create_name" />
                                            <x-input-error for="create_name" class="mt-2" />
                                        </div>
                                        <x-button class="mt-6">ایجاد سازمان</x-button>
                                    </div>
                                </form>
                            </div>

                            <!-- Join Institution Form -->
                            <div x-show="mode === 'join'" class="mt-6 space-y-4">
                                {{-- ... (کد بخش پیوستن به سازمان بدون تغییر) ... --}}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Multi-step Create Institution Modal -->
    <x-dialog-modal wire:model.live="confirmingInstitutionCreation">
        <x-slot name="title">
            تکمیل اطلاعات سازمان: {{ $create_name }}
        </x-slot>

        <x-slot name="content">
            <div x-data="{ step: @entangle('creationStep') }">
                <!-- Step 1: Basic Info -->
                <div x-show="step === 1" class="space-y-4">
                    <p class="text-sm text-gray-500">مرحله ۱ از ۳: اطلاعات پایه</p>
                    <div>
                        <x-label for="create_type" value="{{ __('نوع سازمان') }}" />
                        <x-input id="create_type" type="text" class="mt-1 block w-full" wire:model.defer="create_type" placeholder="مثلا: دانشگاه، پژوهشگاه، شرکت دانش‌بنیان" />
                        <x-input-error for="create_type" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="field_of_work" value="{{ __('حیطه کاری') }}" />
                        <x-input id="field_of_work" type="text" class="mt-1 block w-full" wire:model.defer="field_of_work" placeholder="مثلا: بیوتکنولوژی، داروسازی، ..." />
                        <x-input-error for="field_of_work" class="mt-2" />
                    </div>
                </div>

                <!-- Step 2: Capacity Info -->
                <div x-show="step === 2" class="space-y-4">
                    <p class="text-sm text-gray-500">مرحله ۲ از ۳: اطلاعات ظرفیت</p>
                    <div>
                        <x-label for="personnel_count" value="{{ __('تعداد پرسنل') }}" />
                        <x-input id="personnel_count" type="number" class="mt-1 block w-full" wire:model.defer="personnel_count" />
                        <x-input-error for="personnel_count" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="desired_teams_count" value="{{ __('تعداد تیم‌های تحقیقاتی مورد نیاز') }}" />
                        <x-input id="desired_teams_count" type="number" class="mt-1 block w-full" wire:model.defer="desired_teams_count" />
                        <x-input-error for="desired_teams_count" class="mt-2" />
                    </div>
                </div>

                <!-- Step 3: Contact Info -->
                <div x-show="step === 3" class="space-y-4">
                    <p class="text-sm text-gray-500">مرحله ۳ از ۳: اطلاعات تماس</p>
                    <div>
                        <x-label for="contact_person_name" value="{{ __('نام فرد رابط') }}" />
                        <x-input id="contact_person_name" type="text" class="mt-1 block w-full" wire:model.defer="contact_person_name" />
                        <x-input-error for="contact_person_name" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="create_phone" value="{{ __('تلفن تماس') }}" />
                        <x-input id="create_phone" type="text" class="mt-1 block w-full" wire:model.defer="create_phone" />
                        <x-input-error for="create_phone" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="create_address" value="{{ __('آدرس') }}" />
                        <textarea id="create_address" wire:model.defer="create_address" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"></textarea>
                        <x-input-error for="create_address" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="create_website" value="{{ __('وب‌سایت (اختیاری)') }}" />
                        <x-input id="create_website" type="url" class="mt-1 block w-full" wire:model.defer="create_website" placeholder="https://example.com" />
                        <x-input-error for="create_website" class="mt-2" />
                    </div>
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <div class="flex justify-between w-full">
                <div>
                    @if($creationStep > 1)
                        <x-secondary-button wire:click="previousStep">
                            مرحله قبل
                        </x-secondary-button>
                    @endif
                </div>
                <div class="flex items-center">
                    <x-secondary-button wire:click="$set('confirmingInstitutionCreation', false)" wire:loading.attr="disabled">
                        {{ __('انصراف') }}
                    </x-secondary-button>

                    @if($creationStep < 3)
                        <x-button class="ms-3" wire:click="nextStep">
                            مرحله بعد
                        </x-button>
                    @else
                        <x-button class="ms-3" wire:click="submitInstitutionCreation">
                            ارسال درخواست
                        </x-button>
                    @endif
                </div>
            </div>
        </x-slot>
    </x-dialog-modal>
</div>

