<div>
    <x-dialog-modal wire:model.live="showModal">
        <x-slot name="title">
            درج داده از فایل (CSV, Excel)
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    فایل خروجی دستگاه خود را انتخاب کنید. سیستم به صورت خودکار داده‌های آن را به یک جدول تبدیل کرده و در یادداشت شما درج می‌کند.
                </p>
                <div>
                    <x-label for="data_file" value="انتخاب فایل" />
                    <input id="data_file" type="file" wire:model="dataFile" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100"/>
                    <div wire:loading wire:target="dataFile" class="mt-2 text-sm text-gray-500">در حال آپلود...</div>
                    <x-input-error for="dataFile" class="mt-2"/>
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showModal', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="importData" wire:loading.attr="disabled">
                <span wire:loading.remove wire:target="importData">
                    درج جدول داده
                </span>
                <span wire:loading wire:target="importData">
                    در حال پردازش...
                </span>
            </x-button>
        </x-slot>
    </x-dialog-modal>
</div>
