<div>
    {{-- این بخش هدر در layout اصلی رندر می‌شود و نیازی به تغییر ندارد --}}
    {{-- <x-slot name="header"> ... </x-slot> --}}

    <div class="space-y-8">
        {{-- کارت اصلی صفحه --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl rounded-2xl">

            <div class="p-6 lg:p-8">
                {{-- هدر بخش --}}
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">
                            مدیریت موجودی انبار
                        </h1>
                        <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">لیست اقلام موجود در انبار را مشاهده و مدیریت کنید.</p>
                    </div>
                    <div class="flex items-center space-x-2 space-x-reverse mt-4 sm:mt-0">
                        @if(count($selectedItems) > 0)
                            <form method="GET" action="{{ route('inventory.items.bulk-barcode') }}" target="_blank">
                                @foreach($selectedItems as $itemId)
                                    <input type="hidden" name="items[]" value="{{ $itemId }}">
                                @endforeach
                                <x-secondary-button type="submit">
                                    <i class="bi bi-printer ml-2"></i>
                                    چاپ برچسب ({{ count($selectedItems) }})
                                </x-secondary-button>
                            </form>
                        @endif
                        <x-button wire:click="confirmItemAddition">
                            <i class="bi bi-plus-circle ml-2"></i>
                            افزودن آیتم جدید
                        </x-button>
                    </div>
                </div>

                {{-- پیام‌های موفقیت --}}
                @if (session()->has('message'))
                    <div class="mb-6 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                        {{ session('message') }}
                    </div>
                @endif
                @if (session()->has('placement'))
                    <div class="mb-6 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                        {{ session('placement') }}
                    </div>
                @endif

                {{-- فرم جستجوی پیشرفته --}}
                <div class="mb-6 p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div class="md:col-span-2">
                            <x-label for="searchQuery" value="{{ __('جستجو (نام یا کد شناسایی)') }}" />
                            <x-input id="searchQuery" type="text" class="mt-1 block w-full" wire:model.live.debounce.300ms="searchQuery" placeholder="نام یا SKU را وارد کنید..."/>
                        </div>
                        <div>
                            <x-label for="searchTeamId" value="{{ __('فیلتر بر اساس تیم') }}" />
                            <select id="searchTeamId" wire:model.live="searchTeamId" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                                <option value="">همه تیم‌ها</option>
                                @foreach($researchTeams as $team)
                                    <option value="{{ $team->id }}">{{ $team->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                {{-- نمایش داده‌ها --}}
                <div class="overflow-x-auto">
                    {{-- جدول برای دسکتاپ --}}
                    <div class="hidden md:block">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                            <tr>
                                <th scope="col" class="p-4"><input type="checkbox" wire:model.live="selectAll" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800"></th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">SKU</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">نام آیتم</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">مقدار</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">پیشبینی اتمام</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">تاریخ انقضا</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">مکان</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">نمای گرافیکی</th>
                                <th scope="col" class="relative px-6 py-3"><span class="sr-only">عملیات</span></th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($items as $item)
                                @php
                                    $rowClass = '';
                                    if ($item->minimum_stock_level) {
                                        if ($item->quantity <= $item->minimum_stock_level) {
                                            $rowClass = 'bg-red-50 dark:bg-red-900/20'; // بحرانی
                                        } elseif ($item->quantity <= $item->minimum_stock_level * 1.2) {
                                            $rowClass = 'bg-yellow-50 dark:bg-yellow-900/20'; // هشدار
                                        }
                                    }
                                @endphp
                                <tr class="{{ $rowClass }} hover:bg-gray-100 dark:hover:bg-gray-700/50 transition-colors duration-200">
                                    <td class="p-4"><input type="checkbox" wire:model.live="selectedItems" value="{{ $item->id }}" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800"></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">{{ $item->sku }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">{{ $item->name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->quantity }} {{ $item->unit }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->predicted_stockout_date ? verta($item->predicted_stockout_date)->format('Y/m/d') : '-' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->expiration_date ? verta($item->expiration_date)->format('Y/m/d') : '-' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->location?->full_path }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center">
                                        {{-- This button will only appear for locations that have rows and columns defined. --}}
                                        @if($item->location && $item->location->rows && $item->location->columns)
                                            <a href="{{ route('inventory.locations.view', $item->location->id) }}" class="text-gray-400 hover:text-blue-600" title="نمایش گرافیکی محفظه">
                                                <x-lucide-layout-grid class="w-5 h-5 mx-auto"/>
                                            </a>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium space-x-4 space-x-reverse">
                                        <button wire:click="viewHistory({{ $item->id }})" class="text-gray-500 hover:text-blue-600" title="تاریخچه"><i class="bi bi-clock-history"></i> تاریخچه</button>
                                        <button wire:click="confirmItemEdit({{ $item->id }})" class="text-gray-500 hover:text-indigo-600" title="ویرایش"><i class="bi bi-pencil-square"></i>ویرایش</button>
                                        <button wire:click="confirmItemDeletion({{ $item->id }})" class="text-gray-500 hover:text-red-600" title="حذف"><i class="bi bi-trash"></i>حذف</button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                        <i class="bi bi-box-seam text-4xl mb-2"></i>
                                        <p>هیچ آیتمی در انبار یافت نشد.</p>
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- لیست کارتی برای موبایل --}}
                    <div class="md:hidden space-y-4">
                        @forelse ($items as $item)
                            @php
                                $cardClass = '';
                                if ($item->minimum_stock_level) {
                                    if ($item->quantity <= $item->minimum_stock_level) {
                                        $cardClass = 'border-l-4 border-red-500'; // بحرانی
                                    } elseif ($item->quantity <= $item->minimum_stock_level * 1.2) {
                                        $cardClass = 'border-l-4 border-yellow-400'; // هشدار
                                    }
                                }
                            @endphp
                            <div class="bg-white dark:bg-gray-800 p-4 rounded-lg shadow-md border dark:border-gray-700 {{ $cardClass }}">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <p class="text-lg font-bold text-gray-900 dark:text-white">{{ $item->name }}</p>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 font-mono mt-1">{{ $item->sku }}</p>
                                    </div>
                                    <input type="checkbox" wire:model.live="selectedItems" value="{{ $item->id }}" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800">
                                </div>
                                <div class="mt-4 pt-4 border-t dark:border-gray-700 space-y-2 text-sm">
                                    <p class="text-gray-600 dark:text-gray-300"><strong>مقدار:</strong> {{ $item->quantity }} {{ $item->unit }}</p>
                                    <p class="text-gray-600 dark:text-gray-300"><strong>تاریخ انقضا:</strong> {{ $item->expiration_date ?? '-' }}</p>
                                    <p class="text-gray-600 dark:text-gray-300"><strong>مکان:</strong> {{ $item->location?->full_path }}</p>
                                </div>
                                <div class="mt-4 pt-4 border-t dark:border-gray-700 flex justify-end space-x-4 space-x-reverse">
                                    <button wire:click="viewHistory({{ $item->id }})" class="text-gray-500 hover:text-blue-600" title="تاریخچه"><i class="bi bi-clock-history text-xl"></i></button>
                                    <button wire:click="confirmItemEdit({{ $item->id }})" class="text-gray-500 hover:text-indigo-600" title="ویرایش"><i class="bi bi-pencil-square text-xl"></i></button>
                                    <button wire:click="confirmItemDeletion({{ $item->id }})" class="text-gray-500 hover:text-red-600" title="حذف"><i class="bi bi-trash text-xl"></i></button>
                                </div>
                            </div>
                        @empty
                            <div class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                <i class="bi bi-box-seam text-4xl mb-2"></i>
                                <p>هیچ آیتمی در انبار یافت نشد.</p>
                            </div>
                        @endforelse
                    </div>
                </div>

                {{-- بخش صفحه‌بندی (Pagination) --}}
                <div class="mt-8">
                    {{-- {{ $items->links() }} --}}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <x-dialog-modal wire:model.live="confirmingItemAddition">
        <x-slot name="title">{{ __('افزودن آیتم جدید به انبار') }}</x-slot>
        <x-slot name="content">
            @error('placement')
            <div class="mb-4 p-4 text-sm text-red-700 bg-red-100 rounded-lg dark:bg-red-200 dark:text-red-800">{{ $message }}</div>
            @enderror
            <form id="addItemForm" wire:submit.prevent="saveItem">
                <div class="grid grid-cols-6 gap-6">
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="selected_team_id" value="{{ __('تیم تحقیقاتی') }}" />
                        <select id="selected_team_id" wire:model.live="selected_team_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                            <option value="">انتخاب کنید...</option>
                            @foreach($researchTeams as $team)
                                <option value="{{ $team->id }}">{{ $team->name }}</option>
                            @endforeach
                        </select>
                        <x-input-error for="selected_team_id" class="mt-2" />
                    </div>
                    <div class="col-span-6 sm:col-span-3">
                        <x-label value="{{ __('کد شناسایی (SKU)') }}" />
                        <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-100 dark:bg-gray-700 rounded-md">
                            <span class="text-gray-700 dark:text-gray-300 font-mono tracking-widest">{{ $generatedSku }}</span>
                        </div>
                    </div>
                    @if(count($locations_level_1) > 0)
                        <div class="col-span-6 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
                            <div>
                                <x-label for="selected_level_1" value="{{ __('ساختمان') }}" />
                                <select id="selected_level_1" wire:model.live="selected_level_1" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                    <option value="">...</option>
                                    @foreach($locations_level_1 as $loc)
                                        <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if(count($locations_level_2) > 0)
                                <div>
                                    <x-label for="selected_level_2" value="{{ __('اتاق') }}" />
                                    <select id="selected_level_2" wire:model.live="selected_level_2" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                        <option value="">...</option>
                                        @foreach($locations_level_2 as $loc)
                                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            @if(count($locations_level_3) > 0)
                                <div>
                                    <x-label for="selected_level_3" value="{{ __('فریزر/قفسه') }}" />
                                    <select id="selected_level_3" wire:model.live="selected_level_3" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                        <option value="">...</option>
                                        @foreach($locations_level_3 as $loc)
                                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            @if(count($locations_level_4) > 0)
                                <div>
                                    <x-label for="selected_level_4" value="{{ __('باکس/رک') }}" />
                                    <select id="selected_level_4" wire:model.live="selected_level_4" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                        <option value="">...</option>
                                        @foreach($locations_level_4 as $loc)
                                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            @if(count($locations_level_5) > 0)
                                <div>
                                    <x-label for="selected_level_5" value="{{ __('رک/باکس') }}" />
                                    <select id="selected_level_5" wire:model.live="selected_level_5" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                        <option value="">...</option>
                                        @foreach($locations_level_5 as $loc)
                                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                        </div>
                    @endif
                    @if($selectedBox)
                        <div class="col-span-6 p-4 border-t dark:border-gray-700">
                            <fieldset>
                                <legend class="text-base font-medium text-gray-900 dark:text-white">نحوه جانمایی</legend>
                                <div class="mt-4 space-y-4">
                                    <div class="flex items-center"><input id="placement_auto" wire:model.live="placement_mode" type="radio" value="auto" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300"><label for="placement_auto" class="ms-3 block text-sm font-medium text-gray-700 dark:text-gray-300">جانمایی هوشمند (اولین موقعیت خالی)</label></div>
                                    <div class="flex items-center"><input id="placement_manual" wire:model.live="placement_mode" type="radio" value="manual" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300"><label for="placement_manual" class="ms-3 block text-sm font-medium text-gray-700 dark:text-gray-300">جانمایی دستی</label></div>
                                </div>
                            </fieldset>
                            @if($placement_mode === 'manual')
                                <div class="mt-4">
                                    <div class="grid-container" style="display: grid; grid-template-columns: auto repeat({{ $selectedBox->columns }}, minmax(0, 1fr)); gap: 4px;">
                                        <div></div>
                                        @for ($col = 1; $col <= $selectedBox->columns; $col++)<div class="text-center font-bold text-xs p-1 dark:text-gray-300">{{ $col }}</div>@endfor
                                        @for ($row = 0; $row < $selectedBox->rows; $row++)
                                            <div class="flex items-center justify-center font-bold text-xs p-1 dark:text-gray-300">{{ chr(65 + $row) }}</div>
                                            @for ($col = 1; $col <= $selectedBox->columns; $col++)
                                                @php $position = chr(65 + $row) . $col; @endphp
                                                <button type="button" wire:click="$set('selected_position', '{{ $position }}')" class="h-10 rounded-md text-xs @if(in_array($position, $occupied_positions)) bg-gray-300 dark:bg-gray-600 cursor-not-allowed @elseif($selected_position === $position) bg-green-500 text-white @else bg-gray-100 dark:bg-gray-700 hover:bg-blue-200 dark:hover:bg-blue-600 @endif">{{ $position }}</button>
                                            @endfor
                                        @endfor
                                    </div>
                                    <x-input-error for="selected_position" class="mt-2" />
                                </div>
                            @endif
                        </div>
                    @endif
                    <div class="col-span-6"><x-label for="name" value="{{ __('نام آیتم') }}" /><x-input id="name" type="text" class="mt-1 block w-full" wire:model.defer="name" /><x-input-error for="name" class="mt-2" /></div>
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="item_type" value="{{ __('نوع آیتم') }}" />
                        <select id="item_type" wire:model.defer="item_type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            <option value="">انتخاب کنید...</option><option value="reagent">معرف</option><option value="consumable">ماده مصرفی</option><option value="biological_sample">نمونه بیولوژیکی</option><option value="kit">کیت</option>
                        </select>
                        <x-input-error for="item_type" class="mt-2" />
                    </div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="quantity" value="{{ __('مقدار') }}" /><x-input id="quantity" type="number" step="any" class="mt-1 block w-full" wire:model.defer="quantity" /><x-input-error for="quantity" class="mt-2" /></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="unit" value="{{ __('واحد') }}" /><x-input id="unit" type="text" class="mt-1 block w-full" wire:model.defer="unit" placeholder="مثلا: ml, g, pcs, preps" /><x-input-error for="unit" class="mt-2" /></div>
                    <!-- [NEW] Brand -->
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="brand" value="{{ __('برند (اختیاری)') }}" />
                        <x-input id="brand" type="text" class="mt-1 block w-full" wire:model.defer="brand" />
                        <x-input-error for="brand" class="mt-2" />
                    </div>

                    <!-- [NEW] Lot Number -->
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="lot_number" value="{{ __('شماره بچ/لات (اختیاری)') }}" />
                        <x-input id="lot_number" type="text" class="mt-1 block w-full" wire:model.defer="lot_number" />
                        <x-input-error for="lot_number" class="mt-2" />
                    </div>

                    <!-- [NEW] Price -->
                    <div class="col-span-6 sm:col-span-3">
                        <x-label for="price" value="{{ __('قیمت (اختیاری)') }}" />
                        <x-input id="price" type="number" step="any" class="mt-1 block w-full" wire:model.defer="price" />
                        <x-input-error for="price" class="mt-2" />
                    </div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="minimum_stock_level" value="{{ __('حد آستانه هشدار (مقدار کمینه)') }}" /><x-input id="minimum_stock_level" type="number" step="any" class="mt-1 block w-full" wire:model.defer="minimum_stock_level" /><x-input-error for="minimum_stock_level" class="mt-2" /></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="received_date" value="{{ __('تاریخ دریافت (اختیاری)') }}" /><x-input id="received_date" type="date" class="mt-1 block w-full" wire:model.defer="received_date" /><x-input-error for="received_date" class="mt-2" /></div>
                    <div class="col-span-6 sm:col-span-3"><x-label for="expiration_date" value="{{ __('تاریخ انقضا (اختیاری)') }}" /><x-input id="expiration_date" type="date" class="mt-1 block w-full" wire:model.defer="expiration_date" /><x-input-error for="expiration_date" class="mt-2" /></div>
                </div>
            </form>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingItemAddition')" wire:loading.attr="disabled">{{ __('انصراف') }}</x-secondary-button>
            <x-button class="ms-3" wire:click="saveItem" wire:loading.attr="disabled">{{ __('ذخیره آیتم') }}</x-button>
        </x-slot>
    </x-dialog-modal>


    <x-dialog-modal wire:model.live="confirmingItemEdit">
        <x-slot name="title">{{ __('ویرایش آیتم') }}</x-slot>
        <x-slot name="content">
            <div class="grid grid-cols-6 gap-6">
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="{{ __('کد شناسایی (SKU)') }}" />
                    <div class="mt-1 flex items-center justify-center h-10 w-full bg-gray-200 dark:bg-gray-700 rounded-md">
                        <span class="text-gray-500 dark:text-gray-300 font-mono tracking-widest">{{ $editingState['sku'] ?? '' }}</span>
                    </div>
                </div>
                <div class="col-span-6 sm:col-span-3">
                    <x-label value="{{ __('تیم تحقیقاتی') }}" />
                    <div class="mt-1 flex items-center h-10 w-full"><span class="text-gray-700 dark:text-gray-300">{{ $editingItem?->researchTeam?->name }}</span></div>
                </div>
                <div class="col-span-6"><x-label for="editing-name" value="{{ __('نام آیتم') }}" /><x-input id="editing-name" type="text" class="mt-1 block w-full" wire:model.defer="editingState.name" /><x-input-error for="editingState.name" class="mt-2" /></div>
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-item_type" value="{{ __('نوع آیتم') }}" />
                    <select id="editing-item_type" wire:model.defer="editingState.item_type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                        <option value="reagent">معرف</option><option value="consumable">ماده مصرفی</option><option value="biological_sample">نمونه بیولوژیکی</option><option value="kit">کیت</option>
                    </select>
                    <x-input-error for="editingState.item_type" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-3"><x-label for="editing-quantity" value="{{ __('مقدار') }}" /><x-input id="editing-quantity" type="number" step="any" class="mt-1 block w-full" wire:model.defer="editingState.quantity" /><x-input-error for="editingState.quantity" class="mt-2" /></div>
                <div class="col-span-6 sm:col-span-3"><x-label for="editing-unit" value="{{ __('واحد') }}" /><x-input id="editing-unit" type="text" class="mt-1 block w-full" wire:model.defer="editingState.unit" /><x-input-error for="editingState.unit" class="mt-2" /></div>
                <!-- [NEW] Brand -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-brand" value="{{ __('برند') }}" />
                    <x-input id="editing-brand" type="text" class="mt-1 block w-full" wire:model.defer="editingState.brand" />
                    <x-input-error for="editingState.brand" class="mt-2" />
                </div>

                <!-- [NEW] Lot Number -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-lot_number" value="{{ __('شماره بچ/لات') }}" />
                    <x-input id="editing-lot_number" type="text" class="mt-1 block w-full" wire:model.defer="editingState.lot_number" />
                    <x-input-error for="editingState.lot_number" class="mt-2" />
                </div>

                <!-- [NEW] Price -->
                <div class="col-span-6 sm:col-span-3">
                    <x-label for="editing-price" value="{{ __('قیمت') }}" />
                    <x-input id="editing-price" type="number" step="any" class="mt-1 block w-full" wire:model.defer="editingState.price" />
                    <x-input-error for="editingState.price" class="mt-2" />
                </div>
                <div class="col-span-6 sm:col-span-3"><x-label for="editingState.minimum_stock_level" value="{{ __('حد آستانه هشدار') }}" /><x-input id="editingState.minimum_stock_level" type="number" step="any" class="mt-1 block w-full" wire:model.defer="editingState.minimum_stock_level" /><x-input-error for="editingState.minimum_stock_level" class="mt-2" /></div>
                <div class="col-span-6 sm:col-span-3"><x-label for="editing-received_date" value="{{ __('تاریخ دریافت') }}" /><x-input id="editing-received_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.received_date" /><x-input-error for="editingState.received_date" class="mt-2" /></div>
                <div class="col-span-6 sm:col-span-3"><x-label for="editing-expiration_date" value="{{ __('تاریخ انقضا') }}" /><x-input id="editing-expiration_date" type="date" class="mt-1 block w-full" wire:model.defer="editingState.expiration_date" /><x-input-error for="editingState.expiration_date" class="mt-2" /></div>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingItemEdit', false)" wire:loading.attr="disabled">{{ __('انصراف') }}</x-secondary-button>
            <x-button class="ms-3" wire:click="updateItem" wire:loading.attr="disabled">{{ __('ذخیره تغییرات') }}</x-button>
        </x-slot>
    </x-dialog-modal>
    <x-confirmation-modal wire:model.live="confirmingItemDeletion">
        <x-slot name="title">{{ __('حذف آیتم') }}</x-slot>
        <x-slot name="content">{{ __('آیا از حذف این آیتم از انبار مطمئن هستید؟ این عملیات غیرقابل بازگشت است.') }}</x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingItemDeletion')" wire:loading.attr="disabled">{{ __('انصراف') }}</x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteItem" wire:loading.attr="disabled">{{ __('حذف آیتم') }}</x-danger-button>
        </x-slot>
    </x-confirmation-modal>


    <x-dialog-modal wire:model.live="confirmingHistoryView">
        <x-slot name="title">تاریخچه مصرف: {{ $historyItem?->name }}</x-slot>
        <x-slot name="content">
            @if($historyItem)
                <div class="space-y-2">
                    @forelse($historyItem->notebookEntries as $entry)
                        <div class="p-2 bg-gray-100 dark:bg-blue-200 rounded-md">
                            <p class="text-sm">در تاریخ <span class="font-semibold">{{ $entry->entry_date }}</span> در طرح <a href="{{ route('projects.show', $entry->project) }}" class="text-blue-500 hover:underline">"{{ $entry->project->title }}"</a> مصرف شده است.</p>
                        </div>
                    @empty
                        <p class="text-sm text-gray-500">هیچ سابقه مصرفی برای این آیتم ثبت نشده است.</p>
                    @endforelse
                </div>
            @endif
        </x-slot>
        <x-slot name="footer"><x-secondary-button wire:click="$set('confirmingHistoryView', false)">بستن</x-secondary-button></x-slot>
    </x-dialog-modal>
    <x-dialog-modal wire:model.live="confirmingBoxFullError">
        <x-slot name="title"><span class="text-red-600 flex items-center"><svg class="w-6 h-6 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>ظرفیت تکمیل است</span></x-slot>
        <x-slot name="content">{{ $boxFullErrorMessage }}</x-slot>
        <x-slot name="footer"><x-secondary-button wire:click="$set('confirmingBoxFullError', false)">{{ __('متوجه شدم') }}</x-secondary-button></x-slot>
    </x-dialog-modal>
    <x-dialog-modal wire:model.live="confirmingDeleteError">
        <x-slot name="title"><span class="text-red-600 flex items-center"><svg class="w-6 h-6 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>خطا در حذف آیتم</span></x-slot>
        <x-slot name="content">{{ $deleteErrorMessage }}</x-slot>
        <x-slot name="footer"><x-secondary-button wire:click="$set('confirmingDeleteError', false)">{{ __('متوجه شدم') }}</x-secondary-button></x-slot>
    </x-dialog-modal>



<!-- Modal جدید برای خطای ظرفیت تکمیل -->
    <x-dialog-modal wire:model.live="confirmingBoxFullError">
        <x-slot name="title">
            <span class="text-red-600 flex items-center">
                <svg class="w-6 h-6 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
                ظرفیت تکمیل است
            </span>
        </x-slot>

        <x-slot name="content">
            {{ $boxFullErrorMessage }}
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingBoxFullError', false)">
                {{ __('متوجه شدم') }}
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal جدید برای خطای حذف -->
    <x-dialog-modal wire:model.live="confirmingDeleteError">
        <x-slot name="title">
            <span class="text-red-600 flex items-center">
                <svg class="w-6 h-6 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
                خطا در حذف آیتم
            </span>
        </x-slot>

        <x-slot name="content">
            {{ $deleteErrorMessage }}
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('confirmingDeleteError', false)">
                {{ __('متوجه شدم') }}
            </x-secondary-button>
        </x-slot>
    </x-dialog-modal>
</div>
