<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            گزارش‌گیری انبار
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="flex flex-col lg:flex-row gap-8">

                <!-- Sidebar for Report Selection -->
                <div class="lg:w-1/4">
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 sticky top-24">
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white border-b dark:border-gray-700 pb-3">انواع گزارش</h3>
                        <div class="mt-4 space-y-2">
                            <button wire:click="setActiveReport('expiring_soon')"
                                    class="w-full text-right px-4 py-2 rounded-lg transition {{ $activeReport === 'expiring_soon' ? 'bg-blue-600 text-white' : 'hover:bg-gray-100 dark:hover:bg-gray-700' }}">
                                <x-lucide-calendar-clock class="inline-block w-5 h-5 ml-2"/>
                                اقلام در حال انقضا
                            </button>
                            <button wire:click="setActiveReport('consumption_rate')"
                                    class="w-full text-right px-4 py-2 rounded-lg transition {{ $activeReport === 'consumption_rate' ? 'bg-blue-600 text-white' : 'hover:bg-gray-100 dark:hover:bg-gray-700' }}">
                                <x-lucide-trending-down class="inline-block w-5 h-5 ml-2"/>
                                نرخ مصرف
                            </button>
                            <button wire:click="setActiveReport('cost_report')"
                                    class="w-full text-right px-4 py-2 rounded-lg transition {{ $activeReport === 'cost_report' ? 'bg-blue-600 text-white' : 'hover:bg-gray-100 dark:hover:bg-gray-700' }}">
                                <x-lucide-dollar-sign class="inline-block w-5 h-5 ml-2"/>
                                گزارش هزینه
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Main Content for Filters and Results -->
                <div class="flex-grow">
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg">
                        <div class="p-6 sm:p-8">
                            @if($activeReport === 'expiring_soon')
                                <div>
                                    <h2 class="text-xl font-bold text-gray-900 dark:text-white">گزارش اقلام در حال انقضا</h2>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">لیست آیتم‌هایی که در بازه زمانی مشخص شده منقضی می‌شوند.</p>

                                    {{-- Filters --}}
                                    <div class="mt-6 p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg flex items-center gap-4">
                                        <x-label for="expiryMonths" value="نمایش آیتم‌هایی که در"/>
                                        <select wire:model="expiryMonths" id="expiryMonths" class="form-select rounded-md shadow-sm w-48">
                                            <option value="1">۱ ماه آینده</option>
                                            <option value="3">۳ ماه آینده</option>
                                            <option value="6">۶ ماه آینده</option>
                                            <option value="12">۱۲ ماه آینده</option>
                                        </select>
                                        <x-label value="منقضی می‌شوند."/>
                                        <x-button wire:click="generateReport">اعمال فیلتر</x-button>
                                    </div>

                                    {{-- Results Table --}}
                                    <div class="mt-6 overflow-x-auto">
                                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">نام آیتم</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">شناسه (SKU)</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">تاریخ انقضا</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">مقدار باقیمانده</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">تیم</th>
                                            </tr>
                                            </thead>
                                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                            @forelse ($results as $item)
                                                <tr>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">{{ $item->name }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">{{ $item->sku }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-red-600 dark:text-red-400">{{ verta($item->expiration_date)->format('Y/m/d') }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->quantity }} {{ $item->unit }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $item->researchTeam->name }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                                        هیچ آیتمی با این مشخصات یافت نشد.
                                                    </td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @elseif($activeReport === 'consumption_rate')
                                <div>
                                    <h2 class="text-xl font-bold text-gray-900 dark:text-white">گزارش نرخ مصرف</h2>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">لیست پرمصرف‌ترین آیتم‌ها بر اساس درخواست‌های تایید شده.</p>

                                    {{-- Filters --}}
                                    <div class="mt-6 p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                        <div>
                                            <x-label for="consumptionTimeframe" value="بازه زمانی"/>
                                            <select wire:model="consumptionTimeframe" id="consumptionTimeframe" class="form-select w-full mt-1">
                                                <option value="30">۳۰ روز گذشته</option>
                                                <option value="90">۹۰ روز گذشته</option>
                                                <option value="180">۶ ماه گذشته</option>
                                                <option value="365">یک سال گذشته</option>
                                            </select>
                                        </div>
                                        <div>
                                            <x-label for="consumptionProjectId" value="فیلتر بر اساس طرح"/>
                                            <select wire:model="consumptionProjectId" id="consumptionProjectId" class="form-select w-full mt-1">
                                                <option value="all">همه طرح‌ها</option>
                                                @foreach($projects as $project)
                                                    <option value="{{ $project->id }}">{{ $project->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div>
                                            <x-button wire:click="generateReport" class="w-full justify-center">اعمال فیلتر</x-button>
                                        </div>
                                    </div>

                                    {{-- Results Table --}}
                                    <div class="mt-6 overflow-x-auto">
                                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">رتبه</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">نام آیتم</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">شناسه (SKU)</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">کل مصرف</th>
                                            </tr>
                                            </thead>
                                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                            @forelse ($results as $index => $item)
                                                <tr>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $index + 1 }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">{{ $item->name }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">{{ $item->sku }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-blue-600 dark:text-blue-400">{{ rtrim(rtrim(number_format($item->total_consumed, 4), '0'), '.') }} {{ $item->unit }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="4" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                                        هیچ سابقه مصرفی با این فیلترها یافت نشد.
                                                    </td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @elseif($activeReport === 'cost_report')
                                <div>
                                    <h2 class="text-xl font-bold text-gray-900 dark:text-white">گزارش هزینه مواد مصرفی</h2>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">تحلیل هزینه مواد مصرف شده بر اساس درخواست‌های تایید شده.</p>

                                    {{-- Filters (re-uses the same filters as consumption rate) --}}
                                    <div class="mt-6 p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                        <div>
                                            <x-label for="consumptionTimeframe" value="بازه زمانی"/>
                                            <select wire:model="consumptionTimeframe" id="consumptionTimeframe" class="form-select w-full mt-1">
                                                <option value="30">۳۰ روز گذشته</option>
                                                <option value="90">۹۰ روز گذشته</option>
                                                <option value="180">۶ ماه گذشته</option>
                                                <option value="365">یک سال گذشته</option>
                                            </select>
                                        </div>
                                        <div>
                                            <x-label for="consumptionProjectId" value="فیلتر بر اساس طرح"/>
                                            <select wire:model="consumptionProjectId" id="consumptionProjectId" class="form-select w-full mt-1">
                                                <option value="all">همه طرح‌ها</option>
                                                @foreach($projects as $project)
                                                    <option value="{{ $project->id }}">{{ $project->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div>
                                            <x-button wire:click="generateReport" class="w-full justify-center">اعمال فیلتر</x-button>
                                        </div>
                                    </div>

                                    {{-- Results Table --}}
                                    <div class="mt-6 overflow-x-auto">
                                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">نام آیتم</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">شناسه (SKU)</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">کل مصرف</th>
                                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 dark:text-gray-300 uppercase">هزینه کل</th>
                                            </tr>
                                            </thead>
                                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                            @forelse ($results as $item)
                                                <tr>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">{{ $item->name }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">{{ $item->sku }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ rtrim(rtrim(number_format($item->total_consumed, 4), '0'), '.') }} {{ $item->unit }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-green-600 dark:text-green-400">{{ number_format($item->total_item_cost, 2) }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="4" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                                        هیچ سابقه مصرفی با این فیلترها یافت نشد.
                                                    </td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                            {{-- Grand Total Row --}}
                                            @if($results->isNotEmpty())
                                                <tfoot class="bg-gray-100 dark:bg-gray-900">
                                                <tr>
                                                    <td colspan="3" class="px-6 py-3 text-right text-sm font-bold text-gray-800 dark:text-gray-200">جمع کل هزینه‌ها:</td>
                                                    <td class="px-6 py-3 text-right text-sm font-extrabold text-green-700 dark:text-green-300">{{ number_format($totalCost, 2) }}</td>
                                                </tr>
                                                </tfoot>
                                            @endif
                                        </table>
                                    </div>
                                </div>
                            @endif



                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
