<div>
    {{-- هدر صفحه --}}
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('مدیریت حواله انبار') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    <div class="flex justify-between items-center">
                        <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                            لیست حواله‌های انبار
                        </h1>
                        <x-button wire:click="confirmTransferCreation">
                            ایجاد حواله جدید
                        </x-button>
                    </div>

                    @if (session()->has('message'))
                        <div class="mt-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
                            {{ session('message') }}
                        </div>
                    @endif

                    <div class="mt-6">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">شماره حواله</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">صادر کننده</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">تیم مبدأ</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">تیم مقصد</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">تعداد اقلام</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">تاریخ</th>
                                <th scope="col" class="relative px-6 py-3"><span class="sr-only">عملیات</span></th>
                            </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse($transfers as $transfer)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 font-mono">{{ $transfer->transfer_code }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $transfer->creator->first_name }} {{ $transfer->creator->last_name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $transfer->sourceTeam->name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $transfer->destinationTeam->name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $transfer->items_count }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $transfer->transfer_date }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        @if($transfer->status === 'pending_receipt' && $transfer->created_by_user_id === Auth::id())
                                            <x-danger-button wire:click="confirmRetraction({{ $transfer->id }})">بازپس گیری</x-danger-button>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-400">
                                        هیچ حواله‌ای ثبت نشده است.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

{{--    <!-- Modal برای ایجاد حواله جدید -->--}}
{{--    <x-dialog-modal wire:model.live="confirmingTransferCreation" maxWidth="2xl">--}}
{{--        <x-slot name="title">--}}
{{--            {{ __('ایجاد حواله انبار جدید') }}--}}
{{--        </x-slot>--}}

{{--        <x-slot name="content">--}}
{{--            <div class="space-y-4">--}}
{{--                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">--}}
{{--                    <div>--}}
{{--                        <x-label for="source_team_id" value="{{ __('تیم مبدأ') }}" />--}}
{{--                        <select id="source_team_id" wire:model.live="source_team_id" class="mt-1 block w-full ...">--}}
{{--                            <option value="">انتخاب کنید...</option>--}}
{{--                            @foreach($researchTeams as $team)--}}
{{--                                <option value="{{ $team->id }}">{{ $team->name }}</option>--}}
{{--                            @endforeach--}}
{{--                        </select>--}}
{{--                        <x-input-error for="source_team_id" class="mt-2" />--}}
{{--                    </div>--}}
{{--                    <div>--}}
{{--                        <x-label for="destination_team_id" value="{{ __('تیم مقصد') }}" />--}}
{{--                        <select id="destination_team_id" wire:model.defer="destination_team_id" class="mt-1 block w-full ...">--}}
{{--                            <option value="">انتخاب کنید...</option>--}}
{{--                            @foreach($researchTeams as $team)--}}
{{--                                @if($team->id !== $source_team_id)--}}
{{--                                    <option value="{{ $team->id }}">{{ $team->name }}</option>--}}
{{--                                @endif--}}
{{--                            @endforeach--}}
{{--                        </select>--}}
{{--                        <x-input-error for="destination_team_id" class="mt-2" />--}}
{{--                    </div>--}}
{{--                </div>--}}

{{--                <hr class="my-4 dark:border-gray-600">--}}

{{--                <div class="relative">--}}
{{--                    <x-label for="itemSearch" value="{{ __('افزودن آیتم به حواله') }}" />--}}
{{--                    <x-input id="itemSearch" type="text" class="mt-1 block w-full"--}}
{{--                             wire:model.live.debounce.300ms="itemSearch"--}}
{{--                             placeholder="جستجوی آیتم در انبار مبدأ..."--}}
{{--                             autocomplete="off"--}}
{{--                             :disabled="!$source_team_id"--}}
{{--                    />--}}
{{--                    @if(count($itemSearchResults) > 0)--}}
{{--                        <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border ...">--}}
{{--                            @foreach($itemSearchResults as $result)--}}
{{--                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"--}}
{{--                                    wire:click="addItemToTransfer({{ $result->id }})">--}}
{{--                                    {{ $result->name }} (موجودی: {{ $result->quantity }})--}}
{{--                                </li>--}}
{{--                            @endforeach--}}
{{--                        </ul>--}}
{{--                    @endif--}}
{{--                </div>--}}

{{--                <div class="mt-4 space-y-2">--}}
{{--                    @forelse($transferItems as $index => $item)--}}
{{--                        <div class="flex items-center gap-4 p-2 bg-gray-50 dark:bg-gray-900/50 rounded-md">--}}
{{--                            <div class="flex-grow">--}}
{{--                                <p class="text-sm font-medium text-gray-900 dark:text-gray-200">{{ $item['name'] }}</p>--}}
{{--                                <p class="text-xs text-gray-500 dark:text-gray-400">موجودی: {{ $item['available_quantity'] }} {{ $item['unit'] }}</p>--}}
{{--                            </div>--}}
{{--                            <div class="w-40">--}}
{{--                                <x-input type="number" step="any" class="mt-1 block w-full"--}}
{{--                                         placeholder="مقدار انتقال"--}}
{{--                                         wire:model.defer="transferItems.{{ $index }}.quantity_transferred" />--}}
{{--                            </div>--}}
{{--                            <button type="button" wire:click="removeItem({{ $item['id'] }})" class="text-red-500 hover:text-red-700">&times;</button>--}}
{{--                        </div>--}}
{{--                        <x-input-error for="transferItems.{{$index}}.quantity_transferred" class="mt-1" />--}}
{{--                    @empty--}}
{{--                        <p class="text-sm text-center text-gray-500">هیچ آیتمی برای انتقال انتخاب نشده است.</p>--}}
{{--                    @endforelse--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </x-slot>--}}

{{--        <x-slot name="footer">--}}
{{--            <x-secondary-button wire:click="$toggle('confirmingTransferCreation')" wire:loading.attr="disabled">--}}
{{--                {{ __('انصراف') }}--}}
{{--            </x-secondary-button>--}}

{{--            <x-button class="ms-3" wire:click="saveTransfer" wire:loading.attr="disabled">--}}
{{--                {{ __('ثبت حواله') }}--}}
{{--            </x-button>--}}
{{--        </x-slot>--}}
{{--    </x-dialog-modal>--}}

    <!-- Modal برای ایجاد حواله جدید -->
    <x-dialog-modal wire:model.live="confirmingTransferCreation" maxWidth="2xl">
        <x-slot name="title">
            {{ __('ایجاد حواله انبار جدید') }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <x-label for="source_team_id" value="{{ __('تیم مبدأ') }}" />
                        <select id="source_team_id" wire:model.live="source_team_id" class="mt-1 block w-full ...">
                            <option value="">انتخاب کنید...</option>
                            @foreach($researchTeams as $team)
                                <option value="{{ $team->id }}">{{ $team->name }}</option>
                            @endforeach
                        </select>
                        <x-input-error for="source_team_id" class="mt-2" />
                    </div>
                    {{-- کادر جستجوی جدید برای تیم مقصد --}}
                    <div class="relative">
                        <x-label for="destinationTeamSearch" value="{{ __('تیم مقصد') }}" />
                        <x-input id="destinationTeamSearch" type="text" class="mt-1 block w-full"
                                 wire:model.live.debounce.300ms="destinationTeamSearch"
                                 placeholder="جستجوی تیم..."
                                 autocomplete="off"
                        />
                        @if($destination_team_id)
                            <button type="button" wire:click="$set('destination_team_id', null); $set('destinationTeamSearch', '')" class="absolute top-8 left-2 text-red-500 hover:text-red-700">&times;</button>
                        @endif

                        @if(count($destinationTeamSearchResults) > 0)
                            <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border ...">
                                @foreach($destinationTeamSearchResults as $team)
                                    <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                        wire:click="selectDestinationTeam({{ $team->id }})">
                                        {{ $team->name }}
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                        <x-input-error for="destination_team_id" class="mt-2" />
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <div>
                        <x-label for="transfer_date" value="{{ __('تاریخ حواله') }}" />
                        <x-input id="transfer_date" type="date" class="mt-1 block w-full"
                                 wire:model.defer="transfer_date" />
                        <x-input-error for="transfer_date" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="notes" value="{{ __('توضیحات (اختیاری)') }}" />
                        <x-input id="notes" type="text" class="mt-1 block w-full"
                                 wire:model.defer="notes" />
                        <x-input-error for="notes" class="mt-2" />
                    </div>
                </div>
                <hr class="my-4 dark:border-gray-600">

                <div class="relative">
                    <x-label for="itemSearch" value="{{ __('افزودن آیتم به حواله') }}" />
                    <x-input id="itemSearch" type="text" class="mt-1 block w-full"
                             wire:model.live.debounce.300ms="itemSearch"
                             placeholder="جستجوی آیتم در انبار مبدأ..."
                             autocomplete="off"
                             :disabled="!$source_team_id"
                    />
                    @if(count($itemSearchResults) > 0)
                        <ul class="absolute z-10 w-full bg-white dark:bg-gray-700 border ...">
                            @foreach($itemSearchResults as $result)
                                <li class="px-4 py-2 cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600"
                                    wire:click="addItemToTransfer({{ $result->id }})">
                                    {{ $result->name }} (موجودی: {{ $result->quantity }})
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>

                <div class="mt-4 space-y-2">
                    @forelse($transferItems as $index => $item)
                        <div class="flex items-center gap-4 p-2 bg-gray-50 dark:bg-gray-900/50 rounded-md">
                            <div class="flex-grow">
                                <p class="text-sm font-medium text-gray-900 dark:text-gray-200">{{ $item['name'] }}</p>
                                <p class="text-xs text-gray-500 dark:text-gray-400">موجودی: {{ $item['available_quantity'] }} {{ $item['unit'] }}</p>
                            </div>
                            <div class="w-40">
                                <x-input type="number" step="any" class="mt-1 block w-full"
                                         placeholder="مقدار انتقال"
                                         wire:model.defer="transferItems.{{ $index }}.quantity_transferred" />
                            </div>
                            <!-- نمایش خطای سفارشی -->
                            @error('transferItems.' . $index . '.quantity_transferred')
                            <div class="mt-1 text-sm text-red-600 dark:text-red-400">
                                {{ $message }}
                            </div>
                            @enderror

                            <button type="button" wire:click="removeItem({{ $item['id'] }})" class="text-red-500 hover:text-red-700">&times;</button>
                        </div>
{{--                        <x-input-error for="transferItems.{{$index}}.quantity_transferred" class="mt-1" />--}}
                    @empty
                        <p class="text-sm text-center text-gray-500">هیچ آیتمی برای انتقال انتخاب نشده است.</p>
                    @endforelse
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingTransferCreation')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>

            <x-button class="ms-3" wire:click="saveTransfer" wire:loading.attr="disabled">
                {{ __('ثبت حواله') }}
            </x-button>
        </x-slot>
    </x-dialog-modal>

    <!-- Modal برای تایید بازپس گیری حواله -->
    <x-confirmation-modal wire:model.live="confirmingRetraction">
        <x-slot name="title">
            {{ __('بازپس گیری حواله انبار') }}
        </x-slot>

        <x-slot name="content">
            {{ __('آیا از بازپس گیری این حواله مطمئن هستید؟ با این کار، حواله حذف و موجودی آیتم‌ها به انبار مبدأ بازگردانده می‌شود.') }}
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingRetraction')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>

            <x-danger-button class="ms-3" wire:click="retractTransfer" wire:loading.attr="disabled">
                {{ __('بله، بازپس بگیر') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
