<div>
    <x-dialog-modal wire:model.live="showModal" maxWidth="2xl">
        <x-slot name="title">
            ایجاد نمودار جدید
        </x-slot>

        <x-slot name="content">
            <div
                x-data="{
                    chart: null,
                    initChart(data) {
                        const ctx = this.$refs.canvas.getContext('2d');
                        if (this.chart) {
                            this.chart.destroy();
                        }
                        this.chart = new Chart(ctx, {
                            type: data.chartType,
                            data: {
                                labels: data.labels.split(',').map(s => s.trim()),
                                datasets: data.datasets.map(ds => ({
                                    label: ds.label,
                                    data: ds.data.split(',').map(n => parseFloat(n.trim())),
                                    backgroundColor: ds.backgroundColor,
                                    borderColor: ds.backgroundColor,
                                    borderWidth: 1
                                }))
                            },
                            options: {
                                responsive: true,
                                plugins: {
                                    title: {
                                        display: true,
                                        text: data.chartTitle,
                                        font: { size: 16, family: 'Vazirmatn' }
                                    },
                                    legend: {
                                        labels: { font: { family: 'Vazirmatn' } }
                                    }
                                },
                                scales: {
                                    y: { ticks: { font: { family: 'Vazirmatn' } } },
                                    x: { ticks: { font: { family: 'Vazirmatn' } } }
                                }
                            }
                        });
                    },
                    insertChart() {
                        if (!this.chart) {
                            alert('ابتدا باید یک نمودار تولید کنید.');
                            return;
                        }
                        const imageData = this.chart.toBase64Image();
                        window.dispatchEvent(new CustomEvent('insert-chart-in-editor', { detail: { imageData: imageData } }));
                        @this.set('showModal', false);
                    }
                }"
                @render-chart.window="initChart($event.detail.data)"
                {{-- [FIX] The listener for the dispatched event is now here --}}
                @dispatch-insert-chart.window="insertChart()"
            >
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <!-- Form Column -->
                    <div class="space-y-4">
                        <div>
                            <x-label for="chart_title" value="عنوان نمودار" />
                            <x-input id="chart_title" type="text" class="w-full mt-1" wire:model.defer="chartTitle" />
                            <x-input-error for="chartTitle" class="mt-2"/>
                        </div>
                        <div>
                            <x-label for="chart_type" value="نوع نمودار" />
                            <select id="chart_type" wire:model.defer="chartType" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm">
                                <option value="bar">میله‌ای (Bar)</option>
                                <option value="line">خطی (Line)</option>
                                <option value="pie">دایره‌ای (Pie)</option>
                            </select>
                        </div>
                        <div>
                            <x-label for="labels" value="برچسب‌ها (با کاما جدا کنید)" />
                            <x-input id="labels" type="text" class="w-full mt-1" wire:model.defer="labels" placeholder="مثال: نمونه ۱, نمونه ۲, نمونه ۳" />
                            <x-input-error for="labels" class="mt-2"/>
                        </div>

                        <hr class="dark:border-gray-600"/>

                        <!-- Datasets -->
                        <div class="space-y-3">
                            @foreach($datasets as $index => $dataset)
                                <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg border dark:border-gray-600">
                                    <div class="flex justify-between items-center mb-2">
                                        <h4 class="font-semibold">مجموعه داده #{{ $index + 1 }}</h4>
                                        <button type="button" wire:click="removeDataset({{ $index }})" class="text-red-500 hover:text-red-700">&times; حذف</button>
                                    </div>
                                    <div class="space-y-2">
                                        <x-input type="text" class="w-full" wire:model.defer="datasets.{{ $index }}.label" placeholder="عنوان مجموعه داده"/>
                                        <x-input-error for="datasets.{{ $index }}.label" class="mt-1"/>
                                        <x-input type="text" class="w-full" wire:model.defer="datasets.{{ $index }}.data" placeholder="داده‌ها (با کاما جدا کنید)"/>
                                        <x-input-error for="datasets.{{ $index }}.data" class="mt-1"/>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <x-secondary-button type="button" wire:click="addDataset">افزودن مجموعه داده</x-secondary-button>
                    </div>

                    <!-- Chart Preview Column -->
                    <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-lg flex items-center justify-center">
                        <canvas x-ref="canvas"></canvas>
                    </div>
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showModal', false)">انصراف</x-secondary-button>
            <x-button class="ms-3" wire:click="generateChart">تولید پیش‌نمایش</x-button>
            {{-- [FIX] This button now dispatches an event instead of calling the function directly --}}
            <x-button class="ms-3 bg-green-600 hover:bg-green-700" @click="$dispatch('dispatch-insert-chart')">
                درج در یادداشت
            </x-button>
        </x-slot>
    </x-dialog-modal>
</div>
