<div>
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-t-4 border-emerald-600">
        <div class="p-6 sm:p-8">
{{--             هدر بخش--}}
            <div class="flex flex-col sm:flex-row justify-between sm:items-center gap-4">
                <div class="flex items-center gap-3">
                    <x-lucide-notebook-tabs class="w-8 h-8 text-emerald-600 dark:text-emerald-400" />
                    <div>
                        <h1 class="text-xl font-bold text-gray-900 dark:text-white">
                            دفترچه یادداشت آزمایشگاه (ELN)
                        </h1>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">یادداشت‌های ثبت شده برای این طرح</p>
                    </div>
                </div>

                <div class="flex items-center gap-3">
                    <div x-data="{
        open: false,
        selected: @entangle('selectedEntries').live
     }"
                         x-show="selected.length > 0"
                         x-transition.opacity
                         class="relative">

                        <button @click="open = !open" class="inline-flex items-center justify-center gap-2 px-4 py-2 bg-gray-700 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-600">
                            خروجی (<span x-text="selected.length"></span> مورد)
                            <x-lucide-chevron-down class="w-4 h-4 transition-transform"/>
                        </button>

                        <div x-show="open"
                             @click.away="open = false"
                             class="absolute z-50 mt-2 w-48 rounded-md shadow-lg origin-top-left left-0"
                             x-transition
                             style="display: none;">
                            <div class="rounded-md ring-1 ring-black ring-opacity-5 py-1 bg-white dark:bg-gray-700">
                                <a href="#" wire:click.prevent="exportSelected('html')" class="block w-full text-left px-4 py-2 text-sm text-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600">HTML</a>
                                <a href="#" wire:click.prevent="exportSelected('word')" class="block w-full text-left px-4 py-2 text-sm text-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600">Word (DOCX)</a>
                                <a href="#" wire:click.prevent="exportSelected('zip')" class="block w-full text-left px-4 py-2 text-sm text-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600">ZIP (با پیوست‌ها)</a>
                            </div>
                        </div>
                    </div>
                    @can('create', [App\Models\LabNotebookEntry::class, $project])
                        <a href="{{ route('projects.entries.create', $project) }}" class="inline-flex items-center justify-center px-4 py-2 bg-emerald-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-emerald-700 focus:ring-emerald-500 transition ease-in-out duration-150">
                            <x-lucide-plus class="w-4 h-4 ml-2"/>
                            افزودن یادداشت جدید
                        </a>
                    @endcan
                </div>
            </div>

{{--             پیام موفقیت--}}
            @if (session()->has('message'))
                <div class="mt-4 p-4 text-sm text-green-800 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
                    {{ session('message') }}
                </div>
            @endif

{{--             لیست آکاردئونی یادداشت‌ها--}}
            <div class="mt-8 space-y-4">
                @forelse ($entries as $entry)
                    <div x-data="{ open: false }" class="bg-stone-50 dark:bg-gray-900/50 rounded-lg border border-gray-200 dark:border-gray-700">
{{--                         هدر آکاردئون--}}
                        <div class="flex items-center justify-between p-4 cursor-pointer" @click="open = !open">
                            <div class="flex items-center gap-3">
                                <input type="checkbox" value="{{ $entry->id }}" wire:model.live="selectedEntries"
                                       @click.stop=""
                                       class="ml-2 w-5 h-5 rounded border-gray-300 dark:bg-gray-900 dark:border-gray-600 text-emerald-600 focus:ring-emerald-500">

                                @if($entry->is_locked)
                                    <x-lucide-lock class="w-5 h-5 text-gray-400 flex-shrink-0" title="این یادداشت قفل شده است"/>
                                @else
                                    <x-lucide-file-text class="w-5 h-5 text-emerald-500 flex-shrink-0"/>
                                @endif
                                <div>
                                    <h3 class="font-semibold text-gray-900 dark:text-white">{{ $entry->title }}</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        ثبت توسط {{ $entry->user->first_name }} در تاریخ {{ $entry->entry_date ? verta($entry->entry_date)->format('Y/m/d') : '-' }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                @can('update', $entry)
                                    <a href="{{ route('entries.edit', $entry) }}" @click.stop="" class="p-2 text-gray-500 hover:text-blue-600 rounded-full hover:bg-blue-100 dark:hover:bg-blue-900/50 transition" title="ویرایش">
                                        <x-lucide-file-pen-line class="w-5 h-5"/>
                                    </a>
                                    <button wire:click.stop="confirmEntryDeletion({{ $entry->id }})" class="p-2 text-gray-500 hover:text-red-600 rounded-full hover:bg-red-100 dark:hover:bg-red-900/50 transition" title="حذف">
                                        <x-lucide-trash-2 class="w-5 h-5"/>
                                    </button>
                                @endcan
                                <x-lucide-chevron-down class="w-5 h-5 text-gray-400 transition-transform"  />
                            </div>
                        </div>
{{--                         محتوای بازشو--}}
                        <div x-show="open" x-transition class="p-6 border-t border-gray-200 dark:border-gray-700">
                            <div class="prose dark:prose-invert max-w-none jodit-container">
{{--                                {!! $entry->body !!}--}}
                                {!! $entry->processed_body !!}
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-12 border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg">
                        <x-lucide-file-x-2 class="mx-auto h-12 w-12 text-gray-400" />
                        <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">یادداشتی ثبت نشده</h3>
                        <p class="mt-1 text-sm text-gray-500">هنوز هیچ یادداشتی برای این طرح ثبت نشده است.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    <x-confirmation-modal wire:model.live="confirmingEntryDeletion">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-trash-2 class="w-6 h-6 ml-2 text-red-500"/>
                <span class="text-lg font-bold">{{ __('حذف یادداشت') }}</span>
            </div>
        </x-slot>
        <x-slot name="content">
            {{ __('آیا از حذف این یادداشت مطمئن هستید؟ این عملیات غیرقابل بازگشت است.') }}
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmingEntryDeletion')" wire:loading.attr="disabled">
                {{ __('انصراف') }}
            </x-secondary-button>
            <x-danger-button class="ms-3" wire:click="deleteEntry" wire:loading.attr="disabled">
                {{ __('بله، حذف کن') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>

    <!-- [NEW] Modal for Entry Preview -->
    <x-dialog-modal wire:model.live="showPreviewModal" maxWidth="2xl">
        <x-slot name="title">
            <div class="flex items-center">
                <x-lucide-file-search class="w-6 h-6 ml-2 text-blue-500"/>
                <span class="text-lg font-bold">پیش‌نمایش یادداشت</span>
            </div>
        </x-slot>
        <x-slot name="content">
            @if ($previewingEntry)
                <div class="space-y-4">
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-black">{{ $previewingEntry->title }}</h2>
                    <div class="text-sm text-gray-500 dark:text-gray-400 border-b dark:border-gray-700 pb-3">
                        <span>ثبت توسط: {{ $previewingEntry->user->first_name }} {{ $previewingEntry->user->last_name }}</span>
                        <span class="mx-2">|</span>
                        <span>تاریخ: {{ verta($previewingEntry->entry_date)->format('Y/m/d') }}</span>
                        <span class="mx-2">|</span>
                        <span>شناسه: {{ $previewingEntry->sku }}</span>
                    </div>
                    <div class="prose dark:prose-invert max-w-none mt-4 max-h-[60vh] overflow-y-auto pr-2 jodit-container">
                        {{-- Use processed_body here as well to allow for nested previews --}}
                        {!! $previewingEntry->processed_body !!}
                    </div>
                </div>
            @endif
        </x-slot>
        <x-slot name="footer">
            <x-secondary-button wire:click="$set('showPreviewModal', false)">
                {{ __('بستن') }}
            </x-secondary-button>
            @if ($previewingEntry)
                <a href="{{ route('entries.edit', $previewingEntry) }}" class="ms-3 inline-flex items-center justify-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700">
                    مشاهده و ویرایش کامل
                </a>
            @endif
        </x-slot>
    </x-dialog-modal>
</div>
