<div>
    {{-- استایل سفارشی برای اسکرول‌بار - بهتر است این استایل به فایل app.css اصلی منتقل شود --}}
    <style>
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #f59e0b; /* amber-500 */
            border-radius: 20px;
        }
        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #d97706; /* amber-600 */
        }
    </style>

    @if($this->lowStockItems->isNotEmpty())
        <div class="bg-amber-50 dark:bg-gray-800/90 border-t-4 border-amber-400 dark:border-amber-500 rounded-xl shadow-lg overflow-hidden">
            <div class="p-6">
                {{-- هدر ویجت --}}
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <x-lucide-alert-triangle class="h-6 w-6 text-amber-500 dark:text-amber-400" />
                    </div>
                    <div class="ml-4 mr-4 flex-1">
                        <h3 class="text-lg font-semibold text-amber-900 dark:text-amber-200">هشدار کمبود موجودی</h3>
                        <p class="mt-1 text-sm text-amber-700 dark:text-amber-400">
                            موجودی آیتم‌های زیر به حد آستانه رسیده است.
                        </p>
                    </div>
                </div>

                {{-- کانتینر اسکرول‌بار به همراه افکت محو شدگی --}}
                <div class="mt-4 relative">
                    {{-- لیست آیتم‌ها با ارتفاع محدود و اسکرول --}}
                    <ul class="divide-y divide-amber-200/60 dark:divide-gray-700 max-h-72 overflow-y-auto pr-2 custom-scrollbar">
                        @foreach($this->lowStockItems as $item)
                            <li class="py-4 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                                {{-- اطلاعات آیتم --}}
                                <div class="flex-grow">
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">
                                        <a href="{{ route('inventory.index') }}" class="hover:underline hover:text-blue-600 dark:hover:text-blue-400">
                                            {{ $item->name }}
                                        </a>
                                    </p>
                                    <p class="text-sm text-gray-500 dark:text-gray-400">
                                        در تیم: <span class="font-semibold">{{ $item->researchTeam->name }}</span>
                                    </p>
                                </div>
                                {{-- موجودی و دکمه حذف --}}
                                <div class="flex items-center gap-4 flex-shrink-0 w-full sm:w-auto justify-between">
                                    <span class="text-xs font-mono px-2.5 py-1 bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300 rounded-full">
                                        موجودی: {{ $item->quantity }} {{ $item->unit }}
                                    </span>
                                    <button wire:click="dismissItem({{ $item->id }})"
                                            type="button"
                                            title="حذف هشدار"
                                            class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200 transition duration-150">
                                        <x-lucide-x class="w-5 h-5" />
                                    </button>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                    {{-- افکت محو شدگی در پایین لیست برای نمایش امکان اسکرول --}}
                    <div class="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-t from-amber-50 dark:from-gray-800/90 to-transparent pointer-events-none" aria-hidden="true"></div>
                </div>
            </div>
        </div>
    @endif
</div>
